/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.Annotation;
import ixa.kaflib.IdentifiableAnnotation;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.Predicate;
import ixa.kaflib.TLinkReferable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TLink
extends IdentifiableAnnotation {
    private TLinkReferable from;
    private TLinkReferable to;
    private String relType;

    TLink(String id, TLinkReferable from, TLinkReferable to, String relType) {
        super(id);
        this.from = from;
        this.to = to;
        this.relType = relType;
    }

    public TLinkReferable getFrom() {
        return this.from;
    }

    public void setFrom(TLinkReferable from) {
        this.from = from;
    }

    public TLinkReferable getTo() {
        return this.to;
    }

    public void setTo(TLinkReferable to) {
        this.to = to;
    }

    public String getFromType() {
        return this.from instanceof Predicate ? "event" : "timex";
    }

    public String getToType() {
        return this.to instanceof Predicate ? "event" : "timex";
    }

    public String getRelType() {
        return this.relType;
    }

    public void setRelType(String relType) {
        this.relType = relType;
    }

    @Override
    Map<KAFDocument.Layer, List<Annotation>> getReferencedAnnotations() {
        HashMap<KAFDocument.Layer, List<Annotation>> referenced = new HashMap<KAFDocument.Layer, List<Annotation>>();
        ArrayList<Annotation> predicates = new ArrayList<Annotation>();
        ArrayList<Annotation> timexes = new ArrayList<Annotation>();
        if (this.from instanceof Predicate) {
            predicates.add((Annotation)((Object)this.from));
        } else {
            timexes.add((Annotation)((Object)this.from));
        }
        if (this.to instanceof Predicate) {
            predicates.add((Annotation)((Object)this.to));
        } else {
            timexes.add((Annotation)((Object)this.to));
        }
        referenced.put(KAFDocument.Layer.SRL, predicates);
        referenced.put(KAFDocument.Layer.TIME_EXPRESSIONS, timexes);
        return referenced;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TLink)) {
            return false;
        }
        TLink ann = (TLink)o;
        return KAFDocument.Utils.areEquals(this.from, ann.from) && KAFDocument.Utils.areEquals(this.to, ann.to) && KAFDocument.Utils.areEquals(this.relType, ann.relType);
    }
}

