/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.Annotation;
import ixa.kaflib.ExternalRef;
import ixa.kaflib.IdentifiableAnnotation;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.SentenceLevelAnnotation;
import ixa.kaflib.Span;
import ixa.kaflib.WF;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Term
extends IdentifiableAnnotation
implements SentenceLevelAnnotation {
    private String type;
    private String lemma;
    private String pos;
    private String morphofeat;
    private String termcase;
    private Sentiment sentiment;
    private List<Term> components;
    private Term head;
    private Span<WF> span;
    private List<ExternalRef> externalReferences;
    private boolean isComponent;
    private Term compound;

    Term(String id, Span<WF> span, boolean isComponent) {
        super(id);
        this.components = new ArrayList<Term>();
        this.span = span;
        this.externalReferences = new ArrayList<ExternalRef>();
        this.isComponent = isComponent;
    }

    Term(Term term, HashMap<String, WF> wfs) {
        super(term.getId());
        this.type = term.type;
        this.lemma = term.lemma;
        this.pos = term.pos;
        this.morphofeat = term.morphofeat;
        this.termcase = term.termcase;
        if (term.hasSentiment()) {
            this.sentiment = new Sentiment(term.sentiment);
        }
        HashMap<String, Term> newComponents = new HashMap<String, Term>();
        this.components = new ArrayList<Term>();
        for (Term component : term.components) {
            Term copyComponent = new Term(component, wfs);
            this.components.add(copyComponent);
            newComponents.put(component.getId(), copyComponent);
        }
        if (term.hasHead()) {
            this.head = (Term)newComponents.get(term.head.getId());
        }
        List<WF> targets = term.span.getTargets();
        ArrayList<WF> copiedTargets = new ArrayList<WF>();
        for (WF wf : targets) {
            WF copiedWf = wfs.get(wf.getId());
            if (copiedWf == null) {
                throw new IllegalStateException("WF not found when copying Term " + term.getId());
            }
            copiedTargets.add(copiedWf);
        }
        if (term.span.hasHead()) {
            WF copiedHead = wfs.get(term.span.getHead().getId());
            this.span = new Span<WF>(copiedTargets, copiedHead);
        } else {
            this.span = new Span(copiedTargets);
        }
        this.externalReferences = new ArrayList<ExternalRef>();
        for (ExternalRef externalRef : term.getExternalRefs()) {
            this.externalReferences.add(new ExternalRef(externalRef));
        }
    }

    public boolean hasType() {
        return this.type != null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean hasLemma() {
        return this.lemma != null;
    }

    public String getLemma() {
        return this.lemma;
    }

    public void setLemma(String lemma) {
        this.lemma = lemma;
    }

    public boolean hasPos() {
        return this.pos != null;
    }

    public String getPos() {
        return this.pos;
    }

    public void setPos(String pos) {
        this.pos = pos;
    }

    public boolean hasMorphofeat() {
        return this.morphofeat != null;
    }

    public String getMorphofeat() {
        return this.morphofeat;
    }

    public void setMorphofeat(String morphofeat) {
        this.morphofeat = morphofeat;
    }

    public boolean hasCase() {
        return this.termcase != null;
    }

    public String getCase() {
        return this.termcase;
    }

    public void setCase(String termcase) {
        this.termcase = termcase;
    }

    public String getForm() {
        String str = "";
        for (WF wf : this.span.getTargets()) {
            if (!str.isEmpty()) {
                str = str + " ";
            }
            str = str + wf.getForm();
        }
        return str;
    }

    public String getStr() {
        String strValue = this.getForm();
        boolean valid = false;
        while (!valid) {
            if (strValue.startsWith("-") || strValue.endsWith("-")) {
                strValue = strValue.replace("-", " - ");
                continue;
            }
            if (strValue.contains("--")) {
                strValue = strValue.replace("--", "-");
                continue;
            }
            valid = true;
        }
        return strValue;
    }

    public boolean hasHead() {
        return this.head != null;
    }

    public Term getHead() {
        return this.head;
    }

    public Sentiment createSentiment() {
        Sentiment newSentiment = new Sentiment();
        this.setSentiment(newSentiment);
        return newSentiment;
    }

    public boolean hasSentiment() {
        return this.sentiment != null;
    }

    public Sentiment getSentiment() {
        return this.sentiment;
    }

    public void setSentiment(Sentiment sentiment) {
        this.sentiment = sentiment;
    }

    public List<Term> getComponents() {
        return this.components;
    }

    public void addComponent(Term component) {
        this.components.add(component);
    }

    public void addComponent(Term component, boolean isHead) {
        this.components.add(component);
        if (isHead) {
            this.head = component;
        }
    }

    public List<WF> getWFs() {
        return this.span.getTargets();
    }

    public WF getHeadWF() {
        return this.span.getHead();
    }

    public void addWF(WF wf) {
        this.span.addTarget(wf);
    }

    public void addWF(WF wf, boolean isHead) {
        this.span.addTarget(wf, isHead);
    }

    public Span<WF> getSpan() {
        return this.span;
    }

    public void setSpan(Span<WF> span) {
        this.span = span;
    }

    @Override
    public Integer getSent() {
        Span<WF> wfs = this.getSpan();
        List<WF> wfl = wfs.getTargets();
        WF wf = wfl.get(0);
        if (wf == null) {
            System.out.println(wfl.size());
        }
        Integer sent = wf.getSent();
        return this.getSpan().getTargets().get(0).getSent();
    }

    @Override
    public Integer getPara() {
        return this.getSpan().getTargets().get(0).getPara();
    }

    public List<ExternalRef> getExternalRefs() {
        return this.externalReferences;
    }

    public void addExternalRef(ExternalRef externalRef) {
        this.externalReferences.add(externalRef);
    }

    public void addExternalRefs(List<ExternalRef> externalRefs) {
        this.externalReferences.addAll(externalRefs);
    }

    boolean isComponent() {
        return this.isComponent;
    }

    public void setCompound(Term compound) {
        this.compound = compound;
    }

    public Term getCompound() {
        return this.compound;
    }

    @Override
    Map<KAFDocument.Layer, List<Annotation>> getReferencedAnnotations() {
        HashMap<KAFDocument.Layer, List<Annotation>> referenced = new HashMap<KAFDocument.Layer, List<Annotation>>();
        referenced.put(KAFDocument.Layer.TEXT, this.getSpan().getTargets());
        return referenced;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Term)) {
            return false;
        }
        Term ann = (Term)o;
        return KAFDocument.Utils.areEquals(this.type, ann.type) && KAFDocument.Utils.areEquals(this.lemma, ann.lemma) && KAFDocument.Utils.areEquals(this.pos, ann.pos) && KAFDocument.Utils.areEquals(this.morphofeat, ann.morphofeat) && KAFDocument.Utils.areEquals(this.termcase, ann.termcase) && KAFDocument.Utils.areEquals(this.sentiment, ann.sentiment) && KAFDocument.Utils.areEquals(this.components, ann.components) && KAFDocument.Utils.areEquals(this.head, ann.head) && KAFDocument.Utils.areEquals(this.span, ann.span) && KAFDocument.Utils.areEquals(this.externalReferences, ann.externalReferences) && KAFDocument.Utils.areEquals(this.isComponent, ann.isComponent) && KAFDocument.Utils.areEquals(this.compound, ann.compound);
    }

    public static class Sentiment
    extends Annotation {
        private String resource;
        private String polarity;
        private String strength;
        private String subjectivity;
        private String sentimentSemanticType;
        private String sentimentModifier;
        private String sentimentMarker;
        private String sentimentProductFeature;

        Sentiment() {
        }

        Sentiment(Sentiment sentiment) {
            this.resource = sentiment.resource;
            this.polarity = sentiment.polarity;
            this.strength = sentiment.strength;
            this.subjectivity = sentiment.subjectivity;
            this.sentimentSemanticType = sentiment.sentimentSemanticType;
            this.sentimentModifier = sentiment.sentimentModifier;
            this.sentimentMarker = sentiment.sentimentMarker;
            this.sentimentProductFeature = sentiment.sentimentProductFeature;
        }

        public boolean hasResource() {
            return this.resource != null;
        }

        public String getResource() {
            return this.resource;
        }

        public void setResource(String val) {
            this.resource = val;
        }

        public boolean hasPolarity() {
            return this.polarity != null;
        }

        public String getPolarity() {
            return this.polarity;
        }

        public void setPolarity(String val) {
            this.polarity = val;
        }

        public boolean hasStrength() {
            return this.strength != null;
        }

        public String getStrength() {
            return this.strength;
        }

        public void setStrength(String val) {
            this.strength = val;
        }

        public boolean hasSubjectivity() {
            return this.subjectivity != null;
        }

        public String getSubjectivity() {
            return this.subjectivity;
        }

        public void setSubjectivity(String val) {
            this.subjectivity = val;
        }

        public boolean hasSentimentSemanticType() {
            return this.sentimentSemanticType != null;
        }

        public String getSentimentSemanticType() {
            return this.sentimentSemanticType;
        }

        public void setSentimentSemanticType(String val) {
            this.sentimentSemanticType = val;
        }

        public boolean hasSentimentModifier() {
            return this.sentimentModifier != null;
        }

        public String getSentimentModifier() {
            return this.sentimentModifier;
        }

        public void setSentimentModifier(String val) {
            this.sentimentModifier = val;
        }

        public boolean hasSentimentMarker() {
            return this.sentimentMarker != null;
        }

        public String getSentimentMarker() {
            return this.sentimentMarker;
        }

        public void setSentimentMarker(String val) {
            this.sentimentMarker = val;
        }

        public boolean hasSentimentProductFeature() {
            return this.sentimentProductFeature != null;
        }

        public String getSentimentProductFeature() {
            return this.sentimentProductFeature;
        }

        public void setSentimentProductFeature(String val) {
            this.sentimentProductFeature = val;
        }

        @Override
        Map<KAFDocument.Layer, List<Annotation>> getReferencedAnnotations() {
            return new HashMap<KAFDocument.Layer, List<Annotation>>();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Sentiment)) {
                return false;
            }
            Sentiment ann = (Sentiment)o;
            return KAFDocument.Utils.areEquals(this.resource, ann.resource) && KAFDocument.Utils.areEquals(this.polarity, ann.polarity) && KAFDocument.Utils.areEquals(this.strength, ann.strength) && KAFDocument.Utils.areEquals(this.subjectivity, ann.subjectivity) && KAFDocument.Utils.areEquals(this.sentimentSemanticType, ann.sentimentSemanticType) && KAFDocument.Utils.areEquals(this.sentimentModifier, ann.sentimentModifier) && KAFDocument.Utils.areEquals(this.sentimentMarker, ann.sentimentMarker) && KAFDocument.Utils.areEquals(this.sentimentProductFeature, ann.sentimentProductFeature);
        }
    }
}

