/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.Annotation;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.MultiLayerAnnotation;
import ixa.kaflib.NonTerminal;
import ixa.kaflib.SentenceLevelAnnotation;
import ixa.kaflib.Span;
import ixa.kaflib.Term;
import ixa.kaflib.Terminal;
import ixa.kaflib.TreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class Tree
extends Annotation
implements MultiLayerAnnotation,
SentenceLevelAnnotation {
    private static final String HEAD_MARK = "=H";
    private String type;
    private TreeNode root;

    Tree(TreeNode root, String type) {
        this.root = root;
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public TreeNode getRoot() {
        return this.root;
    }

    public void setRoot(TreeNode root) {
        this.root = root;
    }

    @Override
    Map<KAFDocument.Layer, List<Annotation>> getReferencedAnnotations() {
        HashMap<KAFDocument.Layer, List<Annotation>> referenced = new HashMap<KAFDocument.Layer, List<Annotation>>();
        referenced.put(KAFDocument.Layer.TERMS, this.root.getReferencedAnnotations().get((Object)KAFDocument.Layer.TERMS));
        return referenced;
    }

    static void parenthesesToKaf(String parOut, KAFDocument kaf) throws Exception {
        String[] tokens = Tree.tokenize(parOut);
        Tree.check(tokens);
        HashMap<Integer, Integer> parMatching = Tree.matchParentheses(tokens);
        HashMap<Integer, Term> termMatching = Tree.matchTerms(tokens, kaf.getTerms());
        if (termMatching.size() == 0) {
            return;
        }
        ArrayList trees = new ArrayList();
        int current = 0;
        while (current < tokens.length) {
            int end = parMatching.get(current);
            NonTerminal root = Tree.createNonTerminal(tokens, current + 1, end - 1, parMatching, termMatching, kaf);
            kaf.newConstituent(root);
            current = end + 1;
        }
    }

    private static String[] tokenize(String parOut) {
        ArrayList<String> tokens = new ArrayList<String>();
        int current = 0;
        int length = parOut.length();
        String token = new String("");
        while (current < length) {
            char nextChar;
            if ((nextChar = parOut.charAt(current++)) == '(') {
                if (!token.isEmpty()) {
                    tokens.add(token);
                }
                tokens.add(new String("("));
                token = new String("");
                continue;
            }
            if (nextChar == ')') {
                if (!token.isEmpty()) {
                    tokens.add(token);
                }
                tokens.add(new String(")"));
                token = new String("");
                continue;
            }
            if (nextChar == ' ' || nextChar == '\n') {
                if (token.isEmpty()) continue;
                tokens.add(token);
                token = new String();
                continue;
            }
            token = token + nextChar;
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private static HashMap<Integer, Integer> matchParentheses(String[] tokens) {
        HashMap<Integer, Integer> indexes = new HashMap<Integer, Integer>();
        Stack<Integer> stack = new Stack<Integer>();
        int ind = 0;
        for (String token : tokens) {
            if (token.equals("(")) {
                stack.push(ind);
            } else if (token.equals(")")) {
                indexes.put((Integer)stack.pop(), ind);
            }
            ++ind;
        }
        return indexes;
    }

    private static HashMap<Integer, Term> matchTerms(String[] tokens, List<Term> terms) throws Exception {
        HashMap<Integer, Term> mapping = new HashMap<Integer, Term>();
        int nextTerm = 0;
        for (int i = 1; i < tokens.length; ++i) {
            if (tokens[i].equals("(") || tokens[i].equals(")") || tokens[i - 1].equals("(") || tokens[i - 1].equals(")")) continue;
            String termForm = terms.get(nextTerm).getForm();
            String previousTermForm = "";
            if (nextTerm != 0) {
                previousTermForm = terms.get(nextTerm - 1).getForm();
            }
            if (termForm.equals("(")) {
                termForm = new String("-LRB-");
            } else if (termForm.equals(")")) {
                termForm = new String("-RRB-");
            } else if (termForm.equals("{")) {
                termForm = new String("-LCB-");
            } else if (termForm.equals("}")) {
                termForm = new String("-RCB-");
            } else if (termForm.equals("[")) {
                termForm = new String("-LSB-");
            } else if (termForm.equals("]")) {
                termForm = new String("-RSB-");
            }
            if (termForm.equals(tokens[i]) || termForm.contains(tokens[i])) {
                mapping.put(i, terms.get(nextTerm));
                ++nextTerm;
                continue;
            }
            if (nextTerm > 0 && previousTermForm.contains(tokens[i])) {
                mapping.put(i, terms.get(nextTerm - 1));
                continue;
            }
            boolean matched = false;
            ++nextTerm;
            while (!matched && nextTerm != terms.size()) {
                if (terms.get(nextTerm).getForm().equals(tokens[i])) {
                    mapping.put(i, terms.get(nextTerm));
                    matched = true;
                }
                ++nextTerm;
            }
            if (matched) continue;
            throw new Exception("Can't perform parentheses=>NAF at constituency: form \"" + tokens[i] + "\" not found in the KAF document.");
        }
        return mapping;
    }

    private static NonTerminal createNonTerminal(String[] tokens, int start, int end, HashMap<Integer, Integer> parenthesesMap, HashMap<Integer, Term> termMap, KAFDocument kaf) {
        String tag = tokens[start];
        boolean isHead = Tree.isHead(tag);
        if (isHead) {
            tag = Tree.removeHeadMark(tag);
        }
        NonTerminal nt = kaf.newNonTerminal(tag);
        if (isHead) {
            nt.setHead(true);
        }
        if (end - start == 1) {
            Terminal t = Tree.createTerminal(tokens[end], termMap.get(end), kaf);
            try {
                nt.addChild(t);
            }
            catch (Exception e) {}
        } else {
            int current = start + 1;
            while (current <= end) {
                int subParEnd = parenthesesMap.get(current);
                NonTerminal nnt = Tree.createNonTerminal(tokens, current + 1, subParEnd - 1, parenthesesMap, termMap, kaf);
                try {
                    nt.addChild(nnt);
                }
                catch (Exception e) {
                    // empty catch block
                }
                current = subParEnd + 1;
            }
        }
        return nt;
    }

    private static Terminal createTerminal(String token, Term term, KAFDocument kaf) {
        Span<Term> span = kaf.newTermSpan();
        span.addTarget(term);
        return kaf.newTerminal(span);
    }

    private static void check(String[] tokens) throws Exception {
        int opened = 0;
        for (int i = 0; i < tokens.length; ++i) {
            if (tokens[i].equals("(")) {
                if (i > 0 && tokens[i - 1].equals("(")) {
                    throw Tree.getException(tokens, i);
                }
                if (i == tokens.length - 1) {
                    throw Tree.getException(tokens, i);
                }
                ++opened;
                continue;
            }
            if (tokens[i].equals(")")) {
                if (i < 3 || tokens[i - 1].equals("(")) {
                    throw Tree.getException(tokens, i);
                }
                --opened;
                continue;
            }
            if (i == 0 || i == tokens.length - 1) {
                throw Tree.getException(tokens, i);
            }
            if (Tree.isAWord(tokens[i - 1]) && Tree.isAWord(tokens[i + 1])) {
                throw Tree.getException(tokens, i);
            }
            if (tokens[i - 1].equals(")")) {
                throw Tree.getException(tokens, i);
            }
            if (!tokens[i - 1].equals("(") || !tokens[i + 1].equals(")")) continue;
            throw Tree.getException(tokens, i);
        }
        if (opened != 0) {
            throw Tree.getException(tokens, tokens.length - 1);
        }
    }

    private static boolean isAWord(String token) {
        return !token.equals("(") && !token.equals(")");
    }

    private static Exception getException(String[] tokens, int ind) {
        String str = new String("Parentheses format not valid: \"... ");
        for (int i = ind < 5 ? 0 : ind - 5; i < (ind > tokens.length - 6 ? tokens.length - 1 : ind + 5); ++i) {
            if (i == ind) {
                str = str + "->";
            }
            str = str + tokens[i];
            if (i == ind) {
                str = str + "<-";
            }
            str = str + " ";
        }
        return new Exception(str + " ...\"");
    }

    private static boolean isHead(String tag) {
        return tag.endsWith(HEAD_MARK);
    }

    private static String removeHeadMark(String tag) {
        if (!Tree.isHead(tag)) {
            return tag;
        }
        return tag.substring(0, tag.length() - HEAD_MARK.length());
    }

    @Override
    public String getGroupID() {
        return this.getType();
    }

    @Override
    public Integer getSent() {
        return this.root.getSent();
    }

    @Override
    public Integer getPara() {
        return this.root.getPara();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tree)) {
            return false;
        }
        Tree ann = (Tree)o;
        return KAFDocument.Utils.areEquals(this.type, ann.type) && KAFDocument.Utils.areEquals(this.root, ann.root);
    }
}

