/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.Annotation;
import ixa.kaflib.AnnotationContainer;
import ixa.kaflib.IdentifiableAnnotation;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.SentenceLevelAnnotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WF
extends IdentifiableAnnotation
implements SentenceLevelAnnotation {
    private AnnotationContainer annotationContainer;
    private int sent;
    private int offset;
    private int length;
    private int para;
    private int page;
    private String xpath;
    private String form;
    private static final String ID_PREFIX = "w";

    WF(AnnotationContainer annotationContainer, String id, int offset, int length, String form, int sent) {
        super(id);
        this.annotationContainer = annotationContainer;
        this.offset = offset;
        this.length = length;
        this.form = form;
        this.setSent(sent);
        this.para = -1;
        this.page = -1;
    }

    WF(WF wf, AnnotationContainer annotationContainer) {
        super(wf.getId());
        this.annotationContainer = annotationContainer;
        this.sent = wf.sent;
        this.para = wf.para;
        this.page = wf.page;
        this.offset = wf.offset;
        this.length = wf.length;
        this.xpath = wf.xpath;
        this.form = wf.form;
    }

    String getIdPrefix() {
        return ID_PREFIX;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public Integer getSent() {
        return this.sent;
    }

    public void setSent(int sent) {
        Integer oldSent = this.sent;
        Integer oldPara = this.para;
        this.sent = sent;
        if (oldSent > 0) {
            this.annotationContainer.reindexAnnotationParaSent(this, KAFDocument.Layer.TEXT, oldSent, oldPara);
        }
    }

    public boolean hasPara() {
        return this.para != -1;
    }

    @Override
    public Integer getPara() {
        return this.para;
    }

    public void setPara(int para) {
        Integer oldSent = this.sent;
        Integer oldPara = this.para;
        this.para = para;
        this.annotationContainer.reindexAnnotationParaSent(this, KAFDocument.Layer.TEXT, oldSent, oldPara);
    }

    public boolean hasPage() {
        return this.page != -1;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public boolean hasOffset() {
        return this.offset != -1;
    }

    public boolean hasXpath() {
        return this.xpath != null;
    }

    public String getXpath() {
        return this.xpath;
    }

    public void setXpath(String xpath) {
        this.xpath = xpath;
    }

    public String getForm() {
        return this.form;
    }

    public void setForm(String form) {
        this.form = form;
    }

    @Override
    Map<KAFDocument.Layer, List<Annotation>> getReferencedAnnotations() {
        return new HashMap<KAFDocument.Layer, List<Annotation>>();
    }

    public String toString() {
        return this.getForm();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WF)) {
            return false;
        }
        WF ann = (WF)o;
        return KAFDocument.Utils.areEquals(this.sent, ann.sent) && KAFDocument.Utils.areEquals(this.para, ann.para) && KAFDocument.Utils.areEquals(this.page, ann.page) && KAFDocument.Utils.areEquals(this.offset, ann.offset) && KAFDocument.Utils.areEquals(this.length, ann.length) && KAFDocument.Utils.areEquals(this.xpath, ann.xpath) && KAFDocument.Utils.areEquals(this.form, ann.form);
    }
}

