/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.ParagraphStream;
import opennlp.tools.util.PlainTextByLineStream;

public class ConllXPOSSampleStream
extends FilterObjectStream<String, POSSample> {
    public ConllXPOSSampleStream(ObjectStream<String> lineStream) {
        super(new ParagraphStream(lineStream));
    }

    ConllXPOSSampleStream(InputStreamFactory in, Charset charset) throws IOException {
        super(new ParagraphStream(new PlainTextByLineStream(in, charset)));
    }

    @Override
    public POSSample read() throws IOException {
        String paragraph = (String)this.samples.read();
        POSSample sample = null;
        if (paragraph != null) {
            String line;
            BufferedReader reader = new BufferedReader(new StringReader(paragraph));
            ArrayList<String> tokens = new ArrayList<String>(100);
            ArrayList<String> tags = new ArrayList<String>(100);
            while ((line = reader.readLine()) != null) {
                int minNumberOfFields = 5;
                String[] parts = line.split("\t");
                if (parts.length >= 5) {
                    tokens.add(parts[1]);
                    tags.add(parts[4]);
                    continue;
                }
                throw new InvalidFormatException("Every non-empty line must have at least 5 fields: '" + line + "'!");
            }
            if (tokens.size() == 0) {
                sample = this.read();
            }
            sample = new POSSample(tokens.toArray(new String[tokens.size()]), tags.toArray(new String[tags.size()]));
        }
        return sample;
    }
}

