/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent;

import opennlp.tools.ml.maxent.BasicContextGenerator;
import opennlp.tools.ml.maxent.ContextGenerator;
import opennlp.tools.ml.maxent.DataStream;
import opennlp.tools.ml.model.AbstractEventStream;
import opennlp.tools.ml.model.Event;

public class BasicEventStream
extends AbstractEventStream {
    ContextGenerator cg;
    DataStream ds;
    Event next;
    private String separator = " ";

    public BasicEventStream(DataStream ds, String sep) {
        this.separator = sep;
        this.cg = new BasicContextGenerator(this.separator);
        this.ds = ds;
        if (this.ds.hasNext()) {
            this.next = this.createEvent((String)this.ds.nextToken());
        }
    }

    public BasicEventStream(DataStream ds) {
        this(ds, " ");
    }

    @Override
    public Event next() {
        while (this.next == null && this.ds.hasNext()) {
            this.next = this.createEvent((String)this.ds.nextToken());
        }
        Event current = this.next;
        this.next = this.ds.hasNext() ? this.createEvent((String)this.ds.nextToken()) : null;
        return current;
    }

    @Override
    public boolean hasNext() {
        while (this.next == null && this.ds.hasNext()) {
            this.next = this.createEvent((String)this.ds.nextToken());
        }
        return this.next != null;
    }

    private Event createEvent(String obs) {
        int lastSpace = obs.lastIndexOf(this.separator);
        if (lastSpace == -1) {
            return null;
        }
        return new Event(obs.substring(lastSpace + 1), this.cg.getContext(obs.substring(0, lastSpace)));
    }
}

