/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.Annotation;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.MultiLayerAnnotation;
import ixa.kaflib.ParagraphLevelAnnotation;
import ixa.kaflib.SentenceLevelAnnotation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.Element;

class AnnotationContainer
implements Serializable {
    private String rawText = new String();
    private Map<KAFDocument.Layer, Map<String, List<Annotation>>> layers = new HashMap<KAFDocument.Layer, Map<String, List<Annotation>>>();
    private Map<KAFDocument.AnnotationType, Map<String, List<Annotation>>> annotations = new HashMap<KAFDocument.AnnotationType, Map<String, List<Annotation>>>();
    private Set<Element> unknownLayers = new HashSet<Element>();
    private Map<Annotation, Map<KAFDocument.AnnotationType, List<Annotation>>> invRefIndex = new HashMap<Annotation, Map<KAFDocument.AnnotationType, List<Annotation>>>();
    private Map<KAFDocument.AnnotationType, Map<String, Map<Integer, List<Annotation>>>> sentIndex = new HashMap<KAFDocument.AnnotationType, Map<String, Map<Integer, List<Annotation>>>>();
    private Map<KAFDocument.AnnotationType, Map<String, Map<Integer, List<Annotation>>>> paraIndex = new HashMap<KAFDocument.AnnotationType, Map<String, Map<Integer, List<Annotation>>>>();
    private Map<Integer, Set<Integer>> paraSentIndex = new HashMap<Integer, Set<Integer>>();
    private Set<Integer> indexedSents = new HashSet<Integer>();
    static final String DEFAULT_GROUP = "kaflib_default_group";

    AnnotationContainer() {
    }

    String getRawText() {
        return this.rawText;
    }

    List<Annotation> getLayer(KAFDocument.Layer layer) {
        return Helper.get(layer, this.layers);
    }

    List<Annotation> getAnnotations(KAFDocument.AnnotationType type) {
        return Helper.get(type, this.annotations);
    }

    List<Annotation> getLayer(KAFDocument.Layer layer, String group) {
        return Helper.get(layer, group, this.layers);
    }

    List<Annotation> getAnnotations(KAFDocument.AnnotationType type, String group) {
        return Helper.get(type, group, this.annotations);
    }

    List<Annotation> getInverse(Annotation ann) {
        return Helper.getInvReferences(ann, this.invRefIndex);
    }

    List<Annotation> getInverse(Annotation ann, KAFDocument.AnnotationType type) {
        return Helper.getInvReferences(ann, type, this.invRefIndex);
    }

    List<Annotation> getInverse(List<Annotation> anns, KAFDocument.AnnotationType type) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (Annotation ann : anns) {
            result.addAll(Helper.getInvReferences(ann, type, this.invRefIndex));
        }
        return result;
    }

    List<String> getGroupIDs(KAFDocument.AnnotationType type) {
        return Helper.getGroupIDs(type, this.annotations);
    }

    Set<Element> getUnknownLayers() {
        return this.unknownLayers;
    }

    void setRawText(String str) {
        this.rawText = str;
    }

    void add(Annotation ann, KAFDocument.Layer layer, KAFDocument.AnnotationType type) {
        this.add(ann, layer, type, null);
    }

    void add(Annotation ann, KAFDocument.Layer layer, KAFDocument.AnnotationType type, Integer position) {
        Helper.addAnnotation(ann, layer, AnnotationContainer.getGroupID(ann), position, this.layers);
        Helper.addAnnotation(ann, type, AnnotationContainer.getGroupID(ann), position, this.annotations);
        this.indexAnnotation(ann, type);
    }

    void add(Element layer) {
        this.unknownLayers.add(layer);
    }

    private void indexAnnotation(Annotation ann, KAFDocument.AnnotationType type) {
        Map<KAFDocument.AnnotationType, List<Annotation>> invReferences = ann.getReferencedAnnotations();
        for (Map.Entry<KAFDocument.AnnotationType, List<Annotation>> pair : invReferences.entrySet()) {
            for (Annotation ref : pair.getValue()) {
                Helper.addInvReference(ann, ref, type, this.invRefIndex);
            }
        }
        this.indexAnnotationParaSent(ann, type);
    }

    private void indexAnnotationParaSent(Annotation ann, KAFDocument.AnnotationType type) {
        Integer para;
        String groupID = AnnotationContainer.getGroupID(ann);
        if (ann instanceof SentenceLevelAnnotation) {
            Integer sent = ((SentenceLevelAnnotation)((Object)ann)).getSent();
            Integer para2 = ((ParagraphLevelAnnotation)((Object)ann)).getPara();
            Helper.addToIndex(ann, type, groupID, sent, this.sentIndex);
            if (para2 > 0) {
                Helper.addToIndex(ann, type, groupID, para2, this.paraIndex);
                if (!this.indexedSents.contains(sent)) {
                    this.addSentToPara(sent, para2);
                    this.indexedSents.add(sent);
                }
            }
        } else if (ann instanceof ParagraphLevelAnnotation && (para = ((ParagraphLevelAnnotation)((Object)ann)).getPara()) > 0) {
            Helper.addToIndex(ann, type, groupID, para, this.paraIndex);
        }
    }

    void reindexAnnotationParaSent(Annotation ann, KAFDocument.AnnotationType type, Integer oldSent, Integer oldPara) {
        String groupID = AnnotationContainer.getGroupID(ann);
        Helper.removeFromIndex(ann, type, groupID, oldSent, this.sentIndex);
        Helper.removeFromIndex(ann, type, groupID, oldPara, this.paraIndex);
        this.indexAnnotationParaSent(ann, type);
    }

    void remove(Annotation ann, KAFDocument.Layer layer, KAFDocument.AnnotationType type) {
        this.remove(ann, layer, type, DEFAULT_GROUP);
    }

    void remove(Annotation ann, KAFDocument.Layer layer, KAFDocument.AnnotationType type, String group) {
        Helper.remove(ann, layer, this.layers);
        Helper.remove(ann, type, this.annotations);
        if (ann instanceof SentenceLevelAnnotation) {
            String groupID = AnnotationContainer.getGroupID(ann);
            Integer sent = ((SentenceLevelAnnotation)((Object)ann)).getSent();
            List<Annotation> sentAnnotations = this.getSentAnnotations(sent, type, groupID);
            sentAnnotations.remove(ann);
            if (ann instanceof ParagraphLevelAnnotation) {
                Integer para = ((ParagraphLevelAnnotation)((Object)ann)).getPara();
                List<Annotation> paraAnnotations = this.getParaAnnotations(para, type, groupID);
                paraAnnotations.remove(ann);
            }
        }
    }

    void removeLayer(KAFDocument.Layer layerName) {
        this.layers.remove((Object)layerName);
    }

    void removeLayer(KAFDocument.Layer layerName, String groupID) {
        Map<String, List<Annotation>> layer = this.layers.get((Object)layerName);
        if (layer != null) {
            layer.remove(groupID);
        }
    }

    List<Integer> getParaSents(Integer para) {
        ArrayList<Integer> sentList = new ArrayList<Integer>((Collection)this.paraSentIndex.get(para));
        Collections.sort(sentList);
        return sentList;
    }

    List<Annotation> getSentAnnotations(Integer sent, KAFDocument.AnnotationType type) {
        return this.getSentAnnotations(sent, type, DEFAULT_GROUP);
    }

    List<Annotation> getSentAnnotations(Integer sent, KAFDocument.AnnotationType type, String groupID) {
        return Helper.getIndexedAnnotations(type, groupID, sent, this.sentIndex);
    }

    List<Annotation> getParaAnnotations(Integer para, KAFDocument.AnnotationType type) {
        return this.getParaAnnotations(para, type, DEFAULT_GROUP);
    }

    List<Annotation> getParaAnnotations(Integer para, KAFDocument.AnnotationType type, String groupID) {
        return Helper.getIndexedAnnotations(type, groupID, para, this.paraIndex);
    }

    Integer getNumSentences() {
        return this.sentIndex.size();
    }

    Integer getNumParagraphs() {
        if (this.paraIndex.get((Object)KAFDocument.AnnotationType.WF) == null) {
            return 0;
        }
        return this.paraIndex.get((Object)KAFDocument.AnnotationType.WF).get(DEFAULT_GROUP).size();
    }

    List<List<Annotation>> getSentences(KAFDocument.AnnotationType type) {
        return this.getSentences(type, DEFAULT_GROUP);
    }

    List<List<Annotation>> getSentences(KAFDocument.AnnotationType type, String groupID) {
        ArrayList<List<Annotation>> sentences = new ArrayList<List<Annotation>>();
        for (int sent : Helper.getIndexKeys(type, groupID, this.sentIndex)) {
            sentences.add(this.getSentAnnotations(sent, type));
        }
        return sentences;
    }

    List<List<Annotation>> getParagraphs(KAFDocument.AnnotationType type) {
        return this.getParagraphs(type, DEFAULT_GROUP);
    }

    List<List<Annotation>> getParagraphs(KAFDocument.AnnotationType type, String groupID) {
        ArrayList<List<Annotation>> paragraphs = new ArrayList<List<Annotation>>();
        for (int para : Helper.getIndexKeys(type, groupID, this.paraIndex)) {
            paragraphs.add(this.getParaAnnotations(para, type));
        }
        return paragraphs;
    }

    private static String getGroupID(Annotation ann) {
        return ann instanceof MultiLayerAnnotation ? ((MultiLayerAnnotation)((Object)ann)).getGroupID() : DEFAULT_GROUP;
    }

    Integer getPosition(KAFDocument.Layer layer, Annotation ann) {
        return this.layers.get((Object)layer).get(DEFAULT_GROUP).indexOf(ann);
    }

    void addSentToPara(Integer sent, Integer para) {
        Set<Integer> paraSents = this.paraSentIndex.get(para);
        if (paraSents == null) {
            paraSents = new HashSet<Integer>();
            this.paraSentIndex.put(para, paraSents);
        }
        paraSents.add(sent);
    }

    private static class Helper {
        private Helper() {
        }

        static <T> void addToIndex(Annotation ann, T type, String groupID, Integer key, Map<T, Map<String, Map<Integer, List<Annotation>>>> index) {
            if (key != null) {
                List<Annotation> annotations;
                Map<Integer, List<Annotation>> groupIndex;
                Map<String, Map<Integer, List<Annotation>>> typeIndex = index.get(type);
                if (typeIndex == null) {
                    typeIndex = new HashMap<String, Map<Integer, List<Annotation>>>();
                    index.put(type, typeIndex);
                }
                if ((groupIndex = typeIndex.get(groupID)) == null) {
                    groupIndex = new HashMap<Integer, List<Annotation>>();
                    typeIndex.put(groupID, groupIndex);
                }
                if ((annotations = groupIndex.get(key)) == null) {
                    annotations = new ArrayList<Annotation>();
                    groupIndex.put(key, annotations);
                }
                annotations.add(ann);
            }
        }

        static <T> void removeFromIndex(Annotation ann, T type, String groupID, Integer key, Map<T, Map<String, Map<Integer, List<Annotation>>>> index) {
            List<Annotation> annotations;
            Map<Integer, List<Annotation>> groupIndex;
            Map<String, Map<Integer, List<Annotation>>> typeIndex;
            if (key != null && (typeIndex = index.get(type)) != null && (groupIndex = typeIndex.get(groupID)) != null && (annotations = groupIndex.get(key)) != null) {
                annotations.remove(ann);
            }
        }

        static <T> void addAnnotation(Annotation ann, T type, String groupID, Integer position, Map<T, Map<String, List<Annotation>>> container) {
            List<Annotation> annotations;
            Map<String, List<Annotation>> typeGroups = container.get(type);
            if (typeGroups == null) {
                typeGroups = new HashMap<String, List<Annotation>>();
                container.put(type, typeGroups);
            }
            if ((annotations = typeGroups.get(groupID)) == null) {
                annotations = new ArrayList<Annotation>();
                typeGroups.put(groupID, annotations);
            }
            if (position == null || position > annotations.size()) {
                annotations.add(ann);
            } else {
                annotations.add(position, ann);
            }
        }

        static <T> List<Annotation> getIndexedAnnotations(T type, String groupID, Integer key, Map<T, Map<String, Map<Integer, List<Annotation>>>> index) {
            Map<String, Map<Integer, List<Annotation>>> typeIndex = index.get(type);
            if (typeIndex == null) {
                return new ArrayList<Annotation>();
            }
            Map<Integer, List<Annotation>> groupIndex = typeIndex.get(groupID);
            if (groupIndex == null) {
                return new ArrayList<Annotation>();
            }
            ArrayList annotations = groupIndex.get(key);
            return annotations == null ? new ArrayList() : annotations;
        }

        static <T> List<Integer> getIndexKeys(T type, String groupID, Map<T, Map<String, Map<Integer, List<Annotation>>>> index) {
            Map<Integer, List<Annotation>> groupIndex;
            Map<String, Map<Integer, List<Annotation>>> typeIndex = index.get(type);
            if (typeIndex != null && (groupIndex = typeIndex.get(groupID)) != null) {
                ArrayList<Integer> keys = new ArrayList<Integer>(groupIndex.keySet());
                Collections.sort(keys);
                return keys;
            }
            return new ArrayList<Integer>();
        }

        static <T> void addInvReference(Annotation src, Annotation ref, T type, Map<Annotation, Map<T, List<Annotation>>> index) {
            List<Annotation> refAnnotations;
            Map<T, List<Annotation>> annIndex = index.get(ref);
            if (annIndex == null) {
                annIndex = new HashMap<T, List<Annotation>>();
                index.put(ref, annIndex);
            }
            if ((refAnnotations = annIndex.get(type)) == null) {
                refAnnotations = new ArrayList<Annotation>();
                annIndex.put(type, refAnnotations);
            }
            refAnnotations.add(src);
        }

        static <T> List<Annotation> getInvReferences(Annotation ann, T type, Map<Annotation, Map<T, List<Annotation>>> index) {
            Map<T, List<Annotation>> annIndex = index.get(ann);
            if (annIndex == null) {
                return new ArrayList<Annotation>();
            }
            ArrayList annotations = annIndex.get(type);
            return annotations == null ? new ArrayList() : annotations;
        }

        static <T> List<Annotation> getInvReferences(Annotation ann, Map<Annotation, Map<T, List<Annotation>>> index) {
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            Map<T, List<Annotation>> annIndex = index.get(ann);
            if (annIndex == null) {
                return new ArrayList<Annotation>();
            }
            for (T type : annIndex.keySet()) {
                annotations.addAll((Collection<Annotation>)annIndex.get(type));
            }
            return annotations;
        }

        static <T> List<Annotation> get(T type, Map<T, Map<String, List<Annotation>>> container) {
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            for (String group : Helper.getGroupIDs(type, container)) {
                annotations.addAll(Helper.get(type, group, container));
            }
            return annotations;
        }

        static <T> List<Annotation> get(T type, String group, Map<T, Map<String, List<Annotation>>> container) {
            Map<String, List<Annotation>> groups = container.get(type);
            if (groups == null) {
                return new ArrayList<Annotation>();
            }
            ArrayList annotations = groups.get(group);
            return annotations == null ? new ArrayList() : annotations;
        }

        static <T> List<String> getGroupIDs(T type, Map<T, Map<String, List<Annotation>>> container) {
            Map<String, List<Annotation>> groups = container.get(type);
            return groups == null ? new ArrayList<String>() : new ArrayList<String>(groups.keySet());
        }

        static <T> void remove(Annotation ann, T type, Map<T, Map<String, List<Annotation>>> container) {
            Helper.remove(ann, type, AnnotationContainer.DEFAULT_GROUP, container);
        }

        static <T> void remove(Annotation ann, T type, String group, Map<T, Map<String, List<Annotation>>> container) {
            Map<String, List<Annotation>> groups = container.get(type);
            if (groups == null) {
                return;
            }
            List<Annotation> annotations = groups.get(group);
            if (annotations != null) {
                groups.remove(ann);
            }
        }
    }
}

