/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.lemma;

import eus.ixa.ixa.pipe.lemma.LemmaSample;
import eus.ixa.ixa.pipe.lemma.LemmaSampleEventStream;
import eus.ixa.ixa.pipe.lemma.LemmaSampleSequenceStream;
import eus.ixa.ixa.pipe.lemma.Lemmatizer;
import eus.ixa.ixa.pipe.lemma.LemmatizerContextGenerator;
import eus.ixa.ixa.pipe.lemma.LemmatizerFactory;
import eus.ixa.ixa.pipe.lemma.LemmatizerModel;
import eus.ixa.ixa.pipe.pos.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import opennlp.tools.ml.BeamSearch;
import opennlp.tools.ml.EventModelSequenceTrainer;
import opennlp.tools.ml.EventTrainer;
import opennlp.tools.ml.SequenceTrainer;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.SequenceClassificationModel;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Sequence;
import opennlp.tools.util.SequenceValidator;
import opennlp.tools.util.TrainingParameters;

public class LemmatizerME
implements Lemmatizer {
    public static final int DEFAULT_BEAM_SIZE = 3;
    protected int beamSize;
    private Sequence bestSequence;
    private SequenceClassificationModel<String> model;
    private LemmatizerContextGenerator contextGenerator;
    private SequenceValidator<String> sequenceValidator;

    public LemmatizerME(LemmatizerModel model) {
        LemmatizerFactory factory = model.getFactory();
        int defaultBeamSize = 3;
        String beamSizeString = model.getManifestProperty("BeamSize");
        if (beamSizeString != null) {
            defaultBeamSize = Integer.parseInt(beamSizeString);
        }
        this.contextGenerator = factory.getContextGenerator();
        this.beamSize = defaultBeamSize;
        this.sequenceValidator = factory.getSequenceValidator();
        this.model = model.getLemmatizerSequenceModel() != null ? model.getLemmatizerSequenceModel() : new BeamSearch<String>(this.beamSize, (MaxentModel)((Object)model.getLemmatizerSequenceModel()), 0);
    }

    @Override
    public String[] lemmatize(String[] toks, String[] tags) {
        this.bestSequence = this.model.bestSequence((String[])toks, new Object[]{tags}, this.contextGenerator, this.sequenceValidator);
        List<String> c = this.bestSequence.getOutcomes();
        return c.toArray(new String[c.size()]);
    }

    public String[] decodeLemmas(String[] toks, String[] preds) {
        ArrayList<String> lemmas = new ArrayList<String>();
        for (int i = 0; i < toks.length; ++i) {
            String lemma = StringUtils.decodeShortestEditScript(toks[i].toLowerCase(), preds[i]);
            if (lemma.length() == 0) {
                lemma = "_";
            }
            lemmas.add(lemma);
        }
        return lemmas.toArray(new String[lemmas.size()]);
    }

    public Sequence[] topKSequences(String[] sentence, String[] tags) {
        return this.model.bestSequences(3, (String[])sentence, new Object[]{tags}, this.contextGenerator, this.sequenceValidator);
    }

    public Sequence[] topKSequences(String[] sentence, String[] tags, double minSequenceScore) {
        return this.model.bestSequences(3, (String[])sentence, new Object[]{tags}, minSequenceScore, this.contextGenerator, this.sequenceValidator);
    }

    public void probs(double[] probs) {
        this.bestSequence.getProbs(probs);
    }

    public double[] probs() {
        return this.bestSequence.getProbs();
    }

    public static LemmatizerModel train(String languageCode, ObjectStream<LemmaSample> samples, TrainingParameters trainParams, LemmatizerFactory posFactory) throws IOException {
        String beamSizeString = trainParams.getSettings().get("BeamSize");
        int beamSize = 3;
        if (beamSizeString != null) {
            beamSize = Integer.parseInt(beamSizeString);
        }
        LemmatizerContextGenerator contextGenerator = posFactory.getContextGenerator();
        HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
        TrainerFactory.TrainerType trainerType = TrainerFactory.getTrainerType(trainParams.getSettings());
        MaxentModel lemmatizerModel = null;
        SequenceClassificationModel<String> seqLemmatizerModel = null;
        if (TrainerFactory.TrainerType.EVENT_MODEL_TRAINER.equals((Object)trainerType)) {
            LemmaSampleEventStream es = new LemmaSampleEventStream(samples, contextGenerator);
            EventTrainer trainer = TrainerFactory.getEventTrainer(trainParams.getSettings(), manifestInfoEntries);
            lemmatizerModel = trainer.train(es);
        } else if (TrainerFactory.TrainerType.EVENT_MODEL_SEQUENCE_TRAINER.equals((Object)trainerType)) {
            LemmaSampleSequenceStream ss = new LemmaSampleSequenceStream(samples, contextGenerator);
            EventModelSequenceTrainer trainer = TrainerFactory.getEventModelSequenceTrainer(trainParams.getSettings(), manifestInfoEntries);
            lemmatizerModel = trainer.train(ss);
        } else if (TrainerFactory.TrainerType.SEQUENCE_TRAINER.equals((Object)trainerType)) {
            SequenceTrainer trainer = TrainerFactory.getSequenceModelTrainer(trainParams.getSettings(), manifestInfoEntries);
            LemmaSampleSequenceStream ss = new LemmaSampleSequenceStream(samples, contextGenerator);
            seqLemmatizerModel = trainer.train(ss);
        } else {
            throw new IllegalArgumentException("Trainer type is not supported: " + (Object)((Object)trainerType));
        }
        if (lemmatizerModel != null) {
            return new LemmatizerModel(languageCode, lemmatizerModel, beamSize, manifestInfoEntries, posFactory);
        }
        return new LemmatizerModel(languageCode, seqLemmatizerModel, manifestInfoEntries, posFactory);
    }

    public Sequence[] topKLemmaClasses(String[] sentence, String[] tags) {
        return this.model.bestSequences(3, (String[])sentence, new Object[]{tags}, this.contextGenerator, this.sequenceValidator);
    }

    public Sequence[] topKLemmaClasses(String[] sentence, String[] tags, double minSequenceScore) {
        return this.model.bestSequences(3, (String[])sentence, new Object[]{tags}, minSequenceScore, this.contextGenerator, this.sequenceValidator);
    }
}

