/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.lemma.dict;

import eus.ixa.ixa.pipe.lemma.Lemmatizer;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.IStemmer;
import morfologik.stemming.WordData;

public class MorfologikLemmatizer
implements Lemmatizer {
    private final IStemmer dictLookup;

    public MorfologikLemmatizer(URL dictURL) throws IOException {
        this.dictLookup = new DictionaryLookup(Dictionary.read(dictURL));
    }

    private HashMap<List<String>, String> getLemmaTagsDict(String word) {
        List<WordData> wdList = this.dictLookup.lookup(word);
        HashMap<List<String>, String> dictMap = new HashMap<List<String>, String>();
        for (WordData wd : wdList) {
            ArrayList<String> wordLemmaTags = new ArrayList<String>();
            wordLemmaTags.add(word);
            wordLemmaTags.add(wd.getTag().toString());
            dictMap.put(wordLemmaTags, wd.getStem().toString());
        }
        return dictMap;
    }

    private List<String> getDictKeys(String word, String postag) {
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(Arrays.asList(word.toLowerCase(), postag));
        return keys;
    }

    private HashMap<List<String>, String> getDictMap(String word, String postag) {
        HashMap<List<String>, String> dictMap = new HashMap();
        dictMap = this.getLemmaTagsDict(word.toLowerCase());
        return dictMap;
    }

    @Override
    public String[] lemmatize(String[] tokens, String[] postags) {
        ArrayList<String> lemmas = new ArrayList<String>();
        for (int i = 0; i < tokens.length; ++i) {
            lemmas.add(this.apply(tokens[i], postags[i]));
        }
        return lemmas.toArray(new String[lemmas.size()]);
    }

    public String apply(String word, String postag) {
        String lemma = null;
        List<String> keys = this.getDictKeys(word, postag);
        HashMap<List<String>, String> dictMap = this.getDictMap(word, postag);
        String keyValue = dictMap.get(keys);
        lemma = keyValue != null ? keyValue : "O";
        return lemma;
    }
}

