/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.Annotation;
import ixa.kaflib.IdentifiableAnnotation;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.Span;
import ixa.kaflib.Term;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Statement
extends IdentifiableAnnotation {
    private StatementTarget target;
    private StatementSource source;
    private StatementCue cue;

    public Statement(String id, StatementTarget target) {
        super(id);
        this.target = target;
    }

    public StatementTarget getTarget() {
        return this.target;
    }

    public void setTarget(StatementTarget target) {
        this.target = target;
    }

    public Boolean hasSource() {
        return this.source != null;
    }

    public StatementSource getSource() {
        return this.source;
    }

    public void setSource(StatementSource source) {
        this.source = source;
    }

    public Boolean hasCue() {
        return this.cue != null;
    }

    public StatementCue getCue() {
        return this.cue;
    }

    public void setCue(StatementCue cue) {
        this.cue = cue;
    }

    @Override
    public Map<KAFDocument.AnnotationType, List<Annotation>> getReferencedAnnotations() {
        HashMap<KAFDocument.AnnotationType, List<Annotation>> refs = new HashMap<KAFDocument.AnnotationType, List<Annotation>>();
        ArrayList<Term> terms = new ArrayList<Term>();
        for (Term t : this.target.getSpan().getTargets()) {
            terms.add(t);
        }
        if (this.hasSource().booleanValue()) {
            for (Term t : this.source.getSpan().getTargets()) {
                terms.add(t);
            }
        }
        if (this.hasCue().booleanValue()) {
            for (Term t : this.cue.getSpan().getTargets()) {
                terms.add(t);
            }
        }
        refs.put(KAFDocument.AnnotationType.TERM, terms);
        return refs;
    }

    public static class StatementCue
    extends Annotation {
        private Span<Term> span;

        public StatementCue(Span<Term> span) {
            this.span = span;
        }

        public Span<Term> getSpan() {
            return this.span;
        }

        public void setSpan(Span<Term> span) {
            this.span = span;
        }

        @Override
        public Map<KAFDocument.AnnotationType, List<Annotation>> getReferencedAnnotations() {
            HashMap<KAFDocument.AnnotationType, List<Annotation>> refs = new HashMap<KAFDocument.AnnotationType, List<Annotation>>();
            ArrayList<Term> terms = new ArrayList<Term>();
            for (Term t : this.getSpan().getTargets()) {
                terms.add(t);
            }
            refs.put(KAFDocument.AnnotationType.TERM, terms);
            return refs;
        }
    }

    public static class StatementSource
    extends Annotation {
        private Span<Term> span;

        public StatementSource(Span<Term> span) {
            this.span = span;
        }

        public Span<Term> getSpan() {
            return this.span;
        }

        public void setSpan(Span<Term> span) {
            this.span = span;
        }

        @Override
        public Map<KAFDocument.AnnotationType, List<Annotation>> getReferencedAnnotations() {
            HashMap<KAFDocument.AnnotationType, List<Annotation>> refs = new HashMap<KAFDocument.AnnotationType, List<Annotation>>();
            ArrayList<Term> terms = new ArrayList<Term>();
            for (Term t : this.getSpan().getTargets()) {
                terms.add(t);
            }
            refs.put(KAFDocument.AnnotationType.TERM, terms);
            return refs;
        }
    }

    public static class StatementTarget
    extends Annotation {
        private Span<Term> span;

        public StatementTarget(Span<Term> span) {
            this.span = span;
        }

        public Span<Term> getSpan() {
            return this.span;
        }

        public void setSpan(Span<Term> span) {
            this.span = span;
        }

        @Override
        public Map<KAFDocument.AnnotationType, List<Annotation>> getReferencedAnnotations() {
            HashMap<KAFDocument.AnnotationType, List<Annotation>> refs = new HashMap<KAFDocument.AnnotationType, List<Annotation>>();
            ArrayList<Term> terms = new ArrayList<Term>();
            for (Term t : this.getSpan().getTargets()) {
                terms.add(t);
            }
            refs.put(KAFDocument.AnnotationType.TERM, terms);
            return refs;
        }
    }
}

