/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.lemma.eval;

import eus.ixa.ixa.pipe.lemma.LemmaSample;
import eus.ixa.ixa.pipe.lemma.LemmaSampleStream;
import eus.ixa.ixa.pipe.lemma.LemmatizerEvaluationMonitor;
import eus.ixa.ixa.pipe.lemma.LemmatizerEvaluator;
import eus.ixa.ixa.pipe.lemma.LemmatizerME;
import eus.ixa.ixa.pipe.lemma.LemmatizerModel;
import eus.ixa.ixa.pipe.pos.eval.Evaluate;
import eus.ixa.ixa.pipe.pos.train.InputOutputUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import opennlp.tools.util.ObjectStream;

public class LemmaEvaluate
implements Evaluate {
    private final ObjectStream<LemmaSample> testSamples;
    private static LemmatizerModel lemmatizerModel;
    private final LemmatizerME lemmatizer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LemmaEvaluate(String testData, String model) throws IOException {
        ObjectStream<String> testStream = InputOutputUtils.readFileIntoMarkableStreamFactory(testData);
        this.testSamples = new LemmaSampleStream(testStream);
        FileInputStream trainedModelInputStream = null;
        try {
            if (lemmatizerModel == null) {
                trainedModelInputStream = new FileInputStream(model);
                lemmatizerModel = new LemmatizerModel(trainedModelInputStream);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (trainedModelInputStream != null) {
                try {
                    ((InputStream)trainedModelInputStream).close();
                }
                catch (IOException e) {
                    System.err.println("Could not load model!");
                }
            }
        }
        this.lemmatizer = new LemmatizerME(lemmatizerModel);
    }

    @Override
    public final void evaluate() {
        LemmatizerEvaluator evaluator = new LemmatizerEvaluator(this.lemmatizer, new LemmatizerEvaluationMonitor[0]);
        try {
            evaluator.evaluate(this.testSamples);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(evaluator.getWordAccuracy());
    }

    @Override
    public void detailEvaluate() {
        LemmatizerEvaluator evaluator = new LemmatizerEvaluator(this.lemmatizer, new LemmatizerEvaluationMonitor[0]);
        try {
            evaluator.evaluate(this.testSamples);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(evaluator.getWordAccuracy());
    }

    @Override
    public void evalError() {
        LemmatizerEvaluator evaluator = new LemmatizerEvaluator(this.lemmatizer, new LemmatizerEvaluationMonitor[0]);
        try {
            evaluator.evaluate(this.testSamples);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(evaluator.getWordAccuracy());
    }
}

