/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.pos;

import com.google.common.io.Files;
import eus.ixa.ixa.pipe.lemma.LemmatizerModel;
import eus.ixa.ixa.pipe.lemma.eval.LemmaEvaluate;
import eus.ixa.ixa.pipe.lemma.train.LemmatizerFixedTrainer;
import eus.ixa.ixa.pipe.pos.Annotate;
import eus.ixa.ixa.pipe.pos.StatisticalTaggerServer;
import eus.ixa.ixa.pipe.pos.eval.Evaluate;
import eus.ixa.ixa.pipe.pos.eval.POSCrossValidator;
import eus.ixa.ixa.pipe.pos.eval.POSEvaluate;
import eus.ixa.ixa.pipe.pos.train.FixedTrainer;
import eus.ixa.ixa.pipe.pos.train.Flags;
import eus.ixa.ixa.pipe.pos.train.InputOutputUtils;
import ixa.kaflib.KAFDocument;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.postag.POSModel;
import opennlp.tools.util.TrainingParameters;
import org.jdom2.JDOMException;

public class CLI {
    private final String version = CLI.class.getPackage().getImplementationVersion();
    private final String commit = CLI.class.getPackage().getSpecificationVersion();
    private Namespace parsedArguments = null;
    private final ArgumentParser argParser = ArgumentParsers.newArgumentParser("ixa-pipe-pos-" + this.version + ".jar").description("ixa-pipe-pos-" + this.version + " is a multilingual POS tagger developed by IXA NLP Group.\n");
    private final Subparsers subParsers = this.argParser.addSubparsers().help("sub-command help");
    private final Subparser annotateParser = this.subParsers.addParser("tag").help("Tagging CLI");
    private final Subparser trainParser;
    private final Subparser evalParser;
    private final Subparser crossValidateParser;
    private Subparser serverParser;
    private Subparser clientParser;
    public static final String DEFAULT_BEAM_SIZE = "3";

    public CLI() {
        this.loadAnnotateParameters();
        this.trainParser = this.subParsers.addParser("train").help("Training CLI");
        this.loadTrainingParameters();
        this.evalParser = this.subParsers.addParser("eval").help("Evaluation CLI");
        this.loadEvalParameters();
        this.crossValidateParser = this.subParsers.addParser("cross").help("Cross validation CLI");
        this.loadCrossValidateParameters();
        this.serverParser = this.subParsers.addParser("server").help("Start TCP socket server");
        this.loadServerParameters();
        this.clientParser = this.subParsers.addParser("client").help("Send queries to the TCP socket server");
        this.loadClientParameters();
    }

    public static void main(String[] args) throws JDOMException, IOException {
        CLI cmdLine = new CLI();
        cmdLine.parseCLI(args);
    }

    public final void parseCLI(String[] args) throws IOException, JDOMException {
        try {
            this.parsedArguments = this.argParser.parseArgs(args);
            System.err.println("CLI options: " + this.parsedArguments);
            if (args[0].equals("tag")) {
                this.annotate(System.in, System.out);
            } else if (args[0].equals("eval")) {
                this.eval();
            } else if (args[0].equals("train")) {
                this.train();
            } else if (args[0].equals("cross")) {
                this.crossValidate();
            } else if (args[0].equals("server")) {
                this.server();
            } else if (args[0].equals("client")) {
                this.client(System.in, System.out);
            }
        }
        catch (ArgumentParserException e) {
            this.argParser.handleError(e);
            System.out.println("Run java -jar target/ixa-pipe-pos-" + this.version + ".jar (tag|train|eval|cross|server|client) -help for details");
            System.exit(1);
        }
    }

    public final void annotate(InputStream inputStream, OutputStream outputStream) throws IOException, JDOMException {
        String lang;
        String model = this.parsedArguments.getString("model");
        String lemmatizerModel = this.parsedArguments.getString("lemmatizerModel");
        boolean allMorphology = this.parsedArguments.getBoolean("allMorphology");
        String multiwords = Boolean.toString(this.parsedArguments.getBoolean("multiwords"));
        String dictag = Boolean.toString(this.parsedArguments.getBoolean("dictag"));
        String outputFormat = this.parsedArguments.getString("outputFormat");
        BufferedReader breader = null;
        BufferedWriter bwriter = null;
        breader = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
        bwriter = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
        KAFDocument kaf = KAFDocument.createFromStream(breader);
        if (this.parsedArguments.getString("language") != null) {
            lang = this.parsedArguments.getString("language");
            if (!kaf.getLang().equalsIgnoreCase(lang)) {
                System.err.println("Language parameter in NAF and CLI do not match!!");
            }
        } else {
            lang = kaf.getLang();
        }
        Properties properties = this.setAnnotateProperties(model, lemmatizerModel, lang, multiwords, dictag);
        Annotate annotator = new Annotate(properties);
        KAFDocument.LinguisticProcessor newLp = kaf.addLinguisticProcessor("terms", "ixa-pipe-pos-" + Files.getNameWithoutExtension(model), this.version + "-" + this.commit);
        newLp.setBeginTimestamp();
        if (allMorphology) {
            if (outputFormat.equalsIgnoreCase("conll")) {
                bwriter.write(annotator.getAllTagsLemmasToCoNLL(kaf));
            } else {
                annotator.getAllTagsLemmasToNAF(kaf);
                newLp.setEndTimestamp();
                bwriter.write(kaf.toString());
            }
        } else if (outputFormat.equalsIgnoreCase("conll")) {
            bwriter.write(annotator.annotatePOSToCoNLL(kaf));
        } else {
            annotator.annotatePOSToKAF(kaf);
            newLp.setEndTimestamp();
            bwriter.write(kaf.toString());
        }
        bwriter.close();
        breader.close();
    }

    private void loadAnnotateParameters() {
        this.annotateParser.addArgument("-m", "--model").required(true).help("It is required to provide a POS tagging model.");
        this.annotateParser.addArgument("-lm", "--lemmatizerModel").required(true).help("It is required to provide a lemmatizer model.");
        this.annotateParser.addArgument("-l", "--language").choices("de", "en", "es", "eu", "fr", "gl", "it", "nl").required(false).help("Choose a language.");
        this.annotateParser.addArgument("--beamSize").required(false).setDefault(DEFAULT_BEAM_SIZE).help("Choose beam size for decoding, it defaults to 3.");
        this.annotateParser.addArgument("-o", "--outputFormat").required(false).choices("naf", "conll").setDefault("naf").help("Choose output format; it defaults to NAF.\n");
        this.annotateParser.addArgument("-mw", "--multiwords").action(Arguments.storeTrue()).help("Use to detect and process multiwords.\n");
        this.annotateParser.addArgument("-d", "--dictag").action(Arguments.storeTrue()).help("Post process POS tagger output with a monosemic dictionary.\n");
        this.annotateParser.addArgument("-a", "--allMorphology").action(Arguments.storeTrue()).help("Print all the POS tags and lemmas before disambiguation.\n");
    }

    public final void train() throws IOException {
        String paramFile = this.parsedArguments.getString("params");
        TrainingParameters params = InputOutputUtils.loadTrainingParameters(paramFile);
        String outModel = null;
        if (params.getSettings().get("OutputModel") == null || params.getSettings().get("OutputModel").length() == 0) {
            outModel = Files.getNameWithoutExtension(paramFile) + ".bin";
            params.put("OutputModel", outModel);
        } else {
            outModel = Flags.getModel(params);
        }
        String component = Flags.getComponent(params);
        if (component.equalsIgnoreCase("POS")) {
            FixedTrainer posTaggerTrainer = new FixedTrainer(params);
            POSModel trainedModel = posTaggerTrainer.train(params);
            CmdLineUtil.writeModel("ixa-pipe-pos", new File(outModel), trainedModel);
        } else if (component.equalsIgnoreCase("Lemma")) {
            LemmatizerFixedTrainer lemmatizerTrainer = new LemmatizerFixedTrainer(params);
            LemmatizerModel trainedModel = lemmatizerTrainer.train(params);
            CmdLineUtil.writeModel("ixa-pipe-lemma", new File(outModel), trainedModel);
        }
    }

    private void loadTrainingParameters() {
        this.trainParser.addArgument("-p", "--params").required(true).help("Load the training parameters file\n");
    }

    public final void eval() throws IOException {
        String component = this.parsedArguments.getString("component");
        String testFile = this.parsedArguments.getString("testSet");
        String model = this.parsedArguments.getString("model");
        Evaluate evaluator = null;
        evaluator = component.equalsIgnoreCase("pos") ? new POSEvaluate(testFile, model) : new LemmaEvaluate(testFile, model);
        if (this.parsedArguments.getString("evalReport") != null) {
            if (this.parsedArguments.getString("evalReport").equalsIgnoreCase("detailed")) {
                evaluator.detailEvaluate();
            } else if (this.parsedArguments.getString("evalReport").equalsIgnoreCase("error")) {
                evaluator.evalError();
            } else if (this.parsedArguments.getString("evalReport").equalsIgnoreCase("brief")) {
                evaluator.evaluate();
            }
        } else {
            evaluator.evaluate();
        }
    }

    public final void server() {
        String port = this.parsedArguments.getString("port");
        String model = this.parsedArguments.getString("model");
        String lemmatizerModel = this.parsedArguments.getString("lemmatizerModel");
        String allMorphology = Boolean.toString(this.parsedArguments.getBoolean("allMorphology"));
        String multiwords = Boolean.toString(this.parsedArguments.getBoolean("multiwords"));
        String dictag = Boolean.toString(this.parsedArguments.getBoolean("dictag"));
        String outputFormat = this.parsedArguments.getString("outputFormat");
        String lang = this.parsedArguments.getString("language");
        Properties serverproperties = this.setServerProperties(port, model, lemmatizerModel, lang, multiwords, dictag, outputFormat, allMorphology);
        new StatisticalTaggerServer(serverproperties);
    }

    public final void client(InputStream inputStream, OutputStream outputStream) {
        String host = this.parsedArguments.getString("host");
        String port = this.parsedArguments.getString("port");
        try (Socket socketClient = new Socket(host, Integer.parseInt(port));
             BufferedReader inFromUser = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
             BufferedWriter outToUser = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
             BufferedWriter outToServer = new BufferedWriter(new OutputStreamWriter(socketClient.getOutputStream(), "UTF-8"));
             BufferedReader inFromServer = new BufferedReader(new InputStreamReader(socketClient.getInputStream(), "UTF-8"));){
            String kafString;
            String line;
            StringBuilder inText = new StringBuilder();
            while ((line = inFromUser.readLine()) != null) {
                inText.append(line).append("\n");
            }
            inText.append("<ENDOFDOCUMENT>").append("\n");
            outToServer.write(inText.toString());
            outToServer.flush();
            StringBuilder sb = new StringBuilder();
            while ((kafString = inFromServer.readLine()) != null) {
                sb.append(kafString).append("\n");
            }
            outToUser.write(sb.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 not supported");
        }
        catch (UnknownHostException e) {
            System.err.println("ERROR: Unknown hostname or IP address!");
            System.exit(1);
        }
        catch (NumberFormatException e) {
            System.err.println("Port number not correct!");
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadEvalParameters() {
        this.evalParser.addArgument("-c", "--component").required(true).choices("pos", "lemma").help("Choose component for evaluation");
        this.evalParser.addArgument("-m", "--model").required(true).help("Choose model");
        this.evalParser.addArgument("-t", "--testSet").required(true).help("Input testset for evaluation");
        this.evalParser.addArgument("--evalReport").required(false).choices("brief", "detailed", "error").help("Choose type of evaluation report; defaults to brief");
    }

    public final void crossValidate() throws IOException {
        String paramFile = this.parsedArguments.getString("params");
        TrainingParameters params = InputOutputUtils.loadTrainingParameters(paramFile);
        POSCrossValidator crossValidator = new POSCrossValidator(params);
        crossValidator.crossValidate(params);
    }

    private void loadCrossValidateParameters() {
        this.crossValidateParser.addArgument("-p", "--params").required(true).help("Load the Cross validation parameters file\n");
    }

    private void loadServerParameters() {
        this.serverParser.addArgument("-p", "--port").required(true).help("Port to be assigned to the server.\n");
        this.serverParser.addArgument("-m", "--model").required(true).help("It is required to provide a model to perform POS tagging.");
        this.serverParser.addArgument("-lm", "--lemmatizerModel").required(true).help("It is required to provide a lemmatizer model.");
        this.serverParser.addArgument("-l", "--language").choices("de", "en", "es", "eu", "fr", "gl", "it", "nl").required(true).help("Choose a language to perform annotation with ixa-pipe-pos.");
        this.serverParser.addArgument("--beamSize").required(false).setDefault(DEFAULT_BEAM_SIZE).help("Choose beam size for decoding, it defaults to 3.");
        this.serverParser.addArgument("-o", "--outputFormat").required(false).choices("naf", "conll").setDefault("naf").help("Choose output format; it defaults to NAF.\n");
        this.serverParser.addArgument("-mw", "--multiwords").action(Arguments.storeTrue()).help("Use to detect and process multiwords.\n");
        this.serverParser.addArgument("-d", "--dictag").action(Arguments.storeTrue()).help("Post process POS tagger output with a monosemic dictionary.\n");
        this.serverParser.addArgument("-a", "--allMorphology").action(Arguments.storeTrue()).help("Print all the POS tags and lemmas before disambiguation.\n");
    }

    private void loadClientParameters() {
        this.clientParser.addArgument("-p", "--port").required(true).help("Port of the TCP server.\n");
        this.clientParser.addArgument("--host").required(false).setDefault("localhost").help("Hostname or IP where the TCP server is running.\n");
    }

    private Properties setAnnotateProperties(String model, String lemmatizerModel, String language, String multiwords, String dictag) {
        Properties annotateProperties = new Properties();
        annotateProperties.setProperty("model", model);
        annotateProperties.setProperty("lemmatizerModel", lemmatizerModel);
        annotateProperties.setProperty("language", language);
        annotateProperties.setProperty("multiwords", multiwords);
        annotateProperties.setProperty("dictag", dictag);
        return annotateProperties;
    }

    private Properties setServerProperties(String port, String model, String lemmatizerModel, String language, String multiwords, String dictag, String outputFormat, String allMorphology) {
        Properties serverProperties = new Properties();
        serverProperties.setProperty("port", port);
        serverProperties.setProperty("model", model);
        serverProperties.setProperty("lemmatizerModel", lemmatizerModel);
        serverProperties.setProperty("language", language);
        serverProperties.setProperty("ruleBasedOption", multiwords);
        serverProperties.setProperty("dictTag", dictag);
        serverProperties.setProperty("outputFormat", outputFormat);
        serverProperties.setProperty("allMorphology", allMorphology);
        return serverProperties;
    }
}

