/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.pos;

import java.io.IOException;
import java.util.ArrayList;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;

public class MorphoSampleStream
extends FilterObjectStream<String, POSSample> {
    public MorphoSampleStream(ObjectStream<String> samples) {
        super(samples);
    }

    @Override
    public POSSample read() throws IOException {
        ArrayList<String> toks = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        String line = (String)this.samples.read();
        while (line != null && !line.equals("")) {
            String[] parts = line.split("\t");
            if (parts.length != 3) {
                System.err.println("Skipping corrupt line: " + line);
            } else {
                toks.add(parts[0]);
                tags.add(parts[1]);
            }
            line = (String)this.samples.read();
        }
        if (toks.size() > 0) {
            POSSample posSample = new POSSample(toks.toArray(new String[toks.size()]), tags.toArray(new String[tags.size()]));
            return posSample;
        }
        return null;
    }
}

