/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.pos;

import java.io.InputStream;
import java.net.URL;

public class Resources {
    public final InputStream getDictionary(String lang) {
        InputStream dict = null;
        if (lang.equalsIgnoreCase("en")) {
            dict = this.getClass().getResourceAsStream("/lemmatizer-dicts/language-tool/en-lemmatizer.txt");
        }
        if (lang.equalsIgnoreCase("es")) {
            dict = this.getClass().getResourceAsStream("/lemmatizer-dicts/freeling/es-lemmatizer.txt");
        }
        if (lang.equalsIgnoreCase("gl")) {
            dict = this.getClass().getResourceAsStream("/lemmatizer-dicts/ctag/gl-lemmatizer.txt");
        }
        return dict;
    }

    public final URL getBinaryDict(String lang) {
        URL dictURL = null;
        if (lang.equalsIgnoreCase("de")) {
            dictURL = this.getClass().getResource("/lemmatizer-dicts/de/german.dict");
        } else if (lang.equalsIgnoreCase("en")) {
            dictURL = this.getClass().getResource("/lemmatizer-dicts/language-tool/english.dict");
        } else if (lang.equalsIgnoreCase("es")) {
            dictURL = this.getClass().getResource("/lemmatizer-dicts/freeling/spanish.dict");
        } else if (lang.equalsIgnoreCase("eu")) {
            dictURL = this.getClass().getResource("/lemmatizer-dicts/eu/basque.dict");
        } else if (lang.equalsIgnoreCase("fr")) {
            dictURL = this.getClass().getResource("/lemmatizer-dicts/fr/french.dict");
        } else if (lang.equalsIgnoreCase("gl")) {
            dictURL = this.getClass().getResource("/lemmatizer-dicts/ctag/galician.dict");
        } else if (lang.equalsIgnoreCase("it")) {
            dictURL = this.getClass().getResource("/lemmatizer-dicts/it/italian.dict");
        } else if (lang.equalsIgnoreCase("nl")) {
            dictURL = this.getClass().getResource("/lemmatizer-dicts/nl/dutch.dict");
        }
        return dictURL;
    }

    public final URL getBinaryTaggerDict(String lang) {
        URL dictURL = null;
        if (lang.equalsIgnoreCase("es")) {
            dictURL = this.getClass().getResource("/lemmatizer-dicts/freeling/spanish-monosemic.dict");
        }
        if (lang.equalsIgnoreCase("gl")) {
            dictURL = this.getClass().getResource("/lemmatizer-dicts/ctag/galician-monosemic.dict");
        }
        return dictURL;
    }

    private static String mapGermanTagSetToKaf(String postag) {
        if (postag.startsWith("ADV")) {
            return "A";
        }
        if (postag.startsWith("KO")) {
            return "C";
        }
        if (postag.equalsIgnoreCase("ART")) {
            return "D";
        }
        if (postag.startsWith("ADJ")) {
            return "G";
        }
        if (postag.equalsIgnoreCase("NN")) {
            return "N";
        }
        if (postag.startsWith("NE")) {
            return "R";
        }
        if (postag.startsWith("AP")) {
            return "P";
        }
        if (postag.startsWith("PD") || postag.startsWith("PI") || postag.startsWith("PP") || postag.startsWith("PR") || postag.startsWith("PW") || postag.startsWith("PA")) {
            return "Q";
        }
        if (postag.startsWith("V")) {
            return "V";
        }
        return "O";
    }

    private static String mapEnglishTagSetToKaf(String postag) {
        if (postag.startsWith("RB")) {
            return "A";
        }
        if (postag.equalsIgnoreCase("CC")) {
            return "C";
        }
        if (postag.startsWith("D") || postag.equalsIgnoreCase("PDT")) {
            return "D";
        }
        if (postag.startsWith("J")) {
            return "G";
        }
        if (postag.equalsIgnoreCase("NN") || postag.equalsIgnoreCase("NNS")) {
            return "N";
        }
        if (postag.startsWith("NNP")) {
            return "R";
        }
        if (postag.equalsIgnoreCase("TO") || postag.equalsIgnoreCase("IN")) {
            return "P";
        }
        if (postag.startsWith("PRP") || postag.startsWith("WP")) {
            return "Q";
        }
        if (postag.startsWith("V")) {
            return "V";
        }
        return "O";
    }

    private static String mapSpanishTagSetToKaf(String postag) {
        if (postag.equalsIgnoreCase("RG") || postag.equalsIgnoreCase("RN")) {
            return "A";
        }
        if (postag.equalsIgnoreCase("CC") || postag.equalsIgnoreCase("CS")) {
            return "C";
        }
        if (postag.startsWith("D")) {
            return "D";
        }
        if (postag.startsWith("A")) {
            return "G";
        }
        if (postag.startsWith("NC")) {
            return "N";
        }
        if (postag.startsWith("NP")) {
            return "R";
        }
        if (postag.startsWith("SP")) {
            return "P";
        }
        if (postag.startsWith("P")) {
            return "Q";
        }
        if (postag.startsWith("V")) {
            return "V";
        }
        return "O";
    }

    private static String mapUDTagSetToKaf(String postag) {
        if (postag.equalsIgnoreCase("ADV")) {
            return "A";
        }
        if (postag.equalsIgnoreCase("CONJ") || postag.equalsIgnoreCase("SCONJ")) {
            return "C";
        }
        if (postag.equalsIgnoreCase("DET")) {
            return "D";
        }
        if (postag.equalsIgnoreCase("ADJ")) {
            return "G";
        }
        if (postag.equalsIgnoreCase("NOUN")) {
            return "N";
        }
        if (postag.equalsIgnoreCase("PROPN")) {
            return "R";
        }
        if (postag.equalsIgnoreCase("ADP")) {
            return "P";
        }
        if (postag.equalsIgnoreCase("PRON")) {
            return "Q";
        }
        if (postag.startsWith("V")) {
            return "V";
        }
        return "O";
    }

    private static String mapFrenchTagSetToKaf(String postag) {
        if (postag.startsWith("ADV")) {
            return "A";
        }
        if (postag.equalsIgnoreCase("CC") || postag.equalsIgnoreCase("CS")) {
            return "C";
        }
        if (postag.startsWith("D") || postag.startsWith("I")) {
            return "D";
        }
        if (postag.startsWith("ADJ")) {
            return "G";
        }
        if (postag.startsWith("NC")) {
            return "N";
        }
        if (postag.startsWith("NPP")) {
            return "R";
        }
        if (postag.startsWith("PRO") || postag.startsWith("CL")) {
            return "Q";
        }
        if (postag.equalsIgnoreCase("P") || postag.equalsIgnoreCase("P+D") || postag.equalsIgnoreCase("P+PRO")) {
            return "P";
        }
        if (postag.startsWith("V")) {
            return "V";
        }
        return "O";
    }

    private static String mapGalicianTagSetToKaf(String postag) {
        if (postag.startsWith("R")) {
            return "A";
        }
        if (postag.equalsIgnoreCase("CC") || postag.equalsIgnoreCase("CS")) {
            return "C";
        }
        if (postag.startsWith("D") || postag.startsWith("G") || postag.startsWith("X") || postag.startsWith("Q") || postag.startsWith("T") || postag.startsWith("I") || postag.startsWith("M")) {
            return "D";
        }
        if (postag.startsWith("A")) {
            return "G";
        }
        if (postag.startsWith("NC")) {
            return "N";
        }
        if (postag.startsWith("NP")) {
            return "R";
        }
        if (postag.startsWith("S")) {
            return "P";
        }
        if (postag.startsWith("P")) {
            return "Q";
        }
        if (postag.startsWith("V")) {
            return "V";
        }
        return "O";
    }

    private static String mapWotanTagSetToKaf(String postag) {
        if (postag.equalsIgnoreCase("ADV")) {
            return "A";
        }
        if (postag.equalsIgnoreCase("CONJ") || postag.equalsIgnoreCase("SCONJ")) {
            return "C";
        }
        if (postag.equalsIgnoreCase("Art")) {
            return "D";
        }
        if (postag.equalsIgnoreCase("ADJ")) {
            return "G";
        }
        if (postag.equalsIgnoreCase("N")) {
            return "N";
        }
        if (postag.equalsIgnoreCase("PROPN")) {
            return "R";
        }
        if (postag.equalsIgnoreCase("Prep")) {
            return "P";
        }
        if (postag.equalsIgnoreCase("PRON")) {
            return "Q";
        }
        if (postag.startsWith("V")) {
            return "V";
        }
        return "O";
    }

    public static String getKafTagSet(String postag, String lang) {
        String tag = null;
        tag = lang.equalsIgnoreCase("de") ? Resources.mapGermanTagSetToKaf(postag) : (lang.equalsIgnoreCase("en") ? Resources.mapEnglishTagSetToKaf(postag) : (lang.equalsIgnoreCase("es") ? Resources.mapSpanishTagSetToKaf(postag) : (lang.equalsIgnoreCase("eu") ? Resources.mapUDTagSetToKaf(postag) : (lang.equalsIgnoreCase("gl") ? Resources.mapGalicianTagSetToKaf(postag) : (lang.equalsIgnoreCase("fr") ? Resources.mapFrenchTagSetToKaf(postag) : (lang.equalsIgnoreCase("it") ? Resources.mapUDTagSetToKaf(postag) : (lang.equalsIgnoreCase("nl") ? Resources.mapWotanTagSetToKaf(postag) : "O")))))));
        return tag;
    }

    public static String setTermType(String postag) {
        if (postag.startsWith("N") || postag.startsWith("V") || postag.startsWith("G") || postag.startsWith("A")) {
            return "open";
        }
        return "close";
    }
}

