/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.pos.train;

import java.util.ArrayList;
import java.util.regex.Pattern;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.postag.POSContextGenerator;
import opennlp.tools.util.Cache;
import opennlp.tools.util.StringList;

public class BaselineContextGenerator
implements POSContextGenerator {
    private final String SE = "*SE*";
    private final String SB = "*SB*";
    private static final int PREFIX_LENGTH = 4;
    private static final int SUFFIX_LENGTH = 4;
    private static Pattern hasCap = Pattern.compile("[A-Z]");
    private static Pattern hasNum = Pattern.compile("[0-9]");
    private Cache contextsCache;
    private Object wordsKey;
    private final Dictionary dict;
    private final String[] dictGram;

    public BaselineContextGenerator(Dictionary aDict) {
        this(0, aDict);
    }

    public BaselineContextGenerator(int cacheSize, Dictionary aDict) {
        this.dict = aDict;
        this.dictGram = new String[1];
        if (cacheSize > 0) {
            this.contextsCache = new Cache(cacheSize);
        }
    }

    protected static String[] getPrefixes(String lex) {
        String[] prefs = new String[4];
        int ll = 4;
        for (int li = 0; li < ll; ++li) {
            prefs[li] = lex.substring(0, Math.min(li + 1, lex.length()));
        }
        return prefs;
    }

    protected static String[] getSuffixes(String lex) {
        String[] suffs = new String[4];
        int ll = 4;
        for (int li = 0; li < ll; ++li) {
            suffs[li] = lex.substring(Math.max(lex.length() - li - 1, 0));
        }
        return suffs;
    }

    @Override
    public final String[] getContext(int index, String[] sequence, String[] priorDecisions, Object[] additionalContext) {
        return this.getContext(index, sequence, priorDecisions);
    }

    public final String[] getContext(int index, Object[] tokens, String[] tags) {
        String tagprevprev = null;
        String tagprev = null;
        String prevprev = null;
        String prev = null;
        String lex = null;
        String nextnext = null;
        String next = null;
        lex = tokens[index].toString();
        if (tokens.length > index + 1) {
            next = tokens[index + 1].toString();
            nextnext = tokens.length > index + 2 ? tokens[index + 2].toString() : this.SE;
        } else {
            next = this.SE;
        }
        if (index - 1 >= 0) {
            prev = tokens[index - 1].toString();
            tagprev = tags[index - 1];
            if (index - 2 >= 0) {
                prevprev = tokens[index - 2].toString();
                tagprevprev = tags[index - 2];
            } else {
                prevprev = this.SB;
            }
        } else {
            prev = this.SB;
        }
        String cacheKey = index + tagprev + tagprevprev;
        if (this.contextsCache != null) {
            if (this.wordsKey == tokens) {
                String[] cachedContexts = (String[])this.contextsCache.get(cacheKey);
                if (cachedContexts != null) {
                    return cachedContexts;
                }
            } else {
                this.contextsCache.clear();
                this.wordsKey = tokens;
            }
        }
        ArrayList<String> featureList = new ArrayList<String>();
        featureList.add("default");
        featureList.add("w=" + lex);
        this.dictGram[0] = lex;
        if (this.dict == null || !this.dict.contains(new StringList(this.dictGram))) {
            String[] prefs;
            String[] suffs;
            for (String suff : suffs = BaselineContextGenerator.getSuffixes(lex)) {
                featureList.add("suf=" + suff);
            }
            for (String pref : prefs = BaselineContextGenerator.getPrefixes(lex)) {
                featureList.add("pre=" + pref);
            }
            if (lex.indexOf(45) != -1) {
                featureList.add("h");
            }
            if (hasCap.matcher(lex).find()) {
                featureList.add("c");
            }
            if (hasNum.matcher(lex).find()) {
                featureList.add("d");
            }
        }
        if (prev != null) {
            featureList.add("pw=" + prev);
            featureList.add("pw,w=" + prev + "," + lex);
            if (tagprev != null) {
                featureList.add("pt=" + tagprev);
                featureList.add("pt,w=" + tagprev + "," + lex);
            }
            if (prevprev != null) {
                featureList.add("ppw=" + prevprev);
                if (tagprevprev != null) {
                    featureList.add("pt2,pt1=" + tagprevprev + "," + tagprev);
                }
            }
        }
        if (next != null) {
            featureList.add("nw=" + next);
            if (nextnext != null) {
                featureList.add("nnw=" + nextnext);
            }
        }
        String[] contexts = featureList.toArray(new String[featureList.size()]);
        if (this.contextsCache != null) {
            this.contextsCache.put(cacheKey, contexts);
        }
        return contexts;
    }
}

