/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.Span;
import ixa.kaflib.WF;
import java.util.HashMap;

public class LinkedEntity {
    private String linkedEntityId;
    private String resource;
    private String reference;
    private double confidence;
    private Span<WF> mentions;

    LinkedEntity(String linkedEntityId) {
        this.linkedEntityId = linkedEntityId;
        this.mentions = new Span();
    }

    LinkedEntity(String linkedEntityId, Span<WF> mentions) {
        if (mentions.size() < 1) {
            throw new IllegalStateException("LinkedEntity must contain at least one reference span");
        }
        this.linkedEntityId = linkedEntityId;
        this.mentions = mentions;
    }

    LinkedEntity(LinkedEntity linkedEntity, HashMap<String, WF> WFs) {
        this.linkedEntityId = linkedEntity.linkedEntityId;
        this.resource = linkedEntity.resource;
        this.reference = linkedEntity.reference;
        this.confidence = linkedEntity.confidence;
        String id = linkedEntity.getId();
        this.mentions = linkedEntity.getWFs();
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public void setConfidence(double confidence) {
        this.confidence = confidence;
    }

    public String getId() {
        return this.linkedEntityId;
    }

    void setId(String id) {
        this.linkedEntityId = id;
    }

    public String getSpanStr() {
        String str = "";
        for (WF wf : this.mentions.getTargets()) {
            if (!str.isEmpty()) {
                str = str + " ";
            }
            str = str + wf.getForm();
        }
        return str;
    }

    public Span<WF> getWFs() {
        return this.mentions;
    }
}

