/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.tok;

import eus.ixa.ixa.pipe.tok.Annotate;
import ixa.kaflib.KAFDocument;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.Properties;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.jdom2.JDOMException;

public class CLI {
    private final String version = CLI.class.getPackage().getImplementationVersion();
    private final String commit = CLI.class.getPackage().getSpecificationVersion();
    Namespace parsedArguments = null;
    ArgumentParser argParser = ArgumentParsers.newArgumentParser("ixa-pipe-tok-" + this.version + ".jar").description("ixa-pipe-tok-" + this.version + " is a multilingual tokenizer developed by the IXA NLP Group.\n");
    private final Subparsers subParsers = this.argParser.addSubparsers().help("sub-command help");
    private final Subparser annotateParser = this.subParsers.addParser("tok").help("Tagging CLI");

    public CLI() {
        this.loadAnnotateParameters();
    }

    public static void main(String[] args) throws IOException, JDOMException {
        CLI cmdLine = new CLI();
        cmdLine.parseCLI(args);
    }

    public final void parseCLI(String[] args) throws IOException, JDOMException {
        try {
            this.parsedArguments = this.argParser.parseArgs(args);
            System.err.println("CLI options: " + this.parsedArguments);
            if (args[0].equals("tok")) {
                this.annotate(System.in, System.out);
            }
        }
        catch (ArgumentParserException e) {
            this.argParser.handleError(e);
            System.out.println("Run java -jar target/ixa-pipe-tok-" + this.version + ".jar tok -help for details");
            System.exit(1);
        }
    }

    public final void annotate(InputStream inputStream, OutputStream outputStream) throws IOException, JDOMException {
        String outputFormat = this.parsedArguments.getString("outputFormat");
        String normalize = this.parsedArguments.getString("normalize");
        String lang = this.parsedArguments.getString("lang");
        String untokenizable = this.parsedArguments.getString("untokenizable");
        String kafVersion = this.parsedArguments.getString("kafversion");
        Boolean inputKafRaw = this.parsedArguments.getBoolean("inputkaf");
        Boolean noTok = this.parsedArguments.getBoolean("notok");
        Properties properties = this.setAnnotateProperties(lang, normalize, untokenizable);
        BufferedReader breader = null;
        BufferedWriter bwriter = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
        if (noTok.booleanValue()) {
            BufferedReader noTokReader = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
            KAFDocument kaf = new KAFDocument(lang, kafVersion);
            KAFDocument.LinguisticProcessor newLp = kaf.addLinguisticProcessor("text", "ixa-pipe-tok-notok-" + lang, this.version + "-" + this.commit);
            newLp.setBeginTimestamp();
            Annotate.tokensToKAF(noTokReader, kaf);
            newLp.setEndTimestamp();
            bwriter.write(kaf.toString());
            noTokReader.close();
        } else {
            KAFDocument kaf;
            if (inputKafRaw.booleanValue()) {
                BufferedReader kafReader = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
                kaf = KAFDocument.createFromStream(kafReader);
                String text = kaf.getRawText();
                StringReader stringReader = new StringReader(text);
                breader = new BufferedReader(stringReader);
            } else {
                kaf = new KAFDocument(lang, kafVersion);
                breader = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
            }
            Annotate annotator = new Annotate(breader, properties);
            if (outputFormat.equalsIgnoreCase("conll")) {
                if (this.parsedArguments.getBoolean("offsets").booleanValue()) {
                    bwriter.write(annotator.tokenizeToCoNLL());
                } else {
                    bwriter.write(annotator.tokenizeToCoNLLOffsets());
                }
            } else if (outputFormat.equalsIgnoreCase("oneline")) {
                bwriter.write(annotator.tokenizeToText());
            } else {
                KAFDocument.LinguisticProcessor newLp = kaf.addLinguisticProcessor("text", "ixa-pipe-tok-" + lang, this.version + "-" + this.commit);
                newLp.setBeginTimestamp();
                annotator.tokenizeToKAF(kaf);
                newLp.setEndTimestamp();
                bwriter.write(kaf.toString());
            }
            breader.close();
        }
        bwriter.close();
    }

    private void loadAnnotateParameters() {
        this.annotateParser.addArgument("-l", "--lang").choices("de", "en", "es", "eu", "fr", "gl", "it", "nl").required(true).help("It is REQUIRED to choose a language to perform annotation with ixa-pipe-tok.\n");
        this.annotateParser.addArgument("-t", "--tokenizer").choices("rule").required(false).setDefault("rule").help("Choose the tokenizer type.\n");
        this.annotateParser.addArgument("-n", "--normalize").choices("alpino", "ancora", "ctag", "default", "ptb", "tiger", "tutpenn").required(false).setDefault("default").help("Set normalization method according to corpus; the default option does not escape brackets or forward slashes. See README for more details.\n");
        this.annotateParser.addArgument("-u", "--untokenizable").choices("yes", "no").setDefault("no").required(false).help("Print untokenizable characters.\n");
        this.annotateParser.addArgument("-o", "--outputFormat").choices("conll", "oneline", "naf").setDefault("naf").required(false).help("Choose output format; it defaults to NAF.\n");
        this.annotateParser.addArgument("--offsets").action(Arguments.storeFalse()).help("Do not print offset and lenght information of tokens in CoNLL format.\n");
        this.annotateParser.addArgument("--inputkaf").action(Arguments.storeTrue()).help("Use this option if input is a KAF/NAF document with <raw> layer.\n");
        this.annotateParser.addArgument("--notok").action(Arguments.storeTrue()).help("Build a KAF document from an already tokenized sentence per line file.\n");
        this.annotateParser.addArgument("--kafversion").setDefault("v1.naf").help("Set kaf document version.\n");
    }

    private Properties setAnnotateProperties(String lang, String normalize, String untokenizable) {
        Properties annotateProperties = new Properties();
        annotateProperties.setProperty("language", lang);
        annotateProperties.setProperty("normalize", normalize);
        annotateProperties.setProperty("untokenizable", untokenizable);
        return annotateProperties;
    }
}

