/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.tok;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import eus.ixa.ixa.pipe.tok.FMeasure;
import eus.ixa.ixa.pipe.tok.Token;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TokenizerEvaluator {
    private final FMeasure fmeasure = new FMeasure();
    public static final boolean DEBUG = true;

    private List<List<String>> referenceTokens(List<Token> referenceList) {
        ArrayList<List<String>> references = new ArrayList<List<String>>();
        for (int i = 0; i < referenceList.size(); ++i) {
            List<String> reference = Arrays.asList(Integer.toString(i), referenceList.get(i).getTokenValue());
            references.add(reference);
            StringBuilder sb = new StringBuilder();
            sb.append(referenceList.get(i).getTokenValue()).append(" ").append(reference).append("\n");
            try {
                Files.append(sb.toString(), new File("reference-tokens.log"), Charsets.UTF_8);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return references;
    }

    private List<List<String>> predictionTokens(List<Token> predictionList) {
        ArrayList<List<String>> predictions = new ArrayList<List<String>>();
        for (int j = 0; j < predictionList.size(); ++j) {
            List<String> prediction = Arrays.asList(Integer.toString(j), predictionList.get(j).getTokenValue());
            predictions.add(prediction);
            StringBuilder sb = new StringBuilder();
            sb.append(predictionList.get(j).getTokenValue()).append(" ").append(prediction).append("\n");
            try {
                Files.append(sb.toString(), new File("prediction-tokens.log"), Charsets.UTF_8);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return predictions;
    }

    public void evaluate(List<Token> referenceList, List<Token> predictedList) {
        List<List<String>> references = this.referenceTokens(referenceList);
        List<List<String>> predictions = this.predictionTokens(predictedList);
        this.fmeasure.updateScores(references, predictions);
    }

    public FMeasure getFMeasure() {
        return this.fmeasure;
    }
}

