/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.AnnotationContainer;
import ixa.kaflib.CLink;
import ixa.kaflib.Chunk;
import ixa.kaflib.Coref;
import ixa.kaflib.Dep;
import ixa.kaflib.Entity;
import ixa.kaflib.ExternalRef;
import ixa.kaflib.Factuality;
import ixa.kaflib.Feature;
import ixa.kaflib.IReferable;
import ixa.kaflib.IdManager;
import ixa.kaflib.LinkedEntity;
import ixa.kaflib.Mark;
import ixa.kaflib.NonTerminal;
import ixa.kaflib.Opinion;
import ixa.kaflib.Predicate;
import ixa.kaflib.ReadWriteManager;
import ixa.kaflib.Relation;
import ixa.kaflib.Relational;
import ixa.kaflib.Span;
import ixa.kaflib.TLink;
import ixa.kaflib.TLinkReferable;
import ixa.kaflib.Target;
import ixa.kaflib.Term;
import ixa.kaflib.Terminal;
import ixa.kaflib.Timex3;
import ixa.kaflib.Tree;
import ixa.kaflib.TreeNode;
import ixa.kaflib.WF;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class KAFDocument
implements Serializable {
    private String lang;
    private String version;
    private Map<String, List<LinguisticProcessor>> lps;
    private FileDesc fileDesc;
    private Public _public;
    private IdManager idManager;
    private AnnotationContainer annotationContainer;
    private static final Map<String, Character> DEP_PATH_CHARS = new HashMap<String, Character>();
    private static final Map<String, Pattern> DEP_PATH_REGEXS = new HashMap<String, Pattern>();

    public KAFDocument(String lang, String version) {
        this.lang = lang;
        this.version = version;
        this.lps = new LinkedHashMap<String, List<LinguisticProcessor>>();
        this.idManager = new IdManager();
        this.annotationContainer = new AnnotationContainer();
    }

    public static KAFDocument createFromFile(File file) throws IOException {
        KAFDocument kaf = null;
        try {
            kaf = ReadWriteManager.load(file);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        return kaf;
    }

    public static KAFDocument createFromStream(Reader stream) throws IOException, JDOMException {
        KAFDocument kaf = null;
        kaf = ReadWriteManager.load(stream);
        return kaf;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public String getLang() {
        return this.lang;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public LinguisticProcessor addLinguisticProcessor(String layer, String name) {
        String timestamp = this.createTimestamp();
        LinguisticProcessor lp = new LinguisticProcessor(name, layer);
        List<LinguisticProcessor> layerLps = this.lps.get(layer);
        if (layerLps == null) {
            layerLps = new ArrayList<LinguisticProcessor>();
            this.lps.put(layer, layerLps);
        }
        layerLps.add(lp);
        return lp;
    }

    public void addLinguisticProcessors(Map<String, List<LinguisticProcessor>> lps) {
        for (Map.Entry<String, List<LinguisticProcessor>> entry : lps.entrySet()) {
            List<LinguisticProcessor> layerLps = entry.getValue();
            for (LinguisticProcessor lp : layerLps) {
                LinguisticProcessor newLp = this.addLinguisticProcessor(entry.getKey(), lp.name);
                if (lp.hasTimestamp()) {
                    newLp.setTimestamp(lp.getTimestamp());
                }
                if (lp.hasBeginTimestamp()) {
                    newLp.beginTimestamp = lp.beginTimestamp;
                }
                if (lp.hasEndTimestamp()) {
                    newLp.setEndTimestamp(lp.getEndTimestamp());
                }
                if (!lp.hasVersion()) continue;
                newLp.setVersion(lp.getVersion());
            }
        }
    }

    public Map<String, List<LinguisticProcessor>> getLinguisticProcessors() {
        return this.lps;
    }

    public List<LinguisticProcessor> getLinguisticProcessorList() {
        ArrayList<LinguisticProcessor> result = new ArrayList<LinguisticProcessor>();
        for (List<LinguisticProcessor> lps : this.lps.values()) {
            for (LinguisticProcessor lp : lps) {
                result.add(lp);
            }
        }
        return result;
    }

    public boolean linguisticProcessorExists(String layer, String name, String version) {
        List<LinguisticProcessor> layerLPs = this.lps.get(layer);
        if (layerLPs == null) {
            return false;
        }
        for (LinguisticProcessor lp : layerLPs) {
            if (lp.version == null) {
                return false;
            }
            if (!lp.name.equals(name) || !lp.version.equals(version)) continue;
            return true;
        }
        return false;
    }

    public boolean linguisticProcessorExists(String layer, String name) {
        List<LinguisticProcessor> layerLPs = this.lps.get(layer);
        if (layerLPs == null) {
            return false;
        }
        for (LinguisticProcessor lp : layerLPs) {
            if (lp.version != null) {
                return false;
            }
            if (!lp.name.equals(name)) continue;
            return true;
        }
        return false;
    }

    public FileDesc createFileDesc() {
        this.fileDesc = new FileDesc();
        return this.fileDesc;
    }

    public FileDesc getFileDesc() {
        return this.fileDesc;
    }

    public Public createPublic() {
        this._public = new Public();
        return this._public;
    }

    public Public getPublic() {
        return this._public;
    }

    AnnotationContainer getAnnotationContainer() {
        return this.annotationContainer;
    }

    public void setRawText(String rawText) {
        this.annotationContainer.setRawText(rawText);
    }

    public WF newWF(String id, String form, int sent) {
        this.idManager.updateWFCounter(id);
        WF newWF = new WF(this.annotationContainer, id, form, sent);
        this.annotationContainer.add(newWF);
        return newWF;
    }

    public WF newWF(String form, int offset) {
        String newId = this.idManager.getNextWFId();
        int offsetVal = offset;
        WF newWF = new WF(this.annotationContainer, newId, form, 0);
        newWF.setOffset(offsetVal);
        newWF.setLength(form.length());
        this.annotationContainer.add(newWF);
        return newWF;
    }

    public WF newWF(String form, int offset, int sent) {
        String newId = this.idManager.getNextWFId();
        WF newWF = new WF(this.annotationContainer, newId, form, sent);
        newWF.setOffset(offset);
        newWF.setLength(form.length());
        this.annotationContainer.add(newWF);
        return newWF;
    }

    public Term newTerm(String id, Span<WF> span) {
        this.idManager.updateTermCounter(id);
        Term newTerm = new Term(id, span, false);
        this.annotationContainer.add(newTerm);
        return newTerm;
    }

    public Term newTerm(String id, Span<WF> span, boolean isComponent) {
        this.idManager.updateTermCounter(id);
        Term newTerm = new Term(id, span, isComponent);
        if (!isComponent) {
            this.annotationContainer.add(newTerm);
        }
        return newTerm;
    }

    public Term newTerm(Span<WF> span, boolean isComponent) {
        String newId = this.idManager.getNextTermId();
        Term newTerm = new Term(newId, span, isComponent);
        if (!isComponent) {
            this.annotationContainer.add(newTerm);
        }
        return newTerm;
    }

    public Term newTerm(String id, Span<WF> span, Integer position) {
        this.idManager.updateTermCounter(id);
        Term newTerm = new Term(id, span, false);
        this.annotationContainer.add(newTerm, position);
        return newTerm;
    }

    public Term newTerm(Span<WF> span) {
        String newId = this.idManager.getNextTermId();
        Term newTerm = new Term(newId, span, false);
        this.annotationContainer.add(newTerm);
        return newTerm;
    }

    public Term newTermOptions(String morphofeat, Span<WF> span) {
        String newId = this.idManager.getNextTermId();
        Term newTerm = new Term(newId, span, false);
        newTerm.setMorphofeat(morphofeat);
        this.annotationContainer.add(newTerm);
        return newTerm;
    }

    public Term newCompound(List<Term> terms, String lemma) {
        Span<WF> span = new Span<WF>();
        for (Term term : terms) {
            span.addTargets(term.getSpan().getTargets());
        }
        String newId = this.idManager.getNextMwId();
        Term compound = this.newTerm(newId, span, this.annotationContainer.termPosition(terms.get(0)));
        compound.setLemma(lemma);
        for (Term term : terms) {
            compound.addComponent(term);
            term.setCompound(compound);
            this.annotationContainer.remove(term);
        }
        return compound;
    }

    public Term.Sentiment newSentiment() {
        Term.Sentiment newSentiment = new Term.Sentiment();
        return newSentiment;
    }

    public Mark newMark(String id, String source, Span<WF> span) {
        this.idManager.updateMarkCounter(id);
        Mark newMark = new Mark(id, span);
        this.annotationContainer.add(newMark, source);
        return newMark;
    }

    public Mark newMark(String source, Span<WF> span) {
        String newId = this.idManager.getNextMarkId();
        Mark newMark = new Mark(newId, span);
        this.annotationContainer.add(newMark, source);
        return newMark;
    }

    public Dep newDep(Term from, Term to, String rfunc) {
        Dep newDep = new Dep(from, to, rfunc);
        this.annotationContainer.add(newDep);
        return newDep;
    }

    public Chunk newChunk(String id, String phrase, Span<Term> span) {
        this.idManager.updateChunkCounter(id);
        Chunk newChunk = new Chunk(id, span);
        newChunk.setPhrase(phrase);
        this.annotationContainer.add(newChunk);
        return newChunk;
    }

    public Chunk newChunk(String phrase, Span<Term> span) {
        String newId = this.idManager.getNextChunkId();
        Chunk newChunk = new Chunk(newId, span);
        newChunk.setPhrase(phrase);
        this.annotationContainer.add(newChunk);
        return newChunk;
    }

    public Entity newEntity(String id, List<Span<Term>> references) {
        this.idManager.updateEntityCounter(id);
        Entity newEntity = new Entity(id, references);
        this.annotationContainer.add(newEntity);
        return newEntity;
    }

    public Entity newEntity(List<Span<Term>> references) {
        String newId = this.idManager.getNextEntityId();
        Entity newEntity = new Entity(newId, references);
        this.annotationContainer.add(newEntity);
        return newEntity;
    }

    public Coref newCoref(String id, List<Span<Term>> mentions) {
        this.idManager.updateCorefCounter(id);
        Coref newCoref = new Coref(id, mentions);
        this.annotationContainer.add(newCoref);
        return newCoref;
    }

    public Coref newCoref(List<Span<Term>> mentions) {
        String newId = this.idManager.getNextCorefId();
        Coref newCoref = new Coref(newId, mentions);
        this.annotationContainer.add(newCoref);
        return newCoref;
    }

    public Timex3 newTimex3(String id, String type) {
        this.idManager.updateTimex3Counter(id);
        Timex3 newTimex3 = new Timex3(id, type);
        this.annotationContainer.add(newTimex3);
        return newTimex3;
    }

    public Timex3 newTimex3(String type) {
        String newId = this.idManager.getNextTimex3Id();
        Timex3 newTimex3 = new Timex3(newId, type);
        this.annotationContainer.add(newTimex3);
        return newTimex3;
    }

    public TLink newTLink(String id, TLinkReferable from, TLinkReferable to, String relType) {
        this.idManager.updateTLinkCounter(id);
        TLink newTLink = new TLink(id, from, to, relType);
        this.annotationContainer.add(newTLink);
        return newTLink;
    }

    public TLink newTLink(TLinkReferable from, TLinkReferable to, String relType) {
        String newId = this.idManager.getNextTLinkId();
        TLink newTLink = new TLink(newId, from, to, relType);
        this.annotationContainer.add(newTLink);
        return newTLink;
    }

    public CLink newCLink(String id, Predicate from, Predicate to) {
        this.idManager.updateCLinkCounter(id);
        CLink newCLink = new CLink(id, from, to);
        this.annotationContainer.add(newCLink);
        return newCLink;
    }

    public CLink newCLink(Predicate from, Predicate to) {
        String newId = this.idManager.getNextCLinkId();
        CLink newCLink = new CLink(newId, from, to);
        this.annotationContainer.add(newCLink);
        return newCLink;
    }

    public Factuality newFactuality(WF wf, String prediction) {
        Factuality factuality = new Factuality(wf, prediction);
        this.annotationContainer.add(factuality);
        return factuality;
    }

    public LinkedEntity newLinkedEntity(Span<WF> span) {
        String newId = this.idManager.getNextLinkedEntityId();
        LinkedEntity linkedEntity = new LinkedEntity(newId, span);
        this.annotationContainer.add(linkedEntity);
        return linkedEntity;
    }

    public Feature newProperty(String id, String lemma, List<Span<Term>> references) {
        this.idManager.updatePropertyCounter(id);
        Feature newProperty = new Feature(id, lemma, references);
        this.annotationContainer.add(newProperty);
        return newProperty;
    }

    public Feature newProperty(String lemma, List<Span<Term>> references) {
        String newId = this.idManager.getNextPropertyId();
        Feature newProperty = new Feature(newId, lemma, references);
        this.annotationContainer.add(newProperty);
        return newProperty;
    }

    public Feature newCategory(String id, String lemma, List<Span<Term>> references) {
        this.idManager.updateCategoryCounter(id);
        Feature newCategory = new Feature(id, lemma, references);
        this.annotationContainer.add(newCategory);
        return newCategory;
    }

    public Feature newCategory(String lemma, List<Span<Term>> references) {
        String newId = this.idManager.getNextCategoryId();
        Feature newCategory = new Feature(newId, lemma, references);
        this.annotationContainer.add(newCategory);
        return newCategory;
    }

    public Opinion newOpinion() {
        String newId = this.idManager.getNextOpinionId();
        Opinion newOpinion = new Opinion(newId);
        this.annotationContainer.add(newOpinion);
        return newOpinion;
    }

    public Opinion newOpinion(String id) {
        this.idManager.updateOpinionCounter(id);
        Opinion newOpinion = new Opinion(id);
        this.annotationContainer.add(newOpinion);
        return newOpinion;
    }

    public Relation newRelation(Relational from, Relational to) {
        String newId = this.idManager.getNextRelationId();
        Relation newRelation = new Relation(newId, from, to);
        this.annotationContainer.add(newRelation);
        return newRelation;
    }

    public Relation newRelation(String id, Relational from, Relational to) {
        this.idManager.updateRelationCounter(id);
        Relation newRelation = new Relation(id, from, to);
        this.annotationContainer.add(newRelation);
        return newRelation;
    }

    public Predicate newPredicate(String id, Span<Term> span) {
        this.idManager.updatePredicateCounter(id);
        Predicate newPredicate = new Predicate(id, span);
        this.annotationContainer.add(newPredicate);
        return newPredicate;
    }

    public Predicate newPredicate(Span<Term> span) {
        String newId = this.idManager.getNextPredicateId();
        Predicate newPredicate = new Predicate(newId, span);
        this.annotationContainer.add(newPredicate);
        return newPredicate;
    }

    public Predicate.Role newRole(String id, Predicate predicate, String semRole, Span<Term> span) {
        this.idManager.updateRoleCounter(id);
        Predicate.Role newRole = new Predicate.Role(id, semRole, span);
        return newRole;
    }

    public Predicate.Role newRole(Predicate predicate, String semRole, Span<Term> span) {
        String newId = this.idManager.getNextRoleId();
        Predicate.Role newRole = new Predicate.Role(newId, semRole, span);
        return newRole;
    }

    public ExternalRef newExternalRef(String resource, String reference) {
        return new ExternalRef(resource, reference);
    }

    public Tree newConstituent(TreeNode root) {
        Tree tree = new Tree(root);
        this.annotationContainer.add(tree);
        return tree;
    }

    public void addConstituencyFromParentheses(String parseOut) throws Exception {
        Tree.parenthesesToKaf(parseOut, this);
    }

    public NonTerminal newNonTerminal(String id, String label) {
        NonTerminal tn = new NonTerminal(id, label);
        String newEdgeId = this.idManager.getNextEdgeId();
        tn.setEdgeId(newEdgeId);
        return tn;
    }

    public NonTerminal newNonTerminal(String label) {
        String newId = this.idManager.getNextNonterminalId();
        String newEdgeId = this.idManager.getNextEdgeId();
        NonTerminal newNonterminal = new NonTerminal(newId, label);
        newNonterminal.setEdgeId(newEdgeId);
        return newNonterminal;
    }

    public Terminal newTerminal(String id, Span<Term> span) {
        Terminal tn = new Terminal(id, span);
        String newEdgeId = this.idManager.getNextEdgeId();
        tn.setEdgeId(newEdgeId);
        return tn;
    }

    public Terminal newTerminal(Span<Term> span) {
        String newId = this.idManager.getNextTerminalId();
        String newEdgeId = this.idManager.getNextEdgeId();
        Terminal tn = new Terminal(newId, span);
        tn.setEdgeId(newEdgeId);
        return tn;
    }

    public static Span<WF> newWFSpan() {
        return new Span<WF>();
    }

    public static Span<WF> newWFSpan(List<WF> targets) {
        return new Span<WF>(targets);
    }

    public static Span<WF> newWFSpan(List<WF> targets, WF head) {
        return new Span<WF>(targets, head);
    }

    public static Span<Term> newTermSpan() {
        return new Span<Term>();
    }

    public static Span<Term> newTermSpan(List<Term> targets) {
        return new Span<Term>(targets);
    }

    public static Span<Term> newTermSpan(List<Term> targets, Term head) {
        return new Span<Term>(targets, head);
    }

    void addUnknownLayer(Element layer) {
        this.annotationContainer.add(layer);
    }

    public String getRawText() {
        return this.annotationContainer.getRawText();
    }

    public List<WF> getWFs() {
        return this.annotationContainer.getText();
    }

    public List<List<WF>> getSentences() {
        return this.annotationContainer.getSentences();
    }

    public Integer getFirstSentence() {
        return this.annotationContainer.getText().get(0).getSent();
    }

    public Integer getNumSentences() {
        List<WF> wfs = this.annotationContainer.getText();
        Integer firstSentence = wfs.get(0).getSent();
        Integer lastSentence = wfs.get(wfs.size() - 1).getSent();
        return lastSentence - firstSentence + 1;
    }

    public List<Integer> getSentsByParagraph(Integer para) {
        if (this.annotationContainer.sentsIndexedByParagraphs.get(para) == null) {
            System.out.println(para + ": 0");
        }
        return new ArrayList<Integer>((Collection)this.annotationContainer.sentsIndexedByParagraphs.get(para));
    }

    public Integer getFirstParagraph() {
        return this.annotationContainer.getText().get(0).getPara();
    }

    public Integer getNumParagraphs() {
        return this.annotationContainer.sentsIndexedByParagraphs.keySet().size();
    }

    public List<Term> getTerms() {
        return this.annotationContainer.getTerms();
    }

    public Term termNth(Integer index) {
        return this.annotationContainer.getTerms().get(index);
    }

    public List<Term> getTermsByWFs(List<WF> wfs) {
        return this.annotationContainer.getTermsByWFs(wfs);
    }

    public List<Term> getSentenceTerms(int sent) {
        return this.annotationContainer.getSentenceTerms(sent);
    }

    public List<String> getMarkSources() {
        return this.annotationContainer.getMarkSources();
    }

    public List<Mark> getMarks(String source) {
        return this.annotationContainer.getMarks(source);
    }

    public List<Dep> getDeps() {
        return this.annotationContainer.getDeps();
    }

    public List<Chunk> getChunks() {
        return this.annotationContainer.getChunks();
    }

    public List<Entity> getEntities() {
        return this.annotationContainer.getEntities();
    }

    public List<Coref> getCorefs() {
        return this.annotationContainer.getCorefs();
    }

    public List<Timex3> getTimeExs() {
        return this.annotationContainer.getTimeExs();
    }

    public List<TLink> getTLinks() {
        return this.annotationContainer.getTLinks();
    }

    public List<CLink> getCLinks() {
        return this.annotationContainer.getCLinks();
    }

    public List<Feature> getProperties() {
        return this.annotationContainer.getProperties();
    }

    public List<Feature> getCategories() {
        return this.annotationContainer.getCategories();
    }

    public List<Opinion> getOpinions() {
        return this.annotationContainer.getOpinions();
    }

    public List<Relation> getRelations() {
        return this.annotationContainer.getRelations();
    }

    public List<Tree> getConstituents() {
        return this.annotationContainer.getConstituents();
    }

    public List<Predicate> getPredicates() {
        return this.annotationContainer.getPredicates();
    }

    public List<Factuality> getFactualities() {
        return this.annotationContainer.getFactualities();
    }

    public List<Element> getUnknownLayers() {
        return this.annotationContainer.getUnknownLayers();
    }

    public List<WF> getWFsBySent(Integer sent) {
        ArrayList wfs = this.annotationContainer.textIndexedBySent.get(sent);
        return wfs == null ? new ArrayList() : wfs;
    }

    public List<WF> getWFsByPara(Integer para) {
        return this.annotationContainer.getLayerByPara(para, this.annotationContainer.textIndexedBySent);
    }

    public List<Term> getTermsBySent(Integer sent) {
        ArrayList terms = this.annotationContainer.termsIndexedBySent.get(sent);
        return terms == null ? new ArrayList() : terms;
    }

    public List<Term> getTermsByPara(Integer para) {
        return this.annotationContainer.getLayerByPara(para, this.annotationContainer.termsIndexedBySent);
    }

    public List<Entity> getEntitiesBySent(Integer sent) {
        ArrayList entities = this.annotationContainer.entitiesIndexedBySent.get(sent);
        return entities == null ? new ArrayList() : entities;
    }

    public List<Entity> getEntitiesByPara(Integer para) {
        return this.annotationContainer.getLayerByPara(para, this.annotationContainer.entitiesIndexedBySent);
    }

    public List<Dep> getDepsBySent(Integer sent) {
        ArrayList deps = this.annotationContainer.depsIndexedBySent.get(sent);
        return deps == null ? new ArrayList() : deps;
    }

    public List<Dep> getDepsByPara(Integer para) {
        return this.annotationContainer.getLayerByPara(para, this.annotationContainer.depsIndexedBySent);
    }

    public List<Tree> getConstituentsBySent(Integer sent) {
        ArrayList trees = this.annotationContainer.constituentsIndexedBySent.get(sent);
        return trees == null ? new ArrayList() : trees;
    }

    public List<Tree> getConstituentsByPara(Integer para) {
        return this.annotationContainer.getLayerByPara(para, this.annotationContainer.constituentsIndexedBySent);
    }

    public List<Chunk> getChunksBySent(Integer sent) {
        ArrayList chunks = this.annotationContainer.chunksIndexedBySent.get(sent);
        return chunks == null ? new ArrayList() : chunks;
    }

    public List<Chunk> getChunksByPara(Integer para) {
        return this.annotationContainer.getLayerByPara(para, this.annotationContainer.chunksIndexedBySent);
    }

    public List<Predicate> getPredicatesBySent(Integer sent) {
        ArrayList predicates = this.annotationContainer.predicatesIndexedBySent.get(sent);
        return predicates == null ? new ArrayList() : predicates;
    }

    public List<Predicate> getPredicatesByPara(Integer para) {
        return this.annotationContainer.getLayerByPara(para, this.annotationContainer.predicatesIndexedBySent);
    }

    public String createTimestamp() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        String formattedDate = sdf.format(date);
        return formattedDate;
    }

    public void join(KAFDocument doc) {
        HashMap<String, WF> wfIndex = new HashMap<String, WF>();
        HashMap<String, Term> termIndex = new HashMap<String, Term>();
        for (WF wf : doc.getWFs()) {
            WF newWf = this.createFromWF(wf);
            wfIndex.put(wf.getId(), newWf);
        }
        for (Term term : doc.getTerms()) {
            Term newTerm = this.createFromTerm(term, wfIndex);
            termIndex.put(term.getId(), newTerm);
        }
        for (Dep dep : doc.getDeps()) {
            Dep newDep = this.createFromDep(dep, termIndex);
        }
        for (Chunk chunk : doc.getChunks()) {
            Chunk newChunk = this.createFromChunk(chunk, termIndex);
        }
        for (Entity entity : doc.getEntities()) {
            Entity newEntity = this.createFromEntity(entity, termIndex);
        }
        for (Tree tree : doc.getConstituents()) {
            Tree newTree = this.createFromConstituent(tree, termIndex);
        }
        for (Coref coref : doc.getCorefs()) {
            Coref newCoref = this.createFromCoref(coref, termIndex);
        }
        for (Opinion opinion : doc.getOpinions()) {
            Opinion newOpinion = this.createFromOpinion(opinion, termIndex);
        }
        for (Predicate predicate : doc.getPredicates()) {
            Predicate newPredicate = this.createFromPredicate(predicate, termIndex);
        }
    }

    public WF createFromWF(WF origWf) {
        WF newWf = this.newWF(origWf.getForm(), origWf.getOffset());
        newWf.setSent(origWf.getSent());
        if (origWf.hasPara()) {
            newWf.setPara(origWf.getPara());
        }
        if (origWf.hasPage()) {
            newWf.setPage(origWf.getPage());
        }
        if (origWf.hasOffset()) {
            newWf.setLength(origWf.getLength());
        }
        if (origWf.hasXpath()) {
            newWf.setXpath(origWf.getXpath());
        }
        return newWf;
    }

    public Term createFromTerm(Term origTerm, HashMap<String, WF> wfIndex) {
        Term newTerm;
        Span<WF> newSpan = this.newWFSpan();
        for (WF origWf : origTerm.getSpan().getTargets()) {
            newSpan.addTarget((WF)((IReferable)wfIndex.get(origWf.getId())));
        }
        Term term = newTerm = origTerm.isComponent() ? this.newTerm(newSpan, true) : this.newTerm(newSpan);
        if (origTerm.hasType()) {
            newTerm.setType(origTerm.getType());
        }
        if (origTerm.hasLemma()) {
            newTerm.setLemma(origTerm.getLemma());
        }
        if (origTerm.hasPos()) {
            newTerm.setPos(origTerm.getPos());
        }
        if (origTerm.hasMorphofeat()) {
            newTerm.setMorphofeat(origTerm.getMorphofeat());
        }
        if (origTerm.hasCase()) {
            newTerm.setCase(origTerm.getCase());
        }
        if (origTerm.hasSentiment()) {
            Term.Sentiment origSentiment = origTerm.getSentiment();
            Term.Sentiment newSentiment = this.newSentiment();
            if (origSentiment.hasResource()) {
                newSentiment.setResource(origSentiment.getResource());
            }
            if (origSentiment.hasPolarity()) {
                newSentiment.setPolarity(origSentiment.getPolarity());
            }
            if (origSentiment.hasStrength()) {
                newSentiment.setStrength(origSentiment.getStrength());
            }
            if (origSentiment.hasSubjectivity()) {
                newSentiment.setSubjectivity(origSentiment.getSubjectivity());
            }
            if (origSentiment.hasSentimentSemanticType()) {
                newSentiment.setSentimentSemanticType(origSentiment.getSentimentSemanticType());
            }
            if (origSentiment.hasSentimentModifier()) {
                newSentiment.setSentimentModifier(origSentiment.getSentimentModifier());
            }
            if (origSentiment.hasSentimentMarker()) {
                newSentiment.setSentimentMarker(origSentiment.getSentimentMarker());
            }
            if (origSentiment.hasSentimentProductFeature()) {
                newSentiment.setSentimentProductFeature(origSentiment.getSentimentProductFeature());
            }
            newTerm.setSentiment(newSentiment);
        }
        List<ExternalRef> extRefs = this.createFromExternalRefs(origTerm.getExternalRefs());
        newTerm.addExternalRefs(extRefs);
        if (!newTerm.isComponent()) {
            ArrayList origComponents = new ArrayList();
            for (Term origComponent : origComponents) {
                Term newComponent = this.createFromTerm(origComponent, wfIndex);
                newTerm.addComponent(newComponent);
            }
        }
        return newTerm;
    }

    public Dep createFromDep(Dep origDep, HashMap<String, Term> termIndex) {
        Dep newDep = this.newDep(termIndex.get(origDep.getFrom().getId()), termIndex.get(origDep.getTo().getId()), origDep.getRfunc());
        if (origDep.hasCase()) {
            newDep.setCase(origDep.getCase());
        }
        return newDep;
    }

    public Chunk createFromChunk(Chunk origChunk, HashMap<String, Term> termIndex) {
        Span<Term> newSpan = this.newTermSpan();
        for (Term origTerm : origChunk.getSpan().getTargets()) {
            newSpan.addTarget((Term)((IReferable)termIndex.get(origTerm.getId())));
        }
        Chunk newChunk = this.newChunk(origChunk.getPhrase(), newSpan);
        if (origChunk.hasCase()) {
            newChunk.setCase(origChunk.getCase());
        }
        return newChunk;
    }

    public Entity createFromEntity(Entity origEntity, HashMap<String, Term> termIndex) {
        ArrayList<Span<Term>> newReferences = new ArrayList<Span<Term>>();
        for (Span<Term> span : origEntity.getSpans()) {
            Span<Term> newSpan = this.newTermSpan();
            for (Term origTerm : span.getTargets()) {
                newSpan.addTarget((Term)((IReferable)termIndex.get(origTerm.getId())));
            }
            newReferences.add(newSpan);
        }
        Entity newEntity = this.newEntity(newReferences);
        if (origEntity.hasType()) {
            newEntity.setType(origEntity.getType());
        }
        List<ExternalRef> extRefs = this.createFromExternalRefs(origEntity.getExternalRefs());
        newEntity.addExternalRefs(extRefs);
        return newEntity;
    }

    public Tree createFromConstituent(Tree origTree, HashMap<String, Term> termIndex) {
        TreeNode newRoot = this.createFromTreeNode(origTree.getRoot(), termIndex);
        Tree newTree = this.newConstituent(newRoot);
        return newTree;
    }

    public TreeNode createFromTreeNode(TreeNode origNode, HashMap<String, Term> termIndex) {
        if (origNode.isTerminal()) {
            Span<Term> origSpan = ((Terminal)origNode).getSpan();
            Span<Term> newSpan = this.newTermSpan();
            for (Term origTerm : origSpan.getTargets()) {
                newSpan.addTarget((Term)((IReferable)termIndex.get(origTerm.getId())));
            }
            Terminal newNode = this.newTerminal(newSpan);
            if (origNode.hasEdgeId()) {
                newNode.setEdgeId(origNode.getEdgeId());
            }
            return newNode;
        }
        String label = ((NonTerminal)origNode).getLabel();
        NonTerminal newNode = this.newNonTerminal(label);
        for (TreeNode origChild : ((NonTerminal)origNode).getChildren()) {
            TreeNode newChild = this.createFromTreeNode(origChild, termIndex);
            try {
                newNode.addChild(newChild);
            }
            catch (Exception e) {}
        }
        if (origNode.hasEdgeId()) {
            newNode.setEdgeId(origNode.getEdgeId());
        }
        return newNode;
    }

    public Coref createFromCoref(Coref origCoref, HashMap<String, Term> termIndex) {
        ArrayList<Span<Term>> newMentions = new ArrayList<Span<Term>>();
        for (Span<Term> span : origCoref.getSpans()) {
            Span<Term> newSpan = this.newTermSpan();
            for (Term origTerm : span.getTargets()) {
                newSpan.addTarget((Term)((IReferable)termIndex.get(origTerm.getId())));
            }
            newMentions.add(newSpan);
        }
        Coref newCoref = this.newCoref(newMentions);
        return newCoref;
    }

    public String insertTimex3(Timex3 timex3) {
        String newId = this.idManager.getNextTimex3Id();
        timex3.setId(newId);
        this.annotationContainer.add(timex3);
        return newId;
    }

    public String insertProperty(Feature property) {
        String newId = this.idManager.getNextPropertyId();
        property.setId(newId);
        this.annotationContainer.add(property);
        return newId;
    }

    public Opinion createFromOpinion(Opinion origOpinion, HashMap<String, Term> termIndex) {
        Span<Term> newSpan;
        Opinion newOpinion = this.newOpinion();
        if (origOpinion.hasOpinionHolder()) {
            Opinion.OpinionHolder origHolder = origOpinion.getOpinionHolder();
            newSpan = this.newTermSpan();
            for (Term origTerm : origHolder.getSpan().getTargets()) {
                newSpan.addTarget((Term)((IReferable)termIndex.get(origTerm.getId())));
            }
            Opinion.OpinionHolder newHolder = newOpinion.createOpinionHolder(newSpan);
            if (origHolder.hasType()) {
                newHolder.setType(origHolder.getType());
            }
        }
        if (origOpinion.hasOpinionTarget()) {
            Opinion.OpinionTarget origTarget = origOpinion.getOpinionTarget();
            newSpan = this.newTermSpan();
            for (Term origTerm : origTarget.getSpan().getTargets()) {
                newSpan.addTarget((Term)((IReferable)termIndex.get(origTerm.getId())));
            }
            Opinion.OpinionTarget newTarget = newOpinion.createOpinionTarget(newSpan);
        }
        if (origOpinion.hasOpinionExpression()) {
            Opinion.OpinionExpression origExpression = origOpinion.getOpinionExpression();
            newSpan = this.newTermSpan();
            for (Term origTerm : origExpression.getSpan().getTargets()) {
                newSpan.addTarget((Term)((IReferable)termIndex.get(origTerm.getId())));
            }
            Opinion.OpinionExpression newExpression = newOpinion.createOpinionExpression(newSpan);
            if (origExpression.hasPolarity()) {
                newExpression.setPolarity(origExpression.getPolarity());
            }
            if (origExpression.hasStrength()) {
                newExpression.setStrength(origExpression.getStrength());
            }
            if (origExpression.hasSubjectivity()) {
                newExpression.setSubjectivity(origExpression.getSubjectivity());
            }
            if (origExpression.hasSentimentSemanticType()) {
                newExpression.setSentimentSemanticType(origExpression.getSentimentSemanticType());
            }
            if (origExpression.hasSentimentProductFeature()) {
                newExpression.setSentimentProductFeature(origExpression.getSentimentProductFeature());
            }
        }
        return newOpinion;
    }

    public Predicate createFromPredicate(Predicate origPredicate, HashMap<String, Term> termIndex) {
        Span<Term> newSpan = this.newTermSpan();
        for (Term origTerm : origPredicate.getSpan().getTargets()) {
            newSpan.addTarget((Term)((IReferable)termIndex.get(origTerm.getId())));
        }
        Predicate newPredicate = this.newPredicate(newSpan);
        if (origPredicate.hasUri()) {
            newPredicate.setUri(origPredicate.getUri());
        }
        if (origPredicate.hasConfidence()) {
            newPredicate.setConfidence(origPredicate.getConfidence());
        }
        List<Predicate.Role> origRoles = origPredicate.getRoles();
        ArrayList newRoles = new ArrayList();
        for (Predicate.Role origRole : origRoles) {
            Span<Term> newRoleSpan = this.newTermSpan();
            for (Term origTerm : origRole.getSpan().getTargets()) {
                newRoleSpan.addTarget((Term)((IReferable)termIndex.get(origTerm.getId())));
            }
            Predicate.Role newRole = this.newRole(newPredicate, origRole.getSemRole(), newRoleSpan);
            List<ExternalRef> extRefs = this.createFromExternalRefs(origRole.getExternalRefs());
            newRole.addExternalRefs(extRefs);
            newPredicate.addRole(newRole);
        }
        List<ExternalRef> extRefs = this.createFromExternalRefs(origPredicate.getExternalRefs());
        newPredicate.addExternalRefs(extRefs);
        return newPredicate;
    }

    public List<ExternalRef> createFromExternalRefs(List<ExternalRef> origExternalRefs) {
        ArrayList<ExternalRef> newExtRefs = new ArrayList<ExternalRef>();
        for (ExternalRef origExtRef : origExternalRefs) {
            newExtRefs.add(this.createFromExternalRef(origExtRef));
        }
        return newExtRefs;
    }

    public ExternalRef createFromExternalRef(ExternalRef origExternalRef) {
        ExternalRef newExtRef = this.newExternalRef(origExternalRef.getResource(), origExternalRef.getReference());
        if (origExternalRef.hasConfidence()) {
            newExtRef.setConfidence(origExternalRef.getConfidence());
        }
        for (ExternalRef subRef : origExternalRef.getExternalRefs()) {
            newExtRef.addExternalRef(this.createFromExternalRef(subRef));
        }
        return newExtRef;
    }

    public void save(String filename) {
        ReadWriteManager.save(this, filename);
    }

    public String toString() {
        return ReadWriteManager.kafToStr(this);
    }

    public void print() {
        ReadWriteManager.print(this);
    }

    public LinguisticProcessor addLinguisticProcessor(String layer, String name, String version) {
        LinguisticProcessor lp = this.addLinguisticProcessor(layer, name);
        lp.setVersion(version);
        return lp;
    }

    public LinguisticProcessor addLinguisticProcessor(String layer, String name, String timestamp, String version) {
        LinguisticProcessor lp = this.addLinguisticProcessor(layer, name);
        lp.setTimestamp(timestamp);
        lp.setVersion(version);
        return lp;
    }

    public WF newWF(String id, String form) {
        return this.newWF(id, form, 0);
    }

    public WF newWF(String form) {
        return this.newWF(form, 0);
    }

    public WF createWF(String id, String form) {
        return this.newWF(id, form, 0);
    }

    public WF createWF(String form) {
        return this.newWF(form, 0);
    }

    public WF createWF(String form, int offset) {
        return this.newWF(form, offset);
    }

    public Term newTerm(String id, String type, String lemma, String pos, Span<WF> span) {
        Term term = this.newTerm(id, span);
        term.setType(type);
        term.setLemma(lemma);
        term.setPos(pos);
        return term;
    }

    public Term newTerm(String type, String lemma, String pos, Span<WF> span) {
        Term term = this.newTerm(span);
        term.setType(type);
        term.setLemma(lemma);
        term.setPos(pos);
        return term;
    }

    public Term newTermOptions(String type, String lemma, String pos, String morphofeat, Span<WF> span) {
        Term newTerm = this.newTermOptions(morphofeat, span);
        newTerm.setType(type);
        newTerm.setLemma(lemma);
        newTerm.setPos(pos);
        return newTerm;
    }

    public Term createTerm(String id, String type, String lemma, String pos, List<WF> wfs) {
        return this.newTerm(id, type, lemma, pos, KAFDocument.list2Span(wfs));
    }

    public Term createTerm(String type, String lemma, String pos, List<WF> wfs) {
        return this.newTerm(type, lemma, pos, KAFDocument.list2Span(wfs));
    }

    public Term createTermOptions(String type, String lemma, String pos, String morphofeat, List<WF> wfs) {
        return this.newTermOptions(type, lemma, pos, morphofeat, KAFDocument.list2Span(wfs));
    }

    public Term.Sentiment createSentiment() {
        return this.newSentiment();
    }

    public Dep createDep(Term from, Term to, String rfunc) {
        return this.createDep(from, to, rfunc);
    }

    public Chunk createChunk(String id, Term head, String phrase, List<Term> terms) {
        return this.newChunk(id, phrase, KAFDocument.list2Span(terms, head));
    }

    public Chunk createChunk(Term head, String phrase, List<Term> terms) {
        return this.newChunk(phrase, KAFDocument.list2Span(terms, head));
    }

    public Entity createEntity(String id, String type, List<List<Term>> references) {
        ArrayList<Span<Term>> spanReferences = new ArrayList<Span<Term>>();
        for (List<Term> list : references) {
            spanReferences.add(KAFDocument.list2Span(list));
        }
        Entity entity = this.newEntity(id, spanReferences);
        entity.setType(type);
        return entity;
    }

    public Entity createEntity(String type, List<List<Term>> references) {
        ArrayList<Span<Term>> spanReferences = new ArrayList<Span<Term>>();
        for (List<Term> list : references) {
            spanReferences.add(KAFDocument.list2Span(list));
        }
        Entity entity = this.newEntity(spanReferences);
        entity.setType(type);
        return entity;
    }

    public Coref createCoref(String id, List<List<Target>> references) {
        ArrayList<Span<Term>> spanReferences = new ArrayList<Span<Term>>();
        for (List<Target> list : references) {
            spanReferences.add(KAFDocument.targetList2Span(list));
        }
        return this.newCoref(id, spanReferences);
    }

    public Coref createCoref(List<List<Target>> references) {
        ArrayList<Span<Term>> spanReferences = new ArrayList<Span<Term>>();
        for (List<Target> list : references) {
            spanReferences.add(KAFDocument.targetList2Span(list));
        }
        return this.newCoref(spanReferences);
    }

    public Feature createProperty(String id, String lemma, List<List<Term>> references) {
        ArrayList<Span<Term>> spanReferences = new ArrayList<Span<Term>>();
        for (List<Term> list : references) {
            spanReferences.add(KAFDocument.list2Span(list));
        }
        return this.newProperty(id, lemma, spanReferences);
    }

    public Feature createProperty(String lemma, List<List<Term>> references) {
        ArrayList<Span<Term>> spanReferences = new ArrayList<Span<Term>>();
        for (List<Term> list : references) {
            spanReferences.add(KAFDocument.list2Span(list));
        }
        return this.newProperty(lemma, spanReferences);
    }

    public Feature createCategory(String id, String lemma, List<List<Term>> references) {
        ArrayList<Span<Term>> spanReferences = new ArrayList<Span<Term>>();
        for (List<Term> list : references) {
            spanReferences.add(KAFDocument.list2Span(list));
        }
        return this.newCategory(id, lemma, spanReferences);
    }

    public Feature createCategory(String lemma, List<List<Term>> references) {
        ArrayList<Span<Term>> spanReferences = new ArrayList<Span<Term>>();
        for (List<Term> list : references) {
            spanReferences.add(KAFDocument.list2Span(list));
        }
        return this.newCategory(lemma, spanReferences);
    }

    public Opinion createOpinion() {
        return this.newOpinion();
    }

    public Opinion createOpinion(String id) {
        return this.newOpinion(id);
    }

    public Relation createRelation(Relational from, Relational to) {
        return this.newRelation(from, to);
    }

    public Relation createRelation(String id, Relational from, Relational to) {
        return this.newRelation(id, from, to);
    }

    public ExternalRef createExternalRef(String resource, String reference) {
        return this.newExternalRef(resource, reference);
    }

    public static Target createTarget(Term term) {
        return new Target(term, false);
    }

    public static Target createTarget(Term term, boolean isHead) {
        return new Target(term, isHead);
    }

    public void removeLayer(Layer layer) {
        this.annotationContainer.removeLayer(layer);
    }

    static <T extends IReferable> Span<T> list2Span(List<T> list) {
        Span<IReferable> span = new Span<IReferable>();
        for (IReferable elem : list) {
            span.addTarget(elem);
        }
        return span;
    }

    static <T extends IReferable> Span<T> list2Span(List<T> list, T head) {
        Span<IReferable> span = new Span<IReferable>();
        for (IReferable elem : list) {
            if (head == elem) {
                span.addTarget(elem, true);
                continue;
            }
            span.addTarget(elem);
        }
        return span;
    }

    static Span<Term> targetList2Span(List<Target> list) {
        Span<Term> span = new Span<Term>();
        for (Target target : list) {
            if (target.isHead()) {
                span.addTarget(target.getTerm(), true);
                continue;
            }
            span.addTarget(target.getTerm());
        }
        return span;
    }

    static List<Target> span2TargetList(Span<Term> span) {
        ArrayList<Target> list = new ArrayList<Target>();
        for (Term t : span.getTargets()) {
            list.add(KAFDocument.createTarget(t, t == span.getHead()));
        }
        return list;
    }

    public List<Term> getTermsFromWFs(List<String> wfIds) {
        return this.annotationContainer.getTermsByWFIds(wfIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static char getDepPathChar(String label) {
        String key = label.toLowerCase();
        Map<String, Character> map = DEP_PATH_CHARS;
        synchronized (map) {
            Character letter = DEP_PATH_CHARS.get(key);
            if (letter == null) {
                letter = Character.valueOf('a');
                for (Character ch : DEP_PATH_CHARS.values()) {
                    if (ch.charValue() < letter.charValue()) continue;
                    letter = Character.valueOf((char)(ch.charValue() + '\u0001'));
                }
                DEP_PATH_CHARS.put(key, letter);
            }
            return letter.charValue();
        }
    }

    private static String getDepPathString(Term from, Iterable<Dep> path) {
        StringBuilder builder = new StringBuilder("_");
        Term term = from;
        for (Dep dep : path) {
            char prefix;
            if (dep.getFrom() == term) {
                prefix = '+';
                term = dep.getTo();
            } else {
                prefix = '-';
                term = dep.getFrom();
            }
            for (String label : dep.getRfunc().split("-")) {
                Character letter = Character.valueOf(KAFDocument.getDepPathChar(label));
                builder.append(prefix).append(letter);
            }
            builder.append("_");
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pattern getDepPathRegex(String pattern) {
        Map<String, Pattern> map = DEP_PATH_REGEXS;
        synchronized (map) {
            Pattern regex = DEP_PATH_REGEXS.get(pattern);
            if (regex == null) {
                StringBuilder builder = new StringBuilder();
                builder.append('_');
                int start = -1;
                for (int i = 0; i < pattern.length(); ++i) {
                    char ch = pattern.charAt(i);
                    if (Character.isLetter(ch) || ch == '-') {
                        if (start >= 0) continue;
                        start = i;
                        continue;
                    }
                    if (start >= 0) {
                        boolean inverse = pattern.charAt(start) == '-';
                        String label = pattern.substring(inverse ? start + 1 : start, i);
                        char letter = KAFDocument.getDepPathChar(label);
                        builder.append("([^_]*").append(Pattern.quote((inverse ? "-" : "+") + letter)).append("[^_]*_)");
                        start = -1;
                    }
                    if (Character.isWhitespace(ch)) continue;
                    builder.append(ch);
                }
                regex = Pattern.compile(builder.toString());
                DEP_PATH_REGEXS.put(pattern, regex);
            }
            return regex;
        }
    }

    public boolean matchDepPath(Term from, Iterable<Dep> path, String pattern) {
        String pathString = KAFDocument.getDepPathString(from, path);
        Pattern pathRegex = KAFDocument.getDepPathRegex(pattern);
        return pathRegex.matcher(pathString).matches();
    }

    public List<Dep> getDepPath(Term from, Term to) {
        if (from == to) {
            return Collections.emptyList();
        }
        ArrayList<Dep> toPath = new ArrayList<Dep>();
        Dep dep = this.getDepToTerm(to);
        while (dep != null) {
            toPath.add(dep);
            if (dep.getFrom() == from) {
                Collections.reverse(toPath);
                return toPath;
            }
            dep = this.getDepToTerm(dep.getFrom());
        }
        ArrayList<Dep> fromPath = new ArrayList<Dep>();
        Dep dep2 = this.getDepToTerm(from);
        while (dep2 != null) {
            fromPath.add(dep2);
            if (dep2.getFrom() == to) {
                return fromPath;
            }
            for (int i = 0; i < toPath.size(); ++i) {
                if (dep2.getFrom() != ((Dep)toPath.get(i)).getFrom()) continue;
                for (int j = i; j >= 0; --j) {
                    fromPath.add((Dep)toPath.get(j));
                }
                return fromPath;
            }
            dep2 = this.getDepToTerm(dep2.getFrom());
        }
        return null;
    }

    public Dep getDepToTerm(Term term) {
        for (Dep dep : this.getDepsByTerm(term)) {
            if (dep.getTo() != term) continue;
            return dep;
        }
        return null;
    }

    public List<Dep> getDepsFromTerm(Term term) {
        ArrayList<Dep> result = new ArrayList<Dep>();
        for (Dep dep : this.getDepsByTerm(term)) {
            if (dep.getFrom() != term) continue;
            result.add(dep);
        }
        return result;
    }

    public List<Dep> getDepsByTerm(Term term) {
        return this.annotationContainer.getDepsByTerm(term);
    }

    public Term getTermsHead(Iterable<Term> descendents) {
        HashSet<Term> termSet = new HashSet<Term>();
        for (Term term : descendents) {
            termSet.add(term);
        }
        Term root = null;
        for (Term term : termSet) {
            Dep dep = this.getDepToTerm(term);
            if (dep != null && termSet.contains(dep.getFrom())) continue;
            if (root == null) {
                root = term;
                continue;
            }
            if (root == term) continue;
            return null;
        }
        return root;
    }

    public Set<Term> getTermsByDepAncestors(Iterable<Term> ancestors) {
        HashSet<Term> terms = new HashSet<Term>();
        LinkedList<Term> queue = new LinkedList<Term>();
        for (Term term : ancestors) {
            terms.add(term);
            queue.add(term);
        }
        while (!queue.isEmpty()) {
            Term term = (Term)queue.remove(0);
            List<Dep> deps = this.getDepsByTerm(term);
            for (Dep dep : deps) {
                if (dep.getFrom() != term || !terms.add(dep.getTo())) continue;
                queue.add(dep.getTo());
            }
        }
        return terms;
    }

    public Set<Term> getTermsByDepAncestors(Iterable<Term> ancestors, String pattern) {
        HashSet<Term> result = new HashSet<Term>();
        for (Term term : ancestors) {
            for (Term descendent : this.getTermsByDepAncestors(Collections.singleton(term))) {
                List<Dep> path = this.getDepPath(term, descendent);
                if (!this.matchDepPath(term, path, pattern)) continue;
                result.add(descendent);
            }
        }
        return result;
    }

    public List<Entity> getEntitiesByTerm(Term term) {
        return this.annotationContainer.getEntitiesByTerm(term);
    }

    public List<Predicate> getPredicatesByTerm(Term term) {
        return this.annotationContainer.getPredicatesByTerm(term);
    }

    public class LinguisticProcessor
    implements Serializable {
        String layer;
        String name;
        String timestamp;
        String beginTimestamp;
        String endTimestamp;
        String version;
        String hostname;

        private LinguisticProcessor(String name, String layer) {
            this.layer = layer;
            this.name = name;
        }

        private LinguisticProcessor(String name, String timestamp, String version) {
            this.name = name;
            this.timestamp = timestamp;
            this.version = version;
        }

        public String getLayer() {
            return this.layer;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean hasTimestamp() {
            return this.timestamp != null;
        }

        public void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        public void setTimestamp() {
            String timestamp;
            this.timestamp = timestamp = KAFDocument.this.createTimestamp();
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public boolean hasBeginTimestamp() {
            return this.beginTimestamp != null;
        }

        public void setBeginTimestamp(String timestamp) {
            this.beginTimestamp = timestamp;
            if (!this.hasHostname().booleanValue()) {
                try {
                    this.setHostname(InetAddress.getLocalHost().getHostName());
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        }

        public void setBeginTimestamp() {
            String timestamp = KAFDocument.this.createTimestamp();
            this.setBeginTimestamp(timestamp);
        }

        public String getBeginTimestamp() {
            return this.beginTimestamp;
        }

        public boolean hasEndTimestamp() {
            return this.endTimestamp != null;
        }

        public void setEndTimestamp(String timestamp) {
            this.endTimestamp = timestamp;
        }

        public void setEndTimestamp() {
            String timestamp;
            this.endTimestamp = timestamp = KAFDocument.this.createTimestamp();
        }

        public String getEndTimestamp() {
            return this.endTimestamp;
        }

        public boolean hasVersion() {
            return this.version != null;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }

        public Boolean hasHostname() {
            return this.hostname != null;
        }

        public String getHostname() {
            return this.hostname;
        }

        public void setHostname(String hostname) {
            this.hostname = hostname;
        }
    }

    public class Public
    implements Serializable {
        public String publicId;
        public String uri;

        private Public() {
        }
    }

    public class FileDesc
    implements Serializable {
        public String author;
        public String title;
        public String filename;
        public String filetype;
        public Integer pages;
        public String creationtime;

        private FileDesc() {
        }
    }

    public static enum Layer {
        text,
        terms,
        marks,
        deps,
        chunks,
        entities,
        properties,
        categories,
        coreferences,
        opinions,
        relations,
        srl,
        constituency;

    }
}

