/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.tok;

import java.util.Arrays;
import java.util.List;

public final class FMeasure {
    private long selected;
    private long target;
    private long truePositive;

    public double getPrecisionScore() {
        return this.selected > 0L ? (double)this.truePositive / (double)this.selected : 0.0;
    }

    public double getRecallScore() {
        return this.target > 0L ? (double)this.truePositive / (double)this.target : 0.0;
    }

    public double getFMeasure() {
        if (this.getPrecisionScore() + this.getRecallScore() > 0.0) {
            return 2.0 * (this.getPrecisionScore() * this.getRecallScore()) / (this.getPrecisionScore() + this.getRecallScore());
        }
        return -1.0;
    }

    public void updateScores(List<List<String>> references, List<List<String>> predictions) {
        this.truePositive += (long)FMeasure.countTruePositives(references, predictions);
        this.selected += (long)predictions.size();
        this.target += (long)references.size();
    }

    public void mergeInto(FMeasure measure) {
        this.selected += measure.selected;
        this.target += measure.target;
        this.truePositive += measure.truePositive;
    }

    public String toString() {
        return "Precision: " + Double.toString(this.getPrecisionScore()) + "\n" + "Recall: " + Double.toString(this.getRecallScore()) + "\n" + "F-Measure: " + Double.toString(this.getFMeasure());
    }

    static int countTruePositives(List<List<String>> references, List<List<String>> predictions) {
        int truePositives = 0;
        for (List<String> reference : references) {
            for (List<String> prediction : predictions) {
                if (!Arrays.equals(prediction.toArray(new Object[prediction.size()]), reference.toArray(new Object[reference.size()]))) continue;
                ++truePositives;
            }
        }
        return truePositives;
    }

    public static double precision(List<List<String>> references, List<List<String>> predictions) {
        if (predictions.size() > 0) {
            return (double)FMeasure.countTruePositives(references, predictions) / (double)predictions.size();
        }
        return Double.NaN;
    }

    public static double recall(List<List<String>> references, List<List<String>> predictions) {
        if (references.size() > 0) {
            return (double)FMeasure.countTruePositives(references, predictions) / (double)references.size();
        }
        return Double.NaN;
    }
}

