/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.CLink;
import ixa.kaflib.Chunk;
import ixa.kaflib.Coref;
import ixa.kaflib.Dep;
import ixa.kaflib.Entity;
import ixa.kaflib.Factuality;
import ixa.kaflib.Feature;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.LinkedEntity;
import ixa.kaflib.Mark;
import ixa.kaflib.NonTerminal;
import ixa.kaflib.Opinion;
import ixa.kaflib.Predicate;
import ixa.kaflib.Relation;
import ixa.kaflib.Relational;
import ixa.kaflib.TLink;
import ixa.kaflib.Term;
import ixa.kaflib.Terminal;
import ixa.kaflib.Timex3;
import ixa.kaflib.Tree;
import ixa.kaflib.TreeNode;
import ixa.kaflib.WF;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.Element;

class AnnotationContainer
implements Serializable {
    private String rawText = new String();
    private List<WF> text = new ArrayList<WF>();
    private int nextOffset = 0;
    private List<Term> terms = new ArrayList<Term>();
    private Map<String, List<Mark>> marks = new HashMap<String, List<Mark>>();
    private List<Dep> deps = new ArrayList<Dep>();
    private List<Chunk> chunks = new ArrayList<Chunk>();
    private List<Entity> entities = new ArrayList<Entity>();
    private List<Feature> properties = new ArrayList<Feature>();
    private List<Feature> categories = new ArrayList<Feature>();
    private List<Coref> coreferences = new ArrayList<Coref>();
    private List<Timex3> timeExpressions = new ArrayList<Timex3>();
    private List<TLink> tLinks = new ArrayList<TLink>();
    private List<CLink> cLinks = new ArrayList<CLink>();
    private List<Factuality> factualities = new ArrayList<Factuality>();
    private List<LinkedEntity> linkedEntities = new ArrayList<LinkedEntity>();
    private List<Opinion> opinions = new ArrayList<Opinion>();
    private List<Relation> relations = new ArrayList<Relation>();
    private List<Predicate> predicates = new ArrayList<Predicate>();
    private List<Tree> trees = new ArrayList<Tree>();
    private List<Element> unknownLayers = new ArrayList<Element>();
    private HashMap<String, List<Term>> termsIndexedByWF = new HashMap();
    private HashMap<String, Map<String, List<Mark>>> marksIndexedByWf = new HashMap();
    private HashMap<String, List<Dep>> depsIndexedByTerm = new HashMap();
    private HashMap<String, List<Chunk>> chunksIndexedByTerm = new HashMap();
    private HashMap<String, List<Entity>> entitiesIndexedByTerm = new HashMap();
    private HashMap<String, List<Coref>> corefsIndexedByTerm = new HashMap();
    private HashMap<String, List<Timex3>> timeExsIndexedByWF = new HashMap();
    private HashMap<String, List<Factuality>> factsIndexedByWF;
    private HashMap<String, List<LinkedEntity>> linkedEntitiesIndexedByWF = new HashMap();
    private HashMap<String, List<Feature>> propertiesIndexedByTerm;
    private HashMap<String, List<Feature>> categoriesIndexedByTerm;
    private HashMap<String, List<Opinion>> opinionsIndexedByTerm;
    private HashMap<String, List<Relation>> relationsIndexedByRelational;
    private HashMap<String, List<Predicate>> predicatesIndexedByTerm;
    HashMap<Integer, List<WF>> textIndexedBySent;
    HashMap<Integer, List<Term>> termsIndexedBySent;
    HashMap<Integer, Map<String, List<Mark>>> marksIndexedBySent;
    HashMap<Integer, List<Entity>> entitiesIndexedBySent;
    HashMap<Integer, List<Dep>> depsIndexedBySent;
    HashMap<Integer, List<Chunk>> chunksIndexedBySent;
    HashMap<Integer, List<Coref>> corefsIndexedBySent;
    HashMap<Integer, List<Timex3>> timeExsIndexedBySent;
    HashMap<Integer, List<Factuality>> factsIndexedBySent;
    HashMap<Integer, List<LinkedEntity>> linkedEntitiesIndexedBySent;
    HashMap<Integer, List<Feature>> propertiesIndexedBySent;
    HashMap<Integer, List<Feature>> categoriesIndexedBySent;
    HashMap<Integer, List<Opinion>> opinionsIndexedBySent;
    HashMap<Integer, List<Relation>> relationsIndexedBySent;
    HashMap<Integer, List<Predicate>> predicatesIndexedBySent;
    HashMap<Integer, List<Tree>> constituentsIndexedBySent;
    HashMap<Integer, LinkedHashSet<Integer>> sentsIndexedByParagraphs;

    AnnotationContainer() {
        this.factsIndexedByWF = new HashMap();
        this.propertiesIndexedByTerm = new HashMap();
        this.categoriesIndexedByTerm = new HashMap();
        this.opinionsIndexedByTerm = new HashMap();
        this.relationsIndexedByRelational = new HashMap();
        this.predicatesIndexedByTerm = new HashMap();
        this.textIndexedBySent = new HashMap();
        this.termsIndexedBySent = new HashMap();
        this.marksIndexedBySent = new HashMap();
        this.entitiesIndexedBySent = new HashMap();
        this.depsIndexedBySent = new HashMap();
        this.chunksIndexedBySent = new HashMap();
        this.corefsIndexedBySent = new HashMap();
        this.timeExsIndexedBySent = new HashMap();
        this.linkedEntitiesIndexedBySent = new HashMap();
        this.factsIndexedBySent = new HashMap();
        this.propertiesIndexedBySent = new HashMap();
        this.categoriesIndexedBySent = new HashMap();
        this.opinionsIndexedBySent = new HashMap();
        this.relationsIndexedBySent = new HashMap();
        this.predicatesIndexedBySent = new HashMap();
        this.constituentsIndexedBySent = new HashMap();
        this.sentsIndexedByParagraphs = new HashMap();
    }

    private <T> void indexBySent(T annotation, Integer sent, HashMap<Integer, List<T>> index) {
        if (sent >= 0) {
            if (index.get(sent) == null) {
                index.put(sent, new ArrayList());
            }
            index.get(sent).add(annotation);
        }
    }

    private void indexMarkBySent(Mark mark, String source, Integer sent) {
        if (sent >= 0) {
            if (this.marksIndexedBySent.get(sent) == null) {
                this.marksIndexedBySent.put(sent, new HashMap());
            }
            if (this.marksIndexedBySent.get(sent).get(source) == null) {
                this.marksIndexedBySent.get(sent).put(source, new ArrayList());
            }
            this.marksIndexedBySent.get(sent).get(source).add(mark);
        }
    }

    void indexSentByPara(Integer sent, Integer para) {
        if (sent >= 0 && para >= 0) {
            if (this.sentsIndexedByParagraphs.get(para) == null) {
                this.sentsIndexedByParagraphs.put(para, new LinkedHashSet());
            }
            this.sentsIndexedByParagraphs.get(para).add(sent);
        }
    }

    public List<Integer> getSentsByParagraph(Integer para) {
        return new ArrayList<Integer>((Collection)this.sentsIndexedByParagraphs.get(para));
    }

    <T> List<T> getLayerByPara(Integer para, HashMap<Integer, List<T>> index) {
        ArrayList layer = new ArrayList();
        for (Integer sent : this.getSentsByParagraph(para)) {
            layer.addAll(index.get(sent));
        }
        return layer;
    }

    String getRawText() {
        return this.rawText;
    }

    List<WF> getText() {
        return this.text;
    }

    List<Term> getTerms() {
        return this.terms;
    }

    List<String> getMarkSources() {
        return new ArrayList<String>(this.marks.keySet());
    }

    List<Mark> getMarks(String source) {
        return this.marks.get(source) == null ? new ArrayList<Mark>() : this.marks.get(source);
    }

    List<Dep> getDeps() {
        return this.deps;
    }

    List<Chunk> getChunks() {
        return this.chunks;
    }

    List<Entity> getEntities() {
        return this.entities;
    }

    List<Feature> getProperties() {
        return this.properties;
    }

    List<Feature> getCategories() {
        return this.categories;
    }

    List<Coref> getCorefs() {
        return this.coreferences;
    }

    List<Timex3> getTimeExs() {
        return this.timeExpressions;
    }

    List<TLink> getTLinks() {
        return this.tLinks;
    }

    List<CLink> getCLinks() {
        return this.cLinks;
    }

    List<Factuality> getFactualities() {
        return this.factualities;
    }

    List<LinkedEntity> getLinkedEntities() {
        return this.linkedEntities;
    }

    List<Opinion> getOpinions() {
        return this.opinions;
    }

    List<Relation> getRelations() {
        return this.relations;
    }

    List<Predicate> getPredicates() {
        return this.predicates;
    }

    List<Tree> getConstituents() {
        return this.trees;
    }

    List<Element> getUnknownLayers() {
        return this.unknownLayers;
    }

    void setRawText(String str) {
        this.rawText = str;
    }

    void add(WF wf) {
        this.text.add(wf);
        this.indexBySent(wf, wf.getSent(), this.textIndexedBySent);
    }

    private <T> void indexAnnotation(T annotation, String hashId, HashMap<String, List<T>> index) {
        if (index.get(hashId) == null) {
            index.put(hashId, new ArrayList());
        }
        index.get(hashId).add(annotation);
    }

    private void indexMarkByWf(Mark mark, String source, String tid) {
        if (this.marksIndexedByWf.get(tid) == null) {
            this.marksIndexedByWf.put(tid, new HashMap());
        }
        if (this.marksIndexedByWf.get(tid).get(source) == null) {
            this.marksIndexedByWf.get(tid).put(source, new ArrayList());
        }
        this.marksIndexedByWf.get(tid).get(source).add(mark);
    }

    void add(Term term) {
        this.add(term, this.terms.size());
    }

    void add(Term term, int index) {
        this.terms.add(index, term);
        for (WF wf : term.getWFs()) {
            this.indexAnnotation(term, wf.getId(), this.termsIndexedByWF);
        }
        if (!term.isComponent()) {
            this.indexBySent(term, term.getSent(), this.termsIndexedBySent);
        }
    }

    void remove(Term term) {
        this.terms.remove(term);
    }

    void add(Mark mark, String source) {
        List<Mark> sourceMarks = this.marks.get(source);
        if (sourceMarks == null) {
            sourceMarks = new ArrayList<Mark>();
        }
        sourceMarks.add(mark);
        this.marks.put(source, sourceMarks);
        for (WF wf : mark.getSpan().getTargets()) {
            this.indexMarkByWf(mark, source, wf.getId());
        }
        this.indexMarkBySent(mark, source, mark.getSpan().getTargets().get(0).getSent());
    }

    void add(Dep dep) {
        String tId;
        this.deps.add(dep);
        if (dep.getFrom() != null) {
            tId = dep.getFrom().getId();
            this.indexAnnotation(dep, tId, this.depsIndexedByTerm);
        }
        if (dep.getTo() != null) {
            tId = dep.getTo().getId();
            this.indexAnnotation(dep, tId, this.depsIndexedByTerm);
        }
        this.indexBySent(dep, dep.getFrom().getSent(), this.depsIndexedBySent);
    }

    void add(Chunk chunk) {
        this.chunks.add(chunk);
        for (Term term : chunk.getTerms()) {
            this.indexAnnotation(chunk, term.getId(), this.chunksIndexedByTerm);
        }
        this.indexBySent(chunk, chunk.getSpan().getTargets().get(0).getSent(), this.chunksIndexedBySent);
    }

    void add(Entity entity) {
        this.entities.add(entity);
        for (Term term : entity.getTerms()) {
            this.indexAnnotation(entity, term.getId(), this.entitiesIndexedByTerm);
        }
        this.indexBySent(entity, entity.getSpans().get(0).getTargets().get(0).getSent(), this.entitiesIndexedBySent);
    }

    void add(Feature feature) {
        if (feature.isAProperty()) {
            this.properties.add(feature);
            for (Term term : feature.getTerms()) {
                this.indexAnnotation(feature, term.getId(), this.propertiesIndexedByTerm);
            }
        } else {
            this.categories.add(feature);
            for (Term term : feature.getTerms()) {
                this.indexAnnotation(feature, term.getId(), this.categoriesIndexedByTerm);
            }
        }
    }

    void add(Coref coref) {
        this.coreferences.add(coref);
        for (Term term : coref.getTerms()) {
            this.indexAnnotation(coref, term.getId(), this.corefsIndexedByTerm);
        }
    }

    void add(Timex3 timex3) {
        this.timeExpressions.add(timex3);
        if (timex3.hasSpan()) {
            for (WF wf : timex3.getSpan().getTargets()) {
                this.indexAnnotation(timex3, wf.getId(), this.timeExsIndexedByWF);
            }
        }
    }

    void add(TLink tLink) {
        this.tLinks.add(tLink);
    }

    void add(CLink cLink) {
        this.cLinks.add(cLink);
    }

    void add(Factuality factuality) {
        this.factualities.add(factuality);
        this.indexAnnotation(factuality, factuality.getWF().getId(), this.factsIndexedByWF);
    }

    void add(LinkedEntity linkedEntity) {
        this.linkedEntities.add(linkedEntity);
        if (linkedEntity.getWFs() != null) {
            for (WF wf : linkedEntity.getWFs().getTargets()) {
                this.indexAnnotation(linkedEntity, wf.getId(), this.linkedEntitiesIndexedByWF);
            }
        }
    }

    void add(Opinion opinion) {
        this.opinions.add(opinion);
    }

    void add(Relation relation) {
        String rId;
        this.relations.add(relation);
        if (relation.getFrom() != null) {
            rId = relation.getFrom().getId();
            this.indexAnnotation(relation, rId, this.relationsIndexedByRelational);
        }
        if (relation.getTo() != null) {
            rId = relation.getTo().getId();
            this.indexAnnotation(relation, rId, this.relationsIndexedByRelational);
        }
    }

    void add(Predicate predicate) {
        this.predicates.add(predicate);
        for (Term term : predicate.getTerms()) {
            this.indexAnnotation(predicate, term.getId(), this.predicatesIndexedByTerm);
        }
        this.indexBySent(predicate, predicate.getSpan().getTargets().get(0).getSent(), this.predicatesIndexedBySent);
    }

    void add(Tree tree) {
        this.trees.add(tree);
        TreeNode currentNode = tree.getRoot();
        while (!currentNode.isTerminal()) {
            currentNode = ((NonTerminal)currentNode).getChildren().get(0);
        }
        Integer sent = ((Terminal)currentNode).getSpan().getTargets().get(0).getSent();
        this.indexBySent(tree, sent, this.constituentsIndexedBySent);
    }

    void add(Element layer) {
        this.unknownLayers.add(layer);
    }

    void indexTermBySent(Term term, Integer sent) {
        if (sent == -1) {
            throw new IllegalStateException("You can't call indexTermBySent not having defined the sentence for its WFs");
        }
        List<Term> sentTerms = this.termsIndexedBySent.get(sent);
        if (sentTerms == null) {
            sentTerms = new ArrayList<Term>();
            this.termsIndexedBySent.put(sent, sentTerms);
        }
        sentTerms.add(term);
    }

    List<List<WF>> getSentences() {
        ArrayList<List<WF>> sentences = new ArrayList<List<WF>>();
        Set<Integer> sentNumsSet = this.textIndexedBySent.keySet();
        ArrayList<Integer> sentNumsList = new ArrayList<Integer>(sentNumsSet);
        Collections.sort(sentNumsList);
        Iterator i$ = sentNumsList.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            List<WF> wfs = this.textIndexedBySent.get(i);
            sentences.add(wfs);
        }
        return sentences;
    }

    Integer termPosition(Term term) {
        return this.terms.indexOf(term);
    }

    List<WF> getSentenceWFs(int sent) {
        return this.textIndexedBySent.get(sent);
    }

    List<Term> getSentenceTerms(int sent) {
        return this.termsIndexedBySent.get(sent);
    }

    Term getTermByWF(WF wf) {
        List<Term> terms = this.termsIndexedByWF.get(wf.getId());
        if (terms == null) {
            return null;
        }
        return terms.get(0);
    }

    List<Term> getTermsByWF(WF wf) {
        ArrayList terms = this.termsIndexedByWF.get(wf.getId());
        return terms == null ? new ArrayList() : terms;
    }

    List<Term> getTermsByWFs(List<WF> wfs) {
        LinkedHashSet<Term> terms = new LinkedHashSet<Term>();
        for (WF wf : wfs) {
            terms.addAll(this.getTermsByWF(wf));
        }
        return new ArrayList<Term>(terms);
    }

    List<Mark> getMarksByWf(WF wf, String source) {
        Map<String, List<Mark>> marks = this.marksIndexedByWf.get(wf.getId());
        if (marks == null) {
            return new ArrayList<Mark>();
        }
        ArrayList sourceMarks = marks.get(source);
        return sourceMarks == null ? new ArrayList() : sourceMarks;
    }

    List<Dep> getDepsByTerm(Term term) {
        ArrayList deps = this.depsIndexedByTerm.get(term.getId());
        return deps == null ? new ArrayList() : deps;
    }

    List<Chunk> getChunksByTerm(Term term) {
        ArrayList chunks = this.chunksIndexedByTerm.get(term.getId());
        return chunks == null ? new ArrayList() : chunks;
    }

    List<Entity> getEntitiesByTerm(Term term) {
        ArrayList entities = this.entitiesIndexedByTerm.get(term.getId());
        return entities == null ? new ArrayList() : entities;
    }

    List<Coref> getCorefsByTerm(Term term) {
        ArrayList corefs = this.corefsIndexedByTerm.get(term.getId());
        return corefs == null ? new ArrayList() : corefs;
    }

    List<Timex3> getTimeExsByWF(WF wf) {
        ArrayList timeExs = this.timeExsIndexedByWF.get(wf.getId());
        return timeExs == null ? new ArrayList() : timeExs;
    }

    List<Feature> getPropertiesByTerm(Term term) {
        ArrayList properties = this.propertiesIndexedByTerm.get(term.getId());
        return properties == null ? new ArrayList() : properties;
    }

    List<Feature> getCategoriesByTerm(Term term) {
        ArrayList categories = this.categoriesIndexedByTerm.get(term.getId());
        return categories == null ? new ArrayList() : categories;
    }

    List<Opinion> getOpinionsByTerm(Term term) {
        ArrayList opinions = this.opinionsIndexedByTerm.get(term.getId());
        return opinions == null ? new ArrayList() : opinions;
    }

    List<Relation> getRelationsByRelational(Relational relational) {
        ArrayList relations = this.relationsIndexedByRelational.get(relational.getId());
        return relations == null ? new ArrayList() : relations;
    }

    List<Predicate> getPredicatesByTerm(Term term) {
        ArrayList predicates = this.predicatesIndexedByTerm.get(term.getId());
        return predicates == null ? new ArrayList() : predicates;
    }

    List<Dep> getDepsByTerms(List<Term> terms) {
        LinkedHashSet<Dep> deps = new LinkedHashSet<Dep>();
        for (Term term : terms) {
            deps.addAll(this.getDepsByTerm(term));
        }
        return new ArrayList<Dep>(deps);
    }

    List<Chunk> getChunksByTerms(List<Term> terms) {
        LinkedHashSet<Chunk> chunks = new LinkedHashSet<Chunk>();
        for (Term term : terms) {
            chunks.addAll(this.getChunksByTerm(term));
        }
        return new ArrayList<Chunk>(chunks);
    }

    List<Entity> getEntitiesByTerms(List<Term> terms) {
        LinkedHashSet<Entity> entities = new LinkedHashSet<Entity>();
        for (Term term : terms) {
            entities.addAll(this.getEntitiesByTerm(term));
        }
        return new ArrayList<Entity>(entities);
    }

    List<Coref> getCorefsByTerms(List<Term> terms) {
        LinkedHashSet<Coref> corefs = new LinkedHashSet<Coref>();
        for (Term term : terms) {
            corefs.addAll(this.getCorefsByTerm(term));
        }
        return new ArrayList<Coref>(corefs);
    }

    List<Timex3> getTimeExsByWFs(List<WF> wfs) {
        LinkedHashSet<Timex3> timeExs = new LinkedHashSet<Timex3>();
        for (WF wf : wfs) {
            timeExs.addAll(this.getTimeExsByWF(wf));
        }
        return new ArrayList<Timex3>(timeExs);
    }

    List<Feature> getPropertiesByTerms(List<Term> terms) {
        LinkedHashSet<Feature> properties = new LinkedHashSet<Feature>();
        for (Term term : terms) {
            properties.addAll(this.getPropertiesByTerm(term));
        }
        return new ArrayList<Feature>(properties);
    }

    List<Feature> getCategoriesByTerms(List<Term> terms) {
        LinkedHashSet<Feature> categories = new LinkedHashSet<Feature>();
        for (Term term : terms) {
            categories.addAll(this.getCategoriesByTerm(term));
        }
        return new ArrayList<Feature>(categories);
    }

    List<Opinion> getOpinionsByTerms(List<Term> terms) {
        LinkedHashSet<Opinion> opinions = new LinkedHashSet<Opinion>();
        for (Term term : terms) {
            opinions.addAll(this.getOpinionsByTerm(term));
        }
        return new ArrayList<Opinion>(opinions);
    }

    List<Relation> getRelationsByRelationals(List<Relational> relationals) {
        LinkedHashSet<Relation> relations = new LinkedHashSet<Relation>();
        for (Relational relational : relationals) {
            relations.addAll(this.getRelationsByRelational(relational));
        }
        return new ArrayList<Relation>(relations);
    }

    List<Predicate> getPredicatesByTerms(List<Term> terms) {
        LinkedHashSet<Predicate> predicates = new LinkedHashSet<Predicate>();
        for (Term term : terms) {
            predicates.addAll(this.getPredicatesByTerm(term));
        }
        return new ArrayList<Predicate>(predicates);
    }

    int getNextOffset() {
        return this.nextOffset;
    }

    List<Term> getTermsByWFIds(List<String> wfIds) {
        LinkedHashSet terms = new LinkedHashSet();
        for (String wfId : wfIds) {
            terms.addAll(this.termsIndexedByWF.get(wfId));
        }
        return new ArrayList<Term>(terms);
    }

    void removeLayer(KAFDocument.Layer layer) {
        switch (layer) {
            case text: {
                this.text.clear();
                break;
            }
            case terms: {
                this.terms.clear();
                break;
            }
            case deps: {
                this.deps.clear();
                break;
            }
            case chunks: {
                this.chunks.clear();
                break;
            }
            case entities: {
                this.entities.clear();
                break;
            }
            case properties: {
                this.properties.clear();
                break;
            }
            case categories: {
                this.categories.clear();
                break;
            }
            case coreferences: {
                this.coreferences.clear();
                break;
            }
            case opinions: {
                this.opinions.clear();
                break;
            }
            case relations: {
                this.relations.clear();
                break;
            }
            case srl: {
                this.predicates.clear();
                break;
            }
            case constituency: {
                this.trees.clear();
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong layer");
            }
        }
    }
}

