/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.tok;

import eus.ixa.ixa.pipe.tok.Annotate;
import eus.ixa.ixa.pipe.tok.RuleBasedTokenizerServer;
import ixa.kaflib.KAFDocument;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.jdom2.JDOMException;

public class CLI {
    private final String version = CLI.class.getPackage().getImplementationVersion();
    private final String commit = CLI.class.getPackage().getSpecificationVersion();
    Namespace parsedArguments = null;
    ArgumentParser argParser = ArgumentParsers.newArgumentParser("ixa-pipe-tok-" + this.version + ".jar").description("ixa-pipe-tok-" + this.version + " is a multilingual tokenizer developed by the IXA NLP Group.\n");
    private final Subparsers subParsers = this.argParser.addSubparsers().help("sub-command help");
    private final Subparser annotateParser = this.subParsers.addParser("tok").help("Tagging CLI");
    private Subparser serverParser;
    private Subparser clientParser;

    public CLI() {
        this.loadAnnotateParameters();
        this.serverParser = this.subParsers.addParser("server").help("Start TCP socket server");
        this.loadServerParameters();
        this.clientParser = this.subParsers.addParser("client").help("Send queries to the TCP socket server");
        this.loadClientParameters();
    }

    public static void main(String[] args) throws IOException, JDOMException {
        CLI cmdLine = new CLI();
        cmdLine.parseCLI(args);
    }

    public final void parseCLI(String[] args) throws IOException, JDOMException {
        try {
            this.parsedArguments = this.argParser.parseArgs(args);
            System.err.println("CLI options: " + this.parsedArguments);
            if (args[0].equals("tok")) {
                this.annotate(System.in, System.out);
            } else if (args[0].equals("server")) {
                this.server();
            } else if (args[0].equals("client")) {
                this.client(System.in, System.out);
            }
        }
        catch (ArgumentParserException e) {
            this.argParser.handleError(e);
            System.out.println("Run java -jar target/ixa-pipe-tok-" + this.version + ".jar (tok|server|client) -help for details");
            System.exit(1);
        }
    }

    public final void annotate(InputStream inputStream, OutputStream outputStream) throws IOException, JDOMException {
        String outputFormat = this.parsedArguments.getString("outputFormat");
        String normalize = this.parsedArguments.getString("normalize");
        String lang = this.parsedArguments.getString("lang");
        String untokenizable = this.parsedArguments.getString("untokenizable");
        String kafVersion = this.parsedArguments.getString("kafversion");
        Boolean inputKafRaw = this.parsedArguments.getBoolean("inputkaf");
        Boolean noTok = this.parsedArguments.getBoolean("notok");
        String hardParagraph = this.parsedArguments.getString("hardParagraph");
        Properties properties = this.setAnnotateProperties(lang, normalize, untokenizable, hardParagraph);
        BufferedReader breader = null;
        BufferedWriter bwriter = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
        if (noTok.booleanValue()) {
            BufferedReader noTokReader = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
            KAFDocument kaf = new KAFDocument(lang, kafVersion);
            KAFDocument.LinguisticProcessor newLp = kaf.addLinguisticProcessor("text", "ixa-pipe-tok-notok-" + lang, this.version + "-" + this.commit);
            newLp.setBeginTimestamp();
            Annotate.tokensToKAF(noTokReader, kaf);
            newLp.setEndTimestamp();
            bwriter.write(kaf.toString());
            noTokReader.close();
        } else {
            KAFDocument kaf;
            if (inputKafRaw.booleanValue()) {
                BufferedReader kafReader = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
                kaf = KAFDocument.createFromStream(kafReader);
                String text = kaf.getRawText();
                StringReader stringReader = new StringReader(text);
                breader = new BufferedReader(stringReader);
            } else {
                kaf = new KAFDocument(lang, kafVersion);
                breader = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
            }
            Annotate annotator = new Annotate(breader, properties);
            if (outputFormat.equalsIgnoreCase("conll")) {
                if (this.parsedArguments.getBoolean("offsets").booleanValue()) {
                    bwriter.write(annotator.tokenizeToCoNLL());
                } else {
                    bwriter.write(annotator.tokenizeToCoNLLOffsets());
                }
            } else if (outputFormat.equalsIgnoreCase("oneline")) {
                bwriter.write(annotator.tokenizeToText());
            } else {
                KAFDocument.LinguisticProcessor newLp = kaf.addLinguisticProcessor("text", "ixa-pipe-tok-" + lang, this.version + "-" + this.commit);
                newLp.setBeginTimestamp();
                annotator.tokenizeToKAF(kaf);
                newLp.setEndTimestamp();
                bwriter.write(kaf.toString());
            }
            breader.close();
        }
        bwriter.close();
    }

    public final void server() {
        String port = this.parsedArguments.getString("port");
        String lang = this.parsedArguments.getString("lang");
        String normalize = this.parsedArguments.getString("normalize");
        String untokenizable = this.parsedArguments.getString("untokenizable");
        String kafversion = this.parsedArguments.getString("kafversion");
        String inputkaf = String.valueOf(this.parsedArguments.getBoolean("inputkaf"));
        String notok = String.valueOf(this.parsedArguments.getBoolean("notok"));
        String hardParagraph = this.parsedArguments.getString("hardParagraph");
        String offsets = String.valueOf(this.parsedArguments.getBoolean("offsets"));
        String outputFormat = this.parsedArguments.getString("outputFormat");
        Properties serverProperties = this.setServerProperties(port, lang, normalize, untokenizable, kafversion, inputkaf, notok, outputFormat, offsets, hardParagraph);
        new RuleBasedTokenizerServer(serverProperties);
    }

    public final void client(InputStream inputStream, OutputStream outputStream) {
        String host = this.parsedArguments.getString("host");
        String port = this.parsedArguments.getString("port");
        try (Socket socketClient = new Socket(host, Integer.parseInt(port));
             BufferedReader inFromUser = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
             BufferedWriter outToUser = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
             BufferedWriter outToServer = new BufferedWriter(new OutputStreamWriter(socketClient.getOutputStream(), "UTF-8"));
             BufferedReader inFromServer = new BufferedReader(new InputStreamReader(socketClient.getInputStream(), "UTF-8"));){
            String kafString;
            String line;
            StringBuilder inText = new StringBuilder();
            while ((line = inFromUser.readLine()) != null) {
                inText.append(line).append("\n");
            }
            inText.append("<ENDOFDOCUMENT>").append("\n");
            outToServer.write(inText.toString());
            outToServer.flush();
            StringBuilder sb = new StringBuilder();
            while ((kafString = inFromServer.readLine()) != null) {
                sb.append(kafString).append("\n");
            }
            outToUser.write(sb.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 not supported");
        }
        catch (UnknownHostException e) {
            System.err.println("ERROR: Unknown hostname or IP address!");
            System.exit(1);
        }
        catch (NumberFormatException e) {
            System.err.println("Port number not correct!");
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadAnnotateParameters() {
        this.annotateParser.addArgument("-l", "--lang").choices("de", "en", "es", "eu", "fr", "gl", "it", "nl").required(true).help("It is REQUIRED to choose a language to perform annotation with ixa-pipe-tok.\n");
        this.annotateParser.addArgument("-n", "--normalize").choices("alpino", "ancora", "ctag", "default", "ptb", "tiger", "tutpenn").required(false).setDefault("default").help("Set normalization method according to corpus; the default option does not escape brackets or forward slashes. See README for more details.\n");
        this.annotateParser.addArgument("-u", "--untokenizable").choices("yes", "no").setDefault("no").required(false).help("Print untokenizable characters.\n");
        this.annotateParser.addArgument("-o", "--outputFormat").choices("conll", "oneline", "naf").setDefault("naf").required(false).help("Choose output format; it defaults to NAF.\n");
        this.annotateParser.addArgument("--offsets").action(Arguments.storeFalse()).help("Do not print offset and lenght information of tokens in CoNLL format.\n");
        this.annotateParser.addArgument("--inputkaf").action(Arguments.storeTrue()).help("Use this option if input is a KAF/NAF document with <raw> layer.\n");
        this.annotateParser.addArgument("--notok").action(Arguments.storeTrue()).help("Build a KAF document from an already tokenized sentence per line file.\n");
        this.annotateParser.addArgument("--hardParagraph").choices("yes", "no").setDefault("no").required(false).help("Do not segment paragraphs. Ever.\n");
        this.annotateParser.addArgument("--kafversion").setDefault("v1.naf").help("Set kaf document version.\n");
    }

    private void loadServerParameters() {
        this.serverParser.addArgument("-p", "--port").required(true).help("Port to be assigned to the server.\n");
        this.serverParser.addArgument("-l", "--lang").choices("de", "en", "es", "eu", "fr", "gl", "it", "nl").required(true).help("It is REQUIRED to choose a language to perform annotation with ixa-pipe-tok.\n");
        this.serverParser.addArgument("-n", "--normalize").choices("alpino", "ancora", "ctag", "default", "ptb", "tiger", "tutpenn").required(false).setDefault("default").help("Set normalization method according to corpus; the default option does not escape brackets or forward slashes. See README for more details.\n");
        this.serverParser.addArgument("-u", "--untokenizable").choices("yes", "no").setDefault("no").required(false).help("Print untokenizable characters.\n");
        this.serverParser.addArgument("-o", "--outputFormat").choices("conll", "oneline", "naf").setDefault("naf").required(false).help("Choose output format; it defaults to NAF.\n");
        this.serverParser.addArgument("--offsets").action(Arguments.storeFalse()).help("Do not print offset and lenght information of tokens in CoNLL format.\n");
        this.serverParser.addArgument("--inputkaf").action(Arguments.storeTrue()).help("Use this option if input is a KAF/NAF document with <raw> layer.\n");
        this.serverParser.addArgument("--notok").action(Arguments.storeTrue()).help("Build a KAF document from an already tokenized sentence per line file.\n");
        this.serverParser.addArgument("--hardParagraph").choices("yes", "no").setDefault("no").required(false).help("Do not segment paragraphs. Ever.\n");
        this.serverParser.addArgument("--kafversion").setDefault("v1.naf").help("Set kaf document version.\n");
    }

    private void loadClientParameters() {
        this.clientParser.addArgument("-p", "--port").required(true).help("Port of the TCP server.\n");
        this.clientParser.addArgument("--host").required(false).setDefault("localhost").help("Hostname or IP where the TCP server is running.\n");
    }

    private Properties setAnnotateProperties(String lang, String normalize, String untokenizable, String hardParagraph) {
        Properties annotateProperties = new Properties();
        annotateProperties.setProperty("language", lang);
        annotateProperties.setProperty("normalize", normalize);
        annotateProperties.setProperty("untokenizable", untokenizable);
        annotateProperties.setProperty("hardParagraph", hardParagraph);
        return annotateProperties;
    }

    private Properties setServerProperties(String port, String lang, String normalize, String untokenizable, String kafversion, String inputkaf, String notok, String outputFormat, String offsets, String hardParagraph) {
        Properties serverProperties = new Properties();
        serverProperties.setProperty("port", port);
        serverProperties.setProperty("language", lang);
        serverProperties.setProperty("normalize", normalize);
        serverProperties.setProperty("untokenizable", untokenizable);
        serverProperties.setProperty("kafversion", kafversion);
        serverProperties.setProperty("inputkaf", inputkaf);
        serverProperties.setProperty("notok", notok);
        serverProperties.setProperty("outputFormat", outputFormat);
        serverProperties.setProperty("offsets", offsets);
        serverProperties.setProperty("hardParagraph", hardParagraph);
        return serverProperties;
    }
}

