/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.Annotation;
import ixa.kaflib.AnnotationContainer;
import ixa.kaflib.CLink;
import ixa.kaflib.Chunk;
import ixa.kaflib.Coref;
import ixa.kaflib.Dep;
import ixa.kaflib.Entity;
import ixa.kaflib.ExternalRef;
import ixa.kaflib.Factuality;
import ixa.kaflib.Factvalue;
import ixa.kaflib.Feature;
import ixa.kaflib.IdManager;
import ixa.kaflib.IdentifiableAnnotation;
import ixa.kaflib.LinkedEntity;
import ixa.kaflib.Mark;
import ixa.kaflib.MultiLayerAnnotation;
import ixa.kaflib.NonTerminal;
import ixa.kaflib.Opinion;
import ixa.kaflib.ParagraphLevelAnnotation;
import ixa.kaflib.Predicate;
import ixa.kaflib.PredicateAnchor;
import ixa.kaflib.ReadWriteManager;
import ixa.kaflib.Relation;
import ixa.kaflib.Relational;
import ixa.kaflib.SentenceLevelAnnotation;
import ixa.kaflib.Span;
import ixa.kaflib.Statement;
import ixa.kaflib.TLink;
import ixa.kaflib.TLinkReferable;
import ixa.kaflib.Target;
import ixa.kaflib.Term;
import ixa.kaflib.Terminal;
import ixa.kaflib.Timex3;
import ixa.kaflib.Topic;
import ixa.kaflib.Tree;
import ixa.kaflib.TreeNode;
import ixa.kaflib.WF;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class KAFDocument
implements Serializable {
    static List<AnnotationType> highLevelAnnotationTypes;
    static Map<AnnotationType, Layer> highLevelAnnotationType2Layer;
    static Map<AnnotationType, Class<?>> annotationTypeClasses;
    private static final long serialVersionUID = 42L;
    private Map<String, List<Term>> wfId2Terms;
    private String lang;
    private String version;
    private Map<String, List<LinguisticProcessor>> lps;
    private FileDesc fileDesc;
    private Public _public;
    private IdManager idManager;
    private AnnotationContainer annotationContainer;
    private static final Map<String, Character> DEP_PATH_CHARS;
    private static final Map<String, Pattern> DEP_PATH_REGEXS;

    public KAFDocument(String lang, String version) {
        this.lang = lang;
        this.version = version;
        this.lps = new LinkedHashMap<String, List<LinguisticProcessor>>();
        this.idManager = new IdManager();
        this.annotationContainer = new AnnotationContainer();
        highLevelAnnotationTypes = Arrays.asList(AnnotationType.WF, AnnotationType.TERM, AnnotationType.ENTITY, AnnotationType.CHUNK, AnnotationType.DEP, AnnotationType.TREE, AnnotationType.COREF, AnnotationType.OPINION, AnnotationType.CLINK, AnnotationType.TLINK, AnnotationType.PREDICATE_ANCHOR, AnnotationType.PREDICATE, AnnotationType.TIMEX3, AnnotationType.FACTUALITY, AnnotationType.FACTVALUE, AnnotationType.MARK, AnnotationType.PROPERTY, AnnotationType.CATEGORY, AnnotationType.LINKED_ENTITY, AnnotationType.RELATION, AnnotationType.TOPIC, AnnotationType.STATEMENT);
        highLevelAnnotationType2Layer = new HashMap<AnnotationType, Layer>();
        highLevelAnnotationType2Layer.put(AnnotationType.WF, Layer.TEXT);
        highLevelAnnotationType2Layer.put(AnnotationType.TERM, Layer.TERMS);
        highLevelAnnotationType2Layer.put(AnnotationType.ENTITY, Layer.ENTITIES);
        highLevelAnnotationType2Layer.put(AnnotationType.CHUNK, Layer.CHUNKS);
        highLevelAnnotationType2Layer.put(AnnotationType.DEP, Layer.DEPS);
        highLevelAnnotationType2Layer.put(AnnotationType.TREE, Layer.CONSTITUENCY);
        highLevelAnnotationType2Layer.put(AnnotationType.COREF, Layer.COREFERENCES);
        highLevelAnnotationType2Layer.put(AnnotationType.OPINION, Layer.OPINIONS);
        highLevelAnnotationType2Layer.put(AnnotationType.CLINK, Layer.CAUSAL_RELATIONS);
        highLevelAnnotationType2Layer.put(AnnotationType.TLINK, Layer.TEMPORAL_RELATIONS);
        highLevelAnnotationType2Layer.put(AnnotationType.PREDICATE_ANCHOR, Layer.TEMPORAL_RELATIONS);
        highLevelAnnotationType2Layer.put(AnnotationType.PREDICATE, Layer.SRL);
        highLevelAnnotationType2Layer.put(AnnotationType.TIMEX3, Layer.TIME_EXPRESSIONS);
        highLevelAnnotationType2Layer.put(AnnotationType.FACTUALITY, Layer.FACTUALITIES);
        highLevelAnnotationType2Layer.put(AnnotationType.FACTVALUE, Layer.FACTUALITY_LAYER);
        highLevelAnnotationType2Layer.put(AnnotationType.MARK, Layer.MARKABLES);
        highLevelAnnotationType2Layer.put(AnnotationType.PROPERTY, Layer.PROPERTIES);
        highLevelAnnotationType2Layer.put(AnnotationType.CATEGORY, Layer.CATEGORIES);
        highLevelAnnotationType2Layer.put(AnnotationType.LINKED_ENTITY, Layer.LINKED_ENTITIES);
        highLevelAnnotationType2Layer.put(AnnotationType.RELATION, Layer.RELATIONS);
        highLevelAnnotationType2Layer.put(AnnotationType.TOPIC, Layer.TOPICS);
        highLevelAnnotationType2Layer.put(AnnotationType.STATEMENT, Layer.ATTRIBUTION);
        annotationTypeClasses = new HashMap();
        annotationTypeClasses.put(AnnotationType.WF, WF.class);
        annotationTypeClasses.put(AnnotationType.TERM, Term.class);
        annotationTypeClasses.put(AnnotationType.COMPONENT, Term.class);
        annotationTypeClasses.put(AnnotationType.MW, Term.class);
        annotationTypeClasses.put(AnnotationType.ENTITY, Entity.class);
        annotationTypeClasses.put(AnnotationType.CHUNK, Chunk.class);
        annotationTypeClasses.put(AnnotationType.DEP, Dep.class);
        annotationTypeClasses.put(AnnotationType.TREE, Tree.class);
        annotationTypeClasses.put(AnnotationType.NON_TERMINAL, NonTerminal.class);
        annotationTypeClasses.put(AnnotationType.TERMINAL, Terminal.class);
        annotationTypeClasses.put(AnnotationType.COREF, Coref.class);
        annotationTypeClasses.put(AnnotationType.OPINION, Opinion.class);
        annotationTypeClasses.put(AnnotationType.OPINION_HOLDER, Opinion.OpinionHolder.class);
        annotationTypeClasses.put(AnnotationType.OPINION_TARGET, Opinion.OpinionTarget.class);
        annotationTypeClasses.put(AnnotationType.OPINION_EXPRESSION, Opinion.OpinionExpression.class);
        annotationTypeClasses.put(AnnotationType.CLINK, CLink.class);
        annotationTypeClasses.put(AnnotationType.TLINK, TLink.class);
        annotationTypeClasses.put(AnnotationType.PREDICATE, Predicate.class);
        annotationTypeClasses.put(AnnotationType.ROLE, Predicate.Role.class);
        annotationTypeClasses.put(AnnotationType.TIMEX3, Timex3.class);
        annotationTypeClasses.put(AnnotationType.FACTUALITY, Factuality.class);
        annotationTypeClasses.put(AnnotationType.FACTVALUE, Factvalue.class);
        annotationTypeClasses.put(AnnotationType.MARK, Mark.class);
        annotationTypeClasses.put(AnnotationType.PROPERTY, Feature.class);
        annotationTypeClasses.put(AnnotationType.CATEGORY, Feature.class);
        annotationTypeClasses.put(AnnotationType.LINKED_ENTITY, LinkedEntity.class);
        annotationTypeClasses.put(AnnotationType.RELATION, Relation.class);
        annotationTypeClasses.put(AnnotationType.TOPIC, Topic.class);
        annotationTypeClasses.put(AnnotationType.STATEMENT, Statement.class);
        this.wfId2Terms = new HashMap<String, List<Term>>();
    }

    public static KAFDocument createFromFile(File file) throws IOException {
        KAFDocument kaf = null;
        try {
            kaf = ReadWriteManager.load(file);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        return kaf;
    }

    public static KAFDocument createFromStream(Reader stream) throws IOException, JDOMException {
        KAFDocument kaf = null;
        kaf = ReadWriteManager.load(stream);
        return kaf;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public String getLang() {
        return this.lang;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public LinguisticProcessor addLinguisticProcessor(String layer, String name) {
        LinguisticProcessor lp = new LinguisticProcessor(name, layer);
        List<LinguisticProcessor> layerLps = this.lps.get(layer);
        if (layerLps == null) {
            layerLps = new ArrayList<LinguisticProcessor>();
            this.lps.put(layer, layerLps);
        }
        layerLps.add(lp);
        return lp;
    }

    public void addLinguisticProcessors(Map<String, List<LinguisticProcessor>> lps) {
        for (Map.Entry<String, List<LinguisticProcessor>> entry : lps.entrySet()) {
            List<LinguisticProcessor> layerLps = entry.getValue();
            for (LinguisticProcessor lp : layerLps) {
                LinguisticProcessor newLp = this.addLinguisticProcessor(entry.getKey(), lp.name);
                if (lp.hasTimestamp()) {
                    newLp.setTimestamp(lp.getTimestamp());
                }
                if (lp.hasBeginTimestamp()) {
                    newLp.beginTimestamp = lp.beginTimestamp;
                }
                if (lp.hasEndTimestamp()) {
                    newLp.setEndTimestamp(lp.getEndTimestamp());
                }
                if (!lp.hasVersion()) continue;
                newLp.setVersion(lp.getVersion());
            }
        }
    }

    public Map<String, List<LinguisticProcessor>> getLinguisticProcessors() {
        return this.lps;
    }

    public List<LinguisticProcessor> getLinguisticProcessorList() {
        ArrayList<LinguisticProcessor> result = new ArrayList<LinguisticProcessor>();
        for (List<LinguisticProcessor> lps : this.lps.values()) {
            for (LinguisticProcessor lp : lps) {
                result.add(lp);
            }
        }
        return result;
    }

    public boolean linguisticProcessorExists(String layer, String name, String version) {
        List<LinguisticProcessor> layerLPs = this.lps.get(layer);
        if (layerLPs == null) {
            return false;
        }
        for (LinguisticProcessor lp : layerLPs) {
            if (lp.version == null) {
                return false;
            }
            if (!lp.name.equals(name) || !lp.version.equals(version)) continue;
            return true;
        }
        return false;
    }

    public boolean linguisticProcessorExists(String layer, String name) {
        List<LinguisticProcessor> layerLPs = this.lps.get(layer);
        if (layerLPs == null) {
            return false;
        }
        for (LinguisticProcessor lp : layerLPs) {
            if (lp.version != null) {
                return false;
            }
            if (!lp.name.equals(name)) continue;
            return true;
        }
        return false;
    }

    public FileDesc createFileDesc() {
        this.fileDesc = new FileDesc();
        return this.fileDesc;
    }

    public FileDesc getFileDesc() {
        return this.fileDesc;
    }

    public Public createPublic() {
        this._public = new Public();
        return this._public;
    }

    public Public getPublic() {
        return this._public;
    }

    AnnotationContainer getAnnotationContainer() {
        return this.annotationContainer;
    }

    public void setRawText(String rawText) {
        this.annotationContainer.setRawText(rawText);
    }

    public WF newWF(String id, int offset, int length, String form, int sent) {
        this.idManager.updateCounter(AnnotationType.WF, id);
        WF newWF = new WF(this.annotationContainer, id, offset, length, form, sent);
        this.annotationContainer.add(newWF, Layer.TEXT, AnnotationType.WF);
        return newWF;
    }

    public WF newWF(String id, int offset, String form, int sent) {
        return this.newWF(id, offset, form.length(), form, sent);
    }

    public WF newWF(int offset, Integer length, String form, int sent) {
        String newId = this.idManager.getNextId(AnnotationType.WF);
        WF newWF = new WF(this.annotationContainer, newId, offset, length, form, sent);
        this.annotationContainer.add(newWF, Layer.TEXT, AnnotationType.WF);
        return newWF;
    }

    public WF newWF(int offset, String form, int sent) {
        return this.newWF(offset, (Integer)form.length(), form, sent);
    }

    private void addToWfTermIndex(List<WF> wfs, Term term) {
        for (WF wf : wfs) {
            String id = wf.getId();
            List<Term> terms = this.wfId2Terms.get(id);
            if (terms == null) {
                terms = new ArrayList<Term>();
                this.wfId2Terms.put(id, terms);
            }
            terms.add(term);
        }
    }

    public Term newTerm(String id, Span<WF> span) {
        this.idManager.updateCounter(AnnotationType.TERM, id);
        Term newTerm = new Term(id, span, false);
        this.annotationContainer.add(newTerm, Layer.TERMS, AnnotationType.TERM);
        this.addToWfTermIndex(newTerm.getSpan().getTargets(), newTerm);
        return newTerm;
    }

    public Term newTerm(String id, Span<WF> span, boolean isComponent) {
        this.idManager.updateCounter(AnnotationType.TERM, id);
        Term newTerm = new Term(id, span, isComponent);
        if (!isComponent) {
            this.annotationContainer.add(newTerm, Layer.TERMS, AnnotationType.TERM);
        }
        this.addToWfTermIndex(newTerm.getSpan().getTargets(), newTerm);
        return newTerm;
    }

    public Term newTerm(Span<WF> span, boolean isComponent) {
        String newId = this.idManager.getNextId(AnnotationType.TERM);
        Term newTerm = new Term(newId, span, isComponent);
        if (!isComponent) {
            this.annotationContainer.add(newTerm, Layer.TERMS, AnnotationType.TERM);
        }
        this.addToWfTermIndex(newTerm.getSpan().getTargets(), newTerm);
        return newTerm;
    }

    public Term newTerm(String id, Span<WF> span, Integer position) {
        this.idManager.updateCounter(AnnotationType.TERM, id);
        Term newTerm = new Term(id, span, false);
        this.annotationContainer.add(newTerm, Layer.TERMS, AnnotationType.TERM, position);
        this.addToWfTermIndex(newTerm.getSpan().getTargets(), newTerm);
        return newTerm;
    }

    public Term newTerm(Span<WF> span) {
        String newId = this.idManager.getNextId(AnnotationType.TERM);
        Term newTerm = new Term(newId, span, false);
        this.annotationContainer.add(newTerm, Layer.TERMS, AnnotationType.TERM);
        this.addToWfTermIndex(newTerm.getSpan().getTargets(), newTerm);
        return newTerm;
    }

    public Term newCompound(List<Term> terms, String lemma) {
        Span<WF> span = new Span<WF>();
        for (Term term : terms) {
            span.addTargets(term.getSpan().getTargets());
        }
        String newId = this.idManager.getNextId(AnnotationType.MW);
        Term compound = this.newTerm(newId, span, this.annotationContainer.getPosition(Layer.TERMS, terms.get(0)));
        compound.setLemma(lemma);
        for (Term term : terms) {
            compound.addComponent(term);
            term.setCompound(compound);
            this.annotationContainer.remove(term, Layer.TERMS, AnnotationType.TERM);
        }
        return compound;
    }

    public Term.Sentiment newSentiment() {
        Term.Sentiment newSentiment = new Term.Sentiment();
        return newSentiment;
    }

    public Mark newMark(String id, Span<WF> span) {
        this.idManager.updateCounter(AnnotationType.MARK, id);
        Mark newMark = new Mark(id, span);
        this.annotationContainer.add(newMark, Layer.MARKABLES, AnnotationType.MARK);
        return newMark;
    }

    public Mark newMark(Span<WF> span) {
        String newId = this.idManager.getNextId(AnnotationType.MARK);
        Mark newMark = new Mark(newId, span);
        this.annotationContainer.add(newMark, Layer.MARKABLES, AnnotationType.MARK);
        return newMark;
    }

    public Mark newMark(Span<WF> span, String source) {
        Mark newMark = this.newMark(span);
        newMark.setSource(source);
        return newMark;
    }

    public Mark newMark(String id, String source, Span<WF> span) {
        this.idManager.updateCounter(AnnotationType.MARK, id);
        Mark newMark = new Mark(id, span);
        newMark.setSource(source);
        this.annotationContainer.add(newMark, Layer.MARKABLES, AnnotationType.MARK);
        return newMark;
    }

    public Dep newDep(Term from, Term to, String rfunc) {
        Dep newDep = new Dep(from, to, rfunc);
        this.annotationContainer.add(newDep, Layer.DEPS, AnnotationType.DEP);
        return newDep;
    }

    public Chunk newChunk(String id, String phrase, Span<Term> span) {
        this.idManager.updateCounter(AnnotationType.CHUNK, id);
        Chunk newChunk = new Chunk(id, span);
        newChunk.setPhrase(phrase);
        this.annotationContainer.add(newChunk, Layer.CHUNKS, AnnotationType.CHUNK);
        return newChunk;
    }

    public Chunk newChunk(String phrase, Span<Term> span) {
        String newId = this.idManager.getNextId(AnnotationType.CHUNK);
        Chunk newChunk = new Chunk(newId, span);
        newChunk.setPhrase(phrase);
        this.annotationContainer.add(newChunk, Layer.CHUNKS, AnnotationType.CHUNK);
        return newChunk;
    }

    public Entity newEntity(String id, List<Span<Term>> references) {
        this.idManager.updateCounter(AnnotationType.ENTITY, id);
        Entity newEntity = new Entity(id, references);
        this.annotationContainer.add(newEntity, Layer.ENTITIES, AnnotationType.ENTITY);
        return newEntity;
    }

    public Entity newEntity(List<Span<Term>> references) {
        String newId = this.idManager.getNextId(AnnotationType.ENTITY);
        Entity newEntity = new Entity(newId, references);
        this.annotationContainer.add(newEntity, Layer.ENTITIES, AnnotationType.ENTITY);
        return newEntity;
    }

    public Coref newCoref(String id, List<Span<Term>> mentions) {
        this.idManager.updateCounter(AnnotationType.COREF, id);
        Coref newCoref = new Coref(id, mentions);
        this.annotationContainer.add(newCoref, Layer.COREFERENCES, AnnotationType.COREF);
        return newCoref;
    }

    public Coref newCoref(List<Span<Term>> mentions) {
        String newId = this.idManager.getNextId(AnnotationType.COREF);
        Coref newCoref = new Coref(newId, mentions);
        this.annotationContainer.add(newCoref, Layer.COREFERENCES, AnnotationType.COREF);
        return newCoref;
    }

    public Timex3 newTimex3(String id, String type) {
        this.idManager.updateCounter(AnnotationType.TIMEX3, id);
        Timex3 newTimex3 = new Timex3(id, type);
        this.annotationContainer.add(newTimex3, Layer.TIME_EXPRESSIONS, AnnotationType.TIMEX3);
        return newTimex3;
    }

    public Timex3 newTimex3(String type) {
        String newId = this.idManager.getNextId(AnnotationType.TIMEX3);
        Timex3 newTimex3 = new Timex3(newId, type);
        this.annotationContainer.add(newTimex3, Layer.TIME_EXPRESSIONS, AnnotationType.TIMEX3);
        return newTimex3;
    }

    public TLink newTLink(String id, TLinkReferable from, TLinkReferable to, String relType) {
        this.idManager.updateCounter(AnnotationType.TLINK, id);
        TLink newTLink = new TLink(id, from, to, relType);
        this.annotationContainer.add(newTLink, Layer.TEMPORAL_RELATIONS, AnnotationType.TLINK);
        return newTLink;
    }

    public TLink newTLink(TLinkReferable from, TLinkReferable to, String relType) {
        String newId = this.idManager.getNextId(AnnotationType.TLINK);
        TLink newTLink = new TLink(newId, from, to, relType);
        this.annotationContainer.add(newTLink, Layer.TEMPORAL_RELATIONS, AnnotationType.TLINK);
        return newTLink;
    }

    public PredicateAnchor newPredicateAnchor(Span<Predicate> span) {
        String newId = this.idManager.getNextId(AnnotationType.PREDICATE_ANCHOR);
        PredicateAnchor newPredicateAnchor = new PredicateAnchor(newId, span);
        this.annotationContainer.add(newPredicateAnchor, Layer.TEMPORAL_RELATIONS, AnnotationType.PREDICATE_ANCHOR);
        return newPredicateAnchor;
    }

    public PredicateAnchor newPredicateAnchor(String id, Span<Predicate> span) {
        this.idManager.updateCounter(AnnotationType.PREDICATE_ANCHOR, id);
        PredicateAnchor newPredicateAnchor = new PredicateAnchor(id, span);
        this.annotationContainer.add(newPredicateAnchor, Layer.TEMPORAL_RELATIONS, AnnotationType.PREDICATE_ANCHOR);
        return newPredicateAnchor;
    }

    public PredicateAnchor newPredicateAnchor(Timex3 anchorTime, Timex3 beginPoint, Timex3 endPoint, Span<Predicate> span) {
        PredicateAnchor newPa = this.newPredicateAnchor(span);
        newPa.setAnchorTime(anchorTime);
        newPa.setBeginPoint(beginPoint);
        newPa.setEndPoint(endPoint);
        return newPa;
    }

    public PredicateAnchor newPredicateAnchor(String id, Timex3 anchorTime, Timex3 beginPoint, Timex3 endPoint, Span<Predicate> span) {
        PredicateAnchor newPa = this.newPredicateAnchor(id, span);
        newPa.setAnchorTime(anchorTime);
        newPa.setBeginPoint(beginPoint);
        newPa.setEndPoint(endPoint);
        return newPa;
    }

    public CLink newCLink(String id, Predicate from, Predicate to) {
        this.idManager.updateCounter(AnnotationType.CLINK, id);
        CLink newCLink = new CLink(id, from, to);
        this.annotationContainer.add(newCLink, Layer.CAUSAL_RELATIONS, AnnotationType.CLINK);
        return newCLink;
    }

    public CLink newCLink(Predicate from, Predicate to) {
        String newId = this.idManager.getNextId(AnnotationType.CLINK);
        CLink newCLink = new CLink(newId, from, to);
        this.annotationContainer.add(newCLink, Layer.CAUSAL_RELATIONS, AnnotationType.CLINK);
        return newCLink;
    }

    public Factuality newFactuality(String id, Span<Term> span) {
        this.idManager.updateCounter(AnnotationType.FACTUALITY, id);
        Factuality newFactuality = new Factuality(id, span);
        this.annotationContainer.add(newFactuality, Layer.FACTUALITIES, AnnotationType.FACTUALITY);
        return newFactuality;
    }

    public Factuality newFactuality(Span<Term> span) {
        String newId = this.idManager.getNextId(AnnotationType.FACTUALITY);
        Factuality newFactuality = new Factuality(newId, span);
        this.annotationContainer.add(newFactuality, Layer.FACTUALITIES, AnnotationType.FACTUALITY);
        return newFactuality;
    }

    public Factuality.FactVal newFactVal(String value, String resource) {
        return new Factuality.FactVal(value, resource);
    }

    public Factvalue newFactvalue(WF wf, String prediction) {
        Factvalue factuality = new Factvalue(wf, prediction);
        this.annotationContainer.add(factuality, Layer.FACTUALITY_LAYER, AnnotationType.FACTVALUE);
        return factuality;
    }

    public Feature newProperty(String id, String lemma, List<Span<Term>> references) {
        this.idManager.updateCounter(AnnotationType.PROPERTY, id);
        Feature newProperty = new Feature(id, lemma, references);
        this.annotationContainer.add(newProperty, Layer.PROPERTIES, AnnotationType.PROPERTY);
        return newProperty;
    }

    public Feature newProperty(String lemma, List<Span<Term>> references) {
        String newId = this.idManager.getNextId(AnnotationType.PROPERTY);
        Feature newProperty = new Feature(newId, lemma, references);
        this.annotationContainer.add(newProperty, Layer.PROPERTIES, AnnotationType.PROPERTY);
        return newProperty;
    }

    public Feature newCategory(String id, String lemma, List<Span<Term>> references) {
        this.idManager.updateCounter(AnnotationType.CATEGORY, id);
        Feature newCategory = new Feature(id, lemma, references);
        this.annotationContainer.add(newCategory, Layer.CATEGORIES, AnnotationType.CATEGORY);
        return newCategory;
    }

    public Feature newCategory(String lemma, List<Span<Term>> references) {
        String newId = this.idManager.getNextId(AnnotationType.CATEGORY);
        Feature newCategory = new Feature(newId, lemma, references);
        this.annotationContainer.add(newCategory, Layer.CATEGORIES, AnnotationType.CATEGORY);
        return newCategory;
    }

    public Opinion newOpinion() {
        String newId = this.idManager.getNextId(AnnotationType.OPINION);
        Opinion newOpinion = new Opinion(newId);
        this.annotationContainer.add(newOpinion, Layer.OPINIONS, AnnotationType.OPINION);
        return newOpinion;
    }

    public Opinion newOpinion(String id) {
        this.idManager.updateCounter(AnnotationType.OPINION, id);
        Opinion newOpinion = new Opinion(id);
        this.annotationContainer.add(newOpinion, Layer.OPINIONS, AnnotationType.OPINION);
        return newOpinion;
    }

    public Relation newRelation(Relational from, Relational to) {
        String newId = this.idManager.getNextId(AnnotationType.RELATION);
        Relation newRelation = new Relation(newId, from, to);
        this.annotationContainer.add(newRelation, Layer.RELATIONS, AnnotationType.RELATION);
        return newRelation;
    }

    public Relation newRelation(String id, Relational from, Relational to) {
        this.idManager.updateCounter(AnnotationType.RELATION, id);
        Relation newRelation = new Relation(id, from, to);
        this.annotationContainer.add(newRelation, Layer.RELATIONS, AnnotationType.RELATION);
        return newRelation;
    }

    public Predicate newPredicate(String id, Span<Term> span) {
        this.idManager.updateCounter(AnnotationType.PREDICATE, id);
        Predicate newPredicate = new Predicate(id, span);
        this.annotationContainer.add(newPredicate, Layer.SRL, AnnotationType.PREDICATE);
        return newPredicate;
    }

    public Predicate newPredicate(Span<Term> span) {
        String newId = this.idManager.getNextId(AnnotationType.PREDICATE);
        Predicate newPredicate = new Predicate(newId, span);
        this.annotationContainer.add(newPredicate, Layer.SRL, AnnotationType.PREDICATE);
        return newPredicate;
    }

    public Predicate.Role newRole(String id, Predicate predicate, String semRole, Span<Term> span) {
        this.idManager.updateCounter(AnnotationType.ROLE, id);
        Predicate.Role newRole = new Predicate.Role(id, semRole, span);
        return newRole;
    }

    public Predicate.Role newRole(Predicate predicate, String semRole, Span<Term> span) {
        String newId = this.idManager.getNextId(AnnotationType.ROLE);
        Predicate.Role newRole = new Predicate.Role(newId, semRole, span);
        return newRole;
    }

    public ExternalRef newExternalRef(String resource, String reference) {
        return new ExternalRef(resource, reference);
    }

    public ExternalRef newExternalRef(String resource) {
        return new ExternalRef(resource, null);
    }

    public Tree newConstituent(TreeNode root, String type) {
        Tree tree = new Tree(root, type);
        this.annotationContainer.add(tree, Layer.CONSTITUENCY, AnnotationType.TREE);
        return tree;
    }

    public Tree newConstituent(TreeNode root) {
        return this.newConstituent(root, "kaflib_default_group");
    }

    public void addConstituencyFromParentheses(String parseOut) throws Exception {
        Tree.parenthesesToKaf(parseOut, this);
    }

    public NonTerminal newNonTerminal(String id, String label) {
        NonTerminal tn = new NonTerminal(id, label);
        String newEdgeId = this.idManager.getNextId(AnnotationType.EDGE);
        tn.setEdgeId(newEdgeId);
        return tn;
    }

    public NonTerminal newNonTerminal(String label) {
        String newId = this.idManager.getNextId(AnnotationType.NON_TERMINAL);
        String newEdgeId = this.idManager.getNextId(AnnotationType.EDGE);
        NonTerminal newNonterminal = new NonTerminal(newId, label);
        newNonterminal.setEdgeId(newEdgeId);
        return newNonterminal;
    }

    public Terminal newTerminal(String id, Span<Term> span) {
        Terminal tn = new Terminal(id, span);
        String newEdgeId = this.idManager.getNextId(AnnotationType.EDGE);
        tn.setEdgeId(newEdgeId);
        return tn;
    }

    public Terminal newTerminal(Span<Term> span) {
        String newId = this.idManager.getNextId(AnnotationType.TERMINAL);
        String newEdgeId = this.idManager.getNextId(AnnotationType.EDGE);
        Terminal tn = new Terminal(newId, span);
        tn.setEdgeId(newEdgeId);
        return tn;
    }

    public Topic newTopic(String value) {
        Topic newTopic = new Topic(value);
        this.annotationContainer.add(newTopic, Layer.TOPICS, AnnotationType.TOPIC);
        return newTopic;
    }

    public Statement newStatement(Statement.StatementTarget target) {
        String newId = this.idManager.getNextId(AnnotationType.STATEMENT);
        Statement newStatement = new Statement(newId, target);
        this.annotationContainer.add(newStatement, Layer.ATTRIBUTION, AnnotationType.STATEMENT);
        return newStatement;
    }

    public Statement newStatement(String id, Statement.StatementTarget target) {
        this.idManager.updateCounter(AnnotationType.STATEMENT, id);
        Statement newStatement = new Statement(id, target);
        this.annotationContainer.add(newStatement, Layer.ATTRIBUTION, AnnotationType.STATEMENT);
        return newStatement;
    }

    public Statement.StatementTarget newStatementTarget(Span<Term> span) {
        return new Statement.StatementTarget(span);
    }

    public Statement.StatementSource newStatementSource(Span<Term> span) {
        return new Statement.StatementSource(span);
    }

    public Statement.StatementCue newStatementCue(Span<Term> span) {
        return new Statement.StatementCue(span);
    }

    public static <T extends IdentifiableAnnotation> Span<T> newSpan() {
        return new Span();
    }

    public static <T extends IdentifiableAnnotation> Span<T> newSpan(List<T> targets) {
        return new Span<T>(targets);
    }

    void addUnknownLayer(Element layer) {
        this.annotationContainer.add(layer);
    }

    public List<Annotation> getAnnotations(AnnotationType type) {
        return this.annotationContainer.getAnnotations(type);
    }

    public List<Annotation> getAnnotations(AnnotationType type, String group) {
        return this.annotationContainer.getAnnotations(type, group);
    }

    public List<Annotation> getLayer(Layer layer) {
        return this.annotationContainer.getLayer(layer);
    }

    public List<Annotation> getLayer(Layer layer, String group) {
        return this.annotationContainer.getLayer(layer, group);
    }

    public String getRawText() {
        return this.annotationContainer.getRawText();
    }

    public List<WF> getWFs() {
        return this.getAnnotations(AnnotationType.WF);
    }

    public List<Term> getTerms() {
        return this.getAnnotations(AnnotationType.TERM);
    }

    public List<Entity> getEntities() {
        return this.getAnnotations(AnnotationType.ENTITY);
    }

    public List<Chunk> getChunks() {
        return this.getAnnotations(AnnotationType.CHUNK);
    }

    public List<Dep> getDeps() {
        return this.getAnnotations(AnnotationType.DEP);
    }

    public List<Tree> getConstituents(String type) {
        return this.getAnnotations(AnnotationType.TREE, type);
    }

    public List<Tree> getConstituents() {
        return this.getAnnotations(AnnotationType.TREE, "kaflib_default_group");
    }

    public List<Coref> getCorefs() {
        return this.getAnnotations(AnnotationType.COREF);
    }

    public List<Opinion> getOpinions() {
        return this.getAnnotations(AnnotationType.OPINION);
    }

    public List<CLink> getCLinks() {
        return this.getAnnotations(AnnotationType.CLINK);
    }

    public List<TLink> getTLinks() {
        return this.getAnnotations(AnnotationType.TLINK);
    }

    public List<PredicateAnchor> getPredicateAnchors() {
        return this.getAnnotations(AnnotationType.PREDICATE_ANCHOR);
    }

    public List<Predicate> getPredicates() {
        return this.getAnnotations(AnnotationType.PREDICATE);
    }

    public List<Timex3> getTimeExs() {
        return this.getAnnotations(AnnotationType.TIMEX3);
    }

    public List<Factuality> getFactualities() {
        return this.getAnnotations(AnnotationType.FACTUALITY);
    }

    public List<Factvalue> getFactvalues() {
        return this.getAnnotations(AnnotationType.FACTVALUE);
    }

    public List<Mark> getMarks(String source) {
        return this.getAnnotations(AnnotationType.MARK, source);
    }

    public List<String> getMarkSources() {
        return this.annotationContainer.getGroupIDs(AnnotationType.MARK);
    }

    public List<Feature> getProperties() {
        return this.getAnnotations(AnnotationType.PROPERTY);
    }

    public List<Feature> getCategories() {
        return this.getAnnotations(AnnotationType.CATEGORY);
    }

    public List<LinkedEntity> getLinkedEntities() {
        return this.getAnnotations(AnnotationType.LINKED_ENTITY);
    }

    public List<Relation> getRelations() {
        return this.getAnnotations(AnnotationType.RELATION);
    }

    public List<Topic> getTopics() {
        return this.getAnnotations(AnnotationType.TOPIC);
    }

    public List<Statement> getStatements() {
        return this.getAnnotations(AnnotationType.STATEMENT);
    }

    public Set<Element> getUnknownLayers() {
        return this.annotationContainer.getUnknownLayers();
    }

    public List<List<WF>> getSentences() {
        return this.annotationContainer.getSentences(AnnotationType.WF);
    }

    public Integer getFirstSentence() {
        return this.getWFs().get(0).getSent();
    }

    public Integer getNumSentences() {
        return this.annotationContainer.getNumSentences();
    }

    public List<Integer> getSentsByParagraph(Integer para) {
        return this.annotationContainer.getParaSents(para);
    }

    public Integer getFirstParagraph() {
        return this.getWFs().get(0).getPara();
    }

    public Integer getNumParagraphs() {
        return this.annotationContainer.getNumParagraphs();
    }

    public List<Annotation> getBySent(AnnotationType type, Integer sent) {
        return this.annotationContainer.getSentAnnotations(sent, type);
    }

    public List<Annotation> getBySent(AnnotationType type, String group, Integer sent) {
        return this.annotationContainer.getSentAnnotations(sent, type, group);
    }

    public List<Annotation> getByPara(AnnotationType type, Integer para) {
        return this.annotationContainer.getParaAnnotations(para, type);
    }

    public List<Annotation> getByPara(AnnotationType type, String group, Integer para) {
        return this.annotationContainer.getParaAnnotations(para, type, group);
    }

    public List<WF> getWFsBySent(Integer sent) {
        return this.annotationContainer.getSentAnnotations(sent, AnnotationType.WF);
    }

    public List<WF> getWFsByPara(Integer para) {
        return this.annotationContainer.getSentAnnotations(para, AnnotationType.WF);
    }

    public List<Term> getTermsBySent(Integer sent) {
        return this.annotationContainer.getSentAnnotations(sent, AnnotationType.TERM);
    }

    public List<Term> getTermsByPara(Integer para) {
        return this.annotationContainer.getSentAnnotations(para, AnnotationType.TERM);
    }

    public List<Entity> getEntitiesBySent(Integer sent) {
        return this.annotationContainer.getSentAnnotations(sent, AnnotationType.ENTITY);
    }

    public List<Entity> getEntitiesByPara(Integer para) {
        return this.annotationContainer.getSentAnnotations(para, AnnotationType.ENTITY);
    }

    public List<Chunk> getChunksBySent(Integer sent) {
        return this.annotationContainer.getSentAnnotations(sent, AnnotationType.CHUNK);
    }

    public List<Chunk> getChunksByPara(Integer para) {
        return this.annotationContainer.getSentAnnotations(para, AnnotationType.CHUNK);
    }

    public List<Dep> getDepsBySent(Integer sent) {
        return this.annotationContainer.getSentAnnotations(sent, AnnotationType.DEP);
    }

    public List<Dep> getDepsByPara(Integer para) {
        return this.annotationContainer.getSentAnnotations(para, AnnotationType.DEP);
    }

    public List<Tree> getConstituentsBySent(Integer sent) {
        return this.annotationContainer.getSentAnnotations(sent, AnnotationType.TREE);
    }

    public List<Tree> getConstituentsByPara(Integer para) {
        return this.annotationContainer.getSentAnnotations(para, AnnotationType.TREE);
    }

    public List<Tree> getConstituentsBySent(Integer sent, String treeType) {
        return this.annotationContainer.getSentAnnotations(sent, AnnotationType.TREE);
    }

    public List<Tree> getConstituentsByPara(Integer para, String treeType) {
        return this.annotationContainer.getSentAnnotations(para, AnnotationType.TREE);
    }

    public List<Coref> getCorefsBySent(Integer sent) {
        return this.annotationContainer.getSentAnnotations(sent, AnnotationType.COREF);
    }

    public List<Coref> getCorefsByPara(Integer para) {
        return this.annotationContainer.getSentAnnotations(para, AnnotationType.COREF);
    }

    public List<Opinion> getOpinionsBySent(Integer sent) {
        return this.annotationContainer.getSentAnnotations(sent, AnnotationType.OPINION);
    }

    public List<Opinion> getOpinionsByPara(Integer para) {
        return this.annotationContainer.getSentAnnotations(para, AnnotationType.OPINION);
    }

    public List<CLink> getCLinksBySent(Integer sent) {
        return this.annotationContainer.getSentAnnotations(sent, AnnotationType.CLINK);
    }

    public List<CLink> getCLinksByPara(Integer para) {
        return this.annotationContainer.getSentAnnotations(para, AnnotationType.CLINK);
    }

    public List<TLink> getTLinksBySent(Integer sent) {
        return this.annotationContainer.getSentAnnotations(sent, AnnotationType.TLINK);
    }

    public List<TLink> getTLinksByPara(Integer para) {
        return this.annotationContainer.getSentAnnotations(para, AnnotationType.TLINK);
    }

    public List<PredicateAnchor> getPredicateAnchorsBySent(Integer sent) {
        return this.annotationContainer.getSentAnnotations(sent, AnnotationType.PREDICATE_ANCHOR);
    }

    public List<PredicateAnchor> getPredicateAnchorsByPara(Integer para) {
        return this.annotationContainer.getSentAnnotations(para, AnnotationType.PREDICATE_ANCHOR);
    }

    public List<Predicate> getPredicatesBySent(Integer sent) {
        return this.annotationContainer.getSentAnnotations(sent, AnnotationType.PREDICATE);
    }

    public List<Predicate> getPredicatesByPara(Integer para) {
        return this.annotationContainer.getSentAnnotations(para, AnnotationType.PREDICATE);
    }

    public List<Timex3> getTimeExsBySent(Integer sent) {
        return this.annotationContainer.getSentAnnotations(sent, AnnotationType.TIMEX3);
    }

    public List<Timex3> getTimeExsByPara(Integer para) {
        return this.annotationContainer.getSentAnnotations(para, AnnotationType.TIMEX3);
    }

    public List<Factuality> getFactualitiesBySent(Integer sent) {
        return this.annotationContainer.getSentAnnotations(sent, AnnotationType.FACTUALITY);
    }

    public List<Factuality> getFactualitiesByPara(Integer para) {
        return this.annotationContainer.getSentAnnotations(para, AnnotationType.FACTUALITY);
    }

    public List<Factvalue> getFactvaluesBySent(Integer sent) {
        return this.annotationContainer.getSentAnnotations(sent, AnnotationType.FACTVALUE);
    }

    public List<Factvalue> getFactvaluesByPara(Integer para) {
        return this.annotationContainer.getSentAnnotations(para, AnnotationType.FACTVALUE);
    }

    public List<Mark> getMarksBySent(Integer sent) {
        return this.annotationContainer.getSentAnnotations(sent, AnnotationType.MARK);
    }

    public List<Mark> getMarksByPara(Integer para) {
        return this.annotationContainer.getSentAnnotations(para, AnnotationType.MARK);
    }

    public List<Mark> getMarksBySent(Integer sent, String group) {
        return this.annotationContainer.getSentAnnotations(sent, AnnotationType.MARK);
    }

    public List<Mark> getMarksByPara(Integer para, String group) {
        return this.annotationContainer.getSentAnnotations(para, AnnotationType.MARK);
    }

    public List<Feature> getPropertiesBySent(Integer sent) {
        return this.annotationContainer.getSentAnnotations(sent, AnnotationType.PROPERTY);
    }

    public List<Feature> getPropertiesByPara(Integer para) {
        return this.annotationContainer.getSentAnnotations(para, AnnotationType.PROPERTY);
    }

    public List<Feature> getCategoriesBySent(Integer sent) {
        return this.annotationContainer.getSentAnnotations(sent, AnnotationType.CATEGORY);
    }

    public List<Feature> getCategoriesByPara(Integer para) {
        return this.annotationContainer.getSentAnnotations(para, AnnotationType.CATEGORY);
    }

    public List<LinkedEntity> getLinkedEntitiesBySent(Integer sent) {
        return this.annotationContainer.getSentAnnotations(sent, AnnotationType.LINKED_ENTITY);
    }

    public List<LinkedEntity> getLinkedEntitiesByPara(Integer para) {
        return this.annotationContainer.getSentAnnotations(para, AnnotationType.LINKED_ENTITY);
    }

    public List<Relation> getRelationsBySent(Integer sent) {
        return this.annotationContainer.getSentAnnotations(sent, AnnotationType.RELATION);
    }

    public List<Relation> getRelationsByPara(Integer para) {
        return this.annotationContainer.getSentAnnotations(para, AnnotationType.RELATION);
    }

    public List<Topic> getTopicsBySent(Integer sent) {
        return this.annotationContainer.getSentAnnotations(sent, AnnotationType.TOPIC);
    }

    public List<Topic> getTopicsByPara(Integer para) {
        return this.annotationContainer.getSentAnnotations(para, AnnotationType.TOPIC);
    }

    public List<Statement> getStatementsBySent(Integer sent) {
        return this.annotationContainer.getSentAnnotations(sent, AnnotationType.STATEMENT);
    }

    public List<Statement> getStatementsByPara(Integer para) {
        return this.annotationContainer.getSentAnnotations(para, AnnotationType.STATEMENT);
    }

    public List<Term> getTermsFromWFs(List<String> wfIds) {
        ArrayList<Term> terms = new ArrayList<Term>();
        for (String wfId : wfIds) {
            terms.addAll((Collection<Term>)this.wfId2Terms.get(wfId));
        }
        return terms;
    }

    public List<Dep> getDepsFromTerm(Term term) {
        ArrayList<Dep> result = new ArrayList<Dep>();
        for (Dep dep : this.annotationContainer.getInverse(term, AnnotationType.DEP)) {
            if (dep.getFrom() != term) continue;
            result.add(dep);
        }
        return result;
    }

    public List<KAFDocument> splitInSentences() {
        ArrayList<KAFDocument> sentNafs = new ArrayList<KAFDocument>();
        Integer numParagraphs = this.getNumParagraphs();
        Integer paragraph = 1;
        while (paragraph <= numParagraphs) {
            List<Integer> sentences = this.getSentsByParagraph(paragraph);
            for (Integer sentence : sentences) {
                KAFDocument naf = new KAFDocument(this.getLang(), this.getVersion());
                naf.setRawText(this.getRawText());
                for (AnnotationType type : highLevelAnnotationTypes) {
                    Layer layer = highLevelAnnotationType2Layer.get((Object)type);
                    if (!KAFDocument.isSentenceLevelAnnotationType(type).booleanValue()) continue;
                    List<Object> annotations = new ArrayList();
                    if (KAFDocument.isMultiLayerAnnotationType(type).booleanValue()) {
                        for (String string : this.annotationContainer.getGroupIDs(type)) {
                            annotations.addAll(this.getBySent(type, string, sentence));
                        }
                    } else {
                        annotations = this.getBySent(type, sentence);
                    }
                    for (Annotation annotation : annotations) {
                        naf.addExistingAnnotation(annotation, layer, type);
                    }
                }
                sentNafs.add(naf);
            }
            Integer n = paragraph;
            Integer n2 = paragraph = Integer.valueOf(paragraph + 1);
        }
        return sentNafs;
    }

    public List<KAFDocument> splitInParagraphs() {
        ArrayList<KAFDocument> paraNafs = new ArrayList<KAFDocument>();
        Integer numParagraphs = this.getNumParagraphs();
        Integer paragraph = 1;
        while (paragraph <= numParagraphs) {
            KAFDocument naf = new KAFDocument(this.getLang(), this.getVersion());
            naf.setRawText(this.getRawText());
            for (AnnotationType type : highLevelAnnotationTypes) {
                Layer layer = highLevelAnnotationType2Layer.get((Object)type);
                if (!KAFDocument.isParagraphLevelAnnotationType(type).booleanValue()) continue;
                List<Object> annotations = new ArrayList();
                if (KAFDocument.isMultiLayerAnnotationType(type).booleanValue()) {
                    for (String string : this.annotationContainer.getGroupIDs(type)) {
                        annotations.addAll(this.getByPara(type, string, paragraph));
                    }
                } else {
                    annotations = this.getByPara(type, paragraph);
                }
                for (Annotation annotation : annotations) {
                    naf.addExistingAnnotation(annotation, layer, type);
                }
            }
            paraNafs.add(naf);
            Integer n = paragraph;
            Integer n2 = paragraph = Integer.valueOf(paragraph + 1);
        }
        return paraNafs;
    }

    public static KAFDocument join(List<KAFDocument> nafs) {
        KAFDocument firstNaf = nafs.get(0);
        KAFDocument joinedNaf = new KAFDocument(firstNaf.getLang(), nafs.get(0).getVersion());
        joinedNaf.setRawText(firstNaf.getRawText());
        for (KAFDocument nafPart : nafs) {
            for (AnnotationType type : highLevelAnnotationTypes) {
                Layer layer = highLevelAnnotationType2Layer.get((Object)type);
                List<Object> annotations = new ArrayList();
                if (KAFDocument.isMultiLayerAnnotationType(type).booleanValue()) {
                    for (String string : nafPart.annotationContainer.getGroupIDs(type)) {
                        annotations.addAll(nafPart.getAnnotations(type, string));
                    }
                } else {
                    annotations = nafPart.getAnnotations(type);
                }
                for (Annotation annotation : annotations) {
                    joinedNaf.addExistingAnnotation(annotation, layer, type);
                }
            }
        }
        return joinedNaf;
    }

    public Integer getParagraph() {
        List<WF> wfs = this.getWFs();
        return wfs.size() > 0 ? this.getWFs().get(0).getPara() : null;
    }

    public Integer getSentence() {
        List<WF> wfs = this.getWFs();
        return wfs.size() > 0 ? this.getWFs().get(0).getSent() : null;
    }

    public void addExistingAnnotation(Annotation ann, Layer layer, AnnotationType type) {
        if (KAFDocument.isIdentifiableAnnotationType(type).booleanValue()) {
            String newId = this.idManager.getNextId(type);
            ((IdentifiableAnnotation)ann).setId(newId);
        }
        this.annotationContainer.add(ann, layer, type);
    }

    private static Boolean isMultiLayerAnnotationType(AnnotationType type) {
        Class<?> annotationClass = annotationTypeClasses.get((Object)type);
        if (annotationClass == null) {
            return false;
        }
        return MultiLayerAnnotation.class.isAssignableFrom(annotationClass);
    }

    private static Boolean isSentenceLevelAnnotationType(AnnotationType type) {
        Class<?> annotationClass = annotationTypeClasses.get((Object)type);
        if (annotationClass == null) {
            return false;
        }
        return SentenceLevelAnnotation.class.isAssignableFrom(annotationClass);
    }

    private static Boolean isParagraphLevelAnnotationType(AnnotationType type) {
        Class<?> annotationClass = annotationTypeClasses.get((Object)type);
        if (annotationClass == null) {
            return false;
        }
        return ParagraphLevelAnnotation.class.isAssignableFrom(annotationClass);
    }

    private static Boolean isIdentifiableAnnotationType(AnnotationType type) {
        Class<?> annotationClass = annotationTypeClasses.get((Object)type);
        if (annotationClass == null) {
            return false;
        }
        return IdentifiableAnnotation.class.isAssignableFrom(annotationClass);
    }

    public String createTimestamp() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        String formattedDate = sdf.format(date);
        return formattedDate;
    }

    public void save(String filename) {
        ReadWriteManager.save(this, filename);
    }

    public String toString() {
        return ReadWriteManager.kafToStr(this);
    }

    public void print() {
        ReadWriteManager.print(this);
    }

    public LinguisticProcessor addLinguisticProcessor(String layer, String name, String version) {
        LinguisticProcessor lp = this.addLinguisticProcessor(layer, name);
        lp.setVersion(version);
        return lp;
    }

    public LinguisticProcessor addLinguisticProcessor(String layer, String name, String timestamp, String version) {
        LinguisticProcessor lp = this.addLinguisticProcessor(layer, name);
        lp.setTimestamp(timestamp);
        lp.setVersion(version);
        return lp;
    }

    public Term newTerm(String id, String type, String lemma, String pos, Span<WF> span) {
        Term term = this.newTerm(id, span);
        term.setType(type);
        term.setLemma(lemma);
        term.setPos(pos);
        return term;
    }

    public Term newTerm(String type, String lemma, String pos, Span<WF> span) {
        Term term = this.newTerm(span);
        term.setType(type);
        term.setLemma(lemma);
        term.setPos(pos);
        return term;
    }

    public Term newTermOptions(String type, String lemma, String pos, String morphofeat, Span<WF> span) {
        Term newTerm = this.newTermOptions(morphofeat, span);
        newTerm.setType(type);
        newTerm.setLemma(lemma);
        newTerm.setPos(pos);
        return newTerm;
    }

    public Term createTerm(String id, String type, String lemma, String pos, List<WF> wfs) {
        return this.newTerm(id, type, lemma, pos, KAFDocument.list2Span(wfs));
    }

    public Term createTerm(String type, String lemma, String pos, List<WF> wfs) {
        return this.newTerm(type, lemma, pos, KAFDocument.list2Span(wfs));
    }

    public Term createTermOptions(String type, String lemma, String pos, String morphofeat, List<WF> wfs) {
        return this.newTermOptions(type, lemma, pos, morphofeat, KAFDocument.list2Span(wfs));
    }

    public Term newTermOptions(String morphofeat, Span<WF> span) {
        String newId = this.idManager.getNextId(AnnotationType.TERM);
        Term newTerm = new Term(newId, span, false);
        newTerm.setMorphofeat(morphofeat);
        this.annotationContainer.add(newTerm, Layer.TERMS, AnnotationType.TERM);
        return newTerm;
    }

    public Term.Sentiment createSentiment() {
        return this.newSentiment();
    }

    public Dep createDep(Term from, Term to, String rfunc) {
        return this.createDep(from, to, rfunc);
    }

    public Chunk createChunk(String id, Term head, String phrase, List<Term> terms) {
        return this.newChunk(id, phrase, KAFDocument.list2Span(terms, head));
    }

    public Chunk createChunk(Term head, String phrase, List<Term> terms) {
        return this.newChunk(phrase, KAFDocument.list2Span(terms, head));
    }

    public Entity createEntity(String id, String type, List<List<Term>> references) {
        ArrayList<Span<Term>> spanReferences = new ArrayList<Span<Term>>();
        for (List<Term> list : references) {
            spanReferences.add(KAFDocument.list2Span(list));
        }
        Entity entity = this.newEntity(id, spanReferences);
        entity.setType(type);
        return entity;
    }

    public Entity createEntity(String type, List<List<Term>> references) {
        ArrayList<Span<Term>> spanReferences = new ArrayList<Span<Term>>();
        for (List<Term> list : references) {
            spanReferences.add(KAFDocument.list2Span(list));
        }
        Entity entity = this.newEntity(spanReferences);
        entity.setType(type);
        return entity;
    }

    public Coref createCoref(String id, List<List<Target>> references) {
        ArrayList<Span<Term>> spanReferences = new ArrayList<Span<Term>>();
        for (List<Target> list : references) {
            spanReferences.add(KAFDocument.targetList2Span(list));
        }
        return this.newCoref(id, spanReferences);
    }

    public Coref createCoref(List<List<Target>> references) {
        ArrayList<Span<Term>> spanReferences = new ArrayList<Span<Term>>();
        for (List<Target> list : references) {
            spanReferences.add(KAFDocument.targetList2Span(list));
        }
        return this.newCoref(spanReferences);
    }

    public Opinion createOpinion() {
        return this.newOpinion();
    }

    public Opinion createOpinion(String id) {
        return this.newOpinion(id);
    }

    public ExternalRef createExternalRef(String resource, String reference) {
        return this.newExternalRef(resource, reference);
    }

    public static Target createTarget(Term term) {
        return new Target(term, false);
    }

    public static Target createTarget(Term term, boolean isHead) {
        return new Target(term, isHead);
    }

    public static Span<WF> newWFSpan() {
        return new Span<WF>();
    }

    public static Span<WF> newWFSpan(List<WF> targets) {
        return new Span<WF>(targets);
    }

    public static Span<WF> newWFSpan(List<WF> targets, WF head) {
        return new Span<WF>(targets, head);
    }

    public static Span<Term> newTermSpan() {
        return new Span<Term>();
    }

    public static Span<Term> newTermSpan(List<Term> targets) {
        return new Span<Term>(targets);
    }

    public static Span<Term> newTermSpan(List<Term> targets, Term head) {
        return new Span<Term>(targets, head);
    }

    public void removeLayer(Layer layer) {
        this.annotationContainer.removeLayer(layer);
    }

    static <T extends IdentifiableAnnotation> Span<T> list2Span(List<T> list) {
        Span<IdentifiableAnnotation> span = new Span<IdentifiableAnnotation>();
        for (IdentifiableAnnotation elem : list) {
            span.addTarget(elem);
        }
        return span;
    }

    static <T extends IdentifiableAnnotation> Span<T> list2Span(List<T> list, T head) {
        Span<IdentifiableAnnotation> span = new Span<IdentifiableAnnotation>();
        for (IdentifiableAnnotation elem : list) {
            if (head == elem) {
                span.addTarget(elem, true);
                continue;
            }
            span.addTarget(elem);
        }
        return span;
    }

    static Span<Term> targetList2Span(List<Target> list) {
        Span<Term> span = new Span<Term>();
        for (Target target : list) {
            if (target.isHead()) {
                span.addTarget(target.getTerm(), true);
                continue;
            }
            span.addTarget(target.getTerm());
        }
        return span;
    }

    static List<Target> span2TargetList(Span<Term> span) {
        ArrayList<Target> list = new ArrayList<Target>();
        for (Term t : span.getTargets()) {
            list.add(KAFDocument.createTarget(t, t == span.getHead()));
        }
        return list;
    }

    public Term termNth(Integer index) {
        return this.getTerms().get(index);
    }

    public List<Entity> getEntitiesByTerm(Term term) {
        return this.annotationContainer.getInverse(term, AnnotationType.ENTITY);
    }

    public List<Predicate> getPredicatesByTerm(Term term) {
        return this.annotationContainer.getInverse(term, AnnotationType.PREDICATE);
    }

    public List<Term> getSentenceTerms(int sent) {
        return this.annotationContainer.getSentAnnotations(sent, AnnotationType.TERM);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KAFDocument)) {
            return false;
        }
        KAFDocument naf = (KAFDocument)o;
        if (!this.getLang().equals(naf.getLang()) || !this.getVersion().equals(naf.getVersion())) {
            return false;
        }
        if (!this.headerEquals(naf).booleanValue()) {
            return false;
        }
        return Utils.areEquals(this.annotationContainer, naf.annotationContainer);
    }

    private Boolean headerEquals(KAFDocument naf) {
        return Utils.areEquals(this.fileDesc, naf.fileDesc) && Utils.areEquals(this._public, naf._public) && Utils.areEquals(this.lps, naf.lps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static char getDepPathChar(String label) {
        String key = label.toLowerCase();
        Map<String, Character> map = DEP_PATH_CHARS;
        synchronized (map) {
            Character letter = DEP_PATH_CHARS.get(key);
            if (letter == null) {
                letter = Character.valueOf('a');
                for (Character ch : DEP_PATH_CHARS.values()) {
                    if (ch.charValue() < letter.charValue()) continue;
                    letter = Character.valueOf((char)(ch.charValue() + '\u0001'));
                }
                DEP_PATH_CHARS.put(key, letter);
            }
            return letter.charValue();
        }
    }

    private static String getDepPathString(Term from, Iterable<Dep> path) {
        StringBuilder builder = new StringBuilder("_");
        Term term = from;
        for (Dep dep : path) {
            char prefix;
            if (dep.getFrom() == term) {
                prefix = '+';
                term = dep.getTo();
            } else {
                prefix = '-';
                term = dep.getFrom();
            }
            for (String label : dep.getRfunc().split("-")) {
                Character letter = Character.valueOf(KAFDocument.getDepPathChar(label));
                builder.append(prefix).append(letter);
            }
            builder.append("_");
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pattern getDepPathRegex(String pattern) {
        Map<String, Pattern> map = DEP_PATH_REGEXS;
        synchronized (map) {
            Pattern regex = DEP_PATH_REGEXS.get(pattern);
            if (regex == null) {
                StringBuilder builder = new StringBuilder();
                builder.append('_');
                int start = -1;
                for (int i = 0; i < pattern.length(); ++i) {
                    char ch = pattern.charAt(i);
                    if (Character.isLetter(ch) || ch == '-') {
                        if (start >= 0) continue;
                        start = i;
                        continue;
                    }
                    if (start >= 0) {
                        boolean inverse = pattern.charAt(start) == '-';
                        String label = pattern.substring(inverse ? start + 1 : start, i);
                        char letter = KAFDocument.getDepPathChar(label);
                        builder.append("([^_]*").append(Pattern.quote((inverse ? "-" : "+") + letter)).append("[^_]*_)");
                        start = -1;
                    }
                    if (Character.isWhitespace(ch)) continue;
                    builder.append(ch);
                }
                regex = Pattern.compile(builder.toString());
                DEP_PATH_REGEXS.put(pattern, regex);
            }
            return regex;
        }
    }

    public boolean matchDepPath(Term from, Iterable<Dep> path, String pattern) {
        String pathString = KAFDocument.getDepPathString(from, path);
        Pattern pathRegex = KAFDocument.getDepPathRegex(pattern);
        return pathRegex.matcher(pathString).matches();
    }

    public List<Dep> getDepPath(Term from, Term to) {
        if (from == to) {
            return Collections.emptyList();
        }
        ArrayList<Dep> toPath = new ArrayList<Dep>();
        Dep dep = this.getDepToTerm(to);
        while (dep != null) {
            toPath.add(dep);
            if (dep.getFrom() == from) {
                Collections.reverse(toPath);
                return toPath;
            }
            dep = this.getDepToTerm(dep.getFrom());
        }
        ArrayList<Dep> fromPath = new ArrayList<Dep>();
        Dep dep2 = this.getDepToTerm(from);
        while (dep2 != null) {
            fromPath.add(dep2);
            if (dep2.getFrom() == to) {
                return fromPath;
            }
            for (int i = 0; i < toPath.size(); ++i) {
                if (dep2.getFrom() != ((Dep)toPath.get(i)).getFrom()) continue;
                for (int j = i; j >= 0; --j) {
                    fromPath.add((Dep)toPath.get(j));
                }
                return fromPath;
            }
            dep2 = this.getDepToTerm(dep2.getFrom());
        }
        return null;
    }

    public Dep getDepToTerm(Term term) {
        for (Dep dep : this.getDepsByTerm(term)) {
            if (dep.getTo() != term) continue;
            return dep;
        }
        return null;
    }

    public List<Dep> getDepsByTerm(Term term) {
        return this.annotationContainer.getInverse(term, AnnotationType.DEP);
    }

    public Term getTermsHead(Iterable<Term> descendents) {
        HashSet<Term> termSet = new HashSet<Term>();
        for (Term term : descendents) {
            termSet.add(term);
        }
        Term root = null;
        for (Term term : termSet) {
            Dep dep = this.getDepToTerm(term);
            if (dep != null && termSet.contains(dep.getFrom())) continue;
            if (root == null) {
                root = term;
                continue;
            }
            if (root == term) continue;
            return null;
        }
        return root;
    }

    public Set<Term> getTermsByDepAncestors(Iterable<Term> ancestors) {
        HashSet<Term> terms = new HashSet<Term>();
        LinkedList<Term> queue = new LinkedList<Term>();
        for (Term term : ancestors) {
            terms.add(term);
            queue.add(term);
        }
        while (!queue.isEmpty()) {
            Term term = (Term)queue.remove(0);
            List<Dep> deps = this.getDepsByTerm(term);
            for (Dep dep : deps) {
                if (dep.getFrom() != term || !terms.add(dep.getTo())) continue;
                queue.add(dep.getTo());
            }
        }
        return terms;
    }

    public Set<Term> getTermsByDepAncestors(Iterable<Term> ancestors, String pattern) {
        HashSet<Term> result = new HashSet<Term>();
        for (Term term : ancestors) {
            for (Term descendent : this.getTermsByDepAncestors(Collections.singleton(term))) {
                List<Dep> path = this.getDepPath(term, descendent);
                if (!this.matchDepPath(term, path, pattern)) continue;
                result.add(descendent);
            }
        }
        return result;
    }

    static {
        DEP_PATH_CHARS = new HashMap<String, Character>();
        DEP_PATH_REGEXS = new HashMap<String, Pattern>();
    }

    static class Utils {
        Utils() {
        }

        static boolean areEquals(Object a, Object b) {
            return a == null ? b == null : a.equals(b);
        }
    }

    public class LinguisticProcessor
    implements Serializable {
        String layer;
        String name;
        String timestamp;
        String beginTimestamp;
        String endTimestamp;
        String version;
        String hostname;
        private static final long serialVersionUID = 42L;

        private LinguisticProcessor(String name, String layer) {
            this.layer = layer;
            this.name = name;
        }

        private LinguisticProcessor(String name, String timestamp, String version) {
            this.name = name;
            this.timestamp = timestamp;
            this.version = version;
        }

        public String getLayer() {
            return this.layer;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean hasTimestamp() {
            return this.timestamp != null;
        }

        public void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        public void setTimestamp() {
            String timestamp;
            this.timestamp = timestamp = KAFDocument.this.createTimestamp();
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public boolean hasBeginTimestamp() {
            return this.beginTimestamp != null;
        }

        public void setBeginTimestamp(String timestamp) {
            this.beginTimestamp = timestamp;
            if (!this.hasHostname().booleanValue()) {
                try {
                    this.setHostname(InetAddress.getLocalHost().getHostName());
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        }

        public void setBeginTimestamp() {
            String timestamp = KAFDocument.this.createTimestamp();
            this.setBeginTimestamp(timestamp);
        }

        public String getBeginTimestamp() {
            return this.beginTimestamp;
        }

        public boolean hasEndTimestamp() {
            return this.endTimestamp != null;
        }

        public void setEndTimestamp(String timestamp) {
            this.endTimestamp = timestamp;
        }

        public void setEndTimestamp() {
            String timestamp;
            this.endTimestamp = timestamp = KAFDocument.this.createTimestamp();
        }

        public String getEndTimestamp() {
            return this.endTimestamp;
        }

        public boolean hasVersion() {
            return this.version != null;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }

        public Boolean hasHostname() {
            return this.hostname != null;
        }

        public String getHostname() {
            return this.hostname;
        }

        public void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LinguisticProcessor)) {
                return false;
            }
            LinguisticProcessor lp = (LinguisticProcessor)o;
            return Utils.areEquals(this.layer, lp.layer) && Utils.areEquals(this.name, lp.name) && Utils.areEquals(this.version, lp.version);
        }
    }

    public class Public
    implements Serializable {
        public String publicId;
        public String uri;
        private static final long serialVersionUID = 42L;

        private Public() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Public)) {
                return false;
            }
            Public pub = (Public)o;
            return Utils.areEquals(this.publicId, pub.publicId) && Utils.areEquals(this.uri, pub.uri);
        }
    }

    public class FileDesc
    implements Serializable {
        public String author;
        public String title;
        public String publisher;
        public String section;
        public String location;
        public String magazine;
        public String filename;
        public String filetype;
        public Integer pages;
        public String creationtime;
        private static final long serialVersionUID = 42L;

        private FileDesc() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FileDesc)) {
                return false;
            }
            FileDesc fd = (FileDesc)o;
            return Utils.areEquals(this.author, fd.author) && Utils.areEquals(this.title, fd.title) && Utils.areEquals(this.publisher, fd.publisher) && Utils.areEquals(this.section, fd.section) && Utils.areEquals(this.location, fd.location) && Utils.areEquals(this.magazine, fd.magazine) && Utils.areEquals(this.filename, fd.filename) && Utils.areEquals(this.filetype, fd.filetype) && Utils.areEquals(this.pages, fd.pages) && Utils.areEquals(this.creationtime, fd.creationtime);
        }
    }

    public static enum AnnotationType {
        WF,
        TERM,
        MW,
        COMPONENT,
        SENTIMENT,
        ENTITY,
        CHUNK,
        DEP,
        TREE,
        NON_TERMINAL,
        TERMINAL,
        EDGE,
        COREF,
        OPINION,
        OPINION_HOLDER,
        OPINION_TARGET,
        OPINION_EXPRESSION,
        CLINK,
        TLINK,
        PREDICATE_ANCHOR,
        PREDICATE,
        ROLE,
        TIMEX3,
        FACTUALITY,
        FACTVALUE,
        MARK,
        PROPERTY,
        CATEGORY,
        LINKED_ENTITY,
        RELATION,
        TOPIC,
        STATEMENT,
        STATEMENT_TARGET,
        STATEMENT_SOURCE,
        STATEMENT_CUE;

    }

    public static enum Layer {
        TEXT,
        TERMS,
        ENTITIES,
        CHUNKS,
        DEPS,
        CONSTITUENCY,
        COREFERENCES,
        OPINIONS,
        CAUSAL_RELATIONS,
        TEMPORAL_RELATIONS,
        SRL,
        TIME_EXPRESSIONS,
        FACTUALITIES,
        FACTUALITY_LAYER,
        MARKABLES,
        PROPERTIES,
        CATEGORIES,
        RELATIONS,
        LINKED_ENTITIES,
        TOPICS,
        ATTRIBUTION;

    }
}

