/*
 * Decompiled with CFR 0.152.
 */
package ixa.kaflib;

import ixa.kaflib.Annotation;
import ixa.kaflib.IdentifiableAnnotation;
import ixa.kaflib.KAFDocument;
import ixa.kaflib.Predicate;
import ixa.kaflib.TLinkReferable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TLink
extends IdentifiableAnnotation {
    private TLinkReferable from;
    private TLinkReferable to;
    private String relType;

    TLink(String id, TLinkReferable from, TLinkReferable to, String relType) {
        super(id);
        this.from = from;
        this.to = to;
        this.relType = relType;
    }

    public TLinkReferable getFrom() {
        return this.from;
    }

    public void setFrom(TLinkReferable from) {
        this.from = from;
    }

    public TLinkReferable getTo() {
        return this.to;
    }

    public void setTo(TLinkReferable to) {
        this.to = to;
    }

    public String getFromType() {
        return this.from instanceof Predicate ? "event" : "timex";
    }

    public String getToType() {
        return this.to instanceof Predicate ? "event" : "timex";
    }

    public String getRelType() {
        return this.relType;
    }

    public void setRelType(String relType) {
        this.relType = relType;
    }

    @Override
    Map<KAFDocument.AnnotationType, List<Annotation>> getReferencedAnnotations() {
        HashMap<KAFDocument.AnnotationType, List<Annotation>> referenced = new HashMap<KAFDocument.AnnotationType, List<Annotation>>();
        ArrayList<Annotation> predicates = new ArrayList<Annotation>();
        ArrayList<Annotation> timexes = new ArrayList<Annotation>();
        if (this.from instanceof Predicate) {
            predicates.add((Annotation)((Object)this.from));
        } else {
            timexes.add((Annotation)((Object)this.from));
        }
        if (this.to instanceof Predicate) {
            predicates.add((Annotation)((Object)this.to));
        } else {
            timexes.add((Annotation)((Object)this.to));
        }
        referenced.put(KAFDocument.AnnotationType.PREDICATE, predicates);
        referenced.put(KAFDocument.AnnotationType.TIMEX3, timexes);
        return referenced;
    }
}

