/*
 * Decompiled with CFR 0.152.
 */
package eus.ixa.ixa.pipe.tok;

import eus.ixa.ixa.pipe.tok.Annotate;
import eus.ixa.ixa.pipe.tok.CLI;
import ixa.kaflib.KAFDocument;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import org.jdom2.JDOMException;

public class RuleBasedTokenizerServer {
    private final String version = CLI.class.getPackage().getImplementationVersion();
    private final String commit = CLI.class.getPackage().getSpecificationVersion();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuleBasedTokenizerServer(Properties properties) {
        Integer port = Integer.parseInt(properties.getProperty("port"));
        ServerSocket socketServer = null;
        BufferedReader inFromClient = null;
        BufferedWriter outToClient = null;
        try {
            try {
                System.out.println("-> Trying to listen port... " + port);
                socketServer = new ServerSocket(port);
                System.out.println("-> Connected and listening to port " + port);
                while (true) {
                    String result;
                    Socket activeSocket;
                    try {
                        activeSocket = socketServer.accept();
                        inFromClient = new BufferedReader(new InputStreamReader(activeSocket.getInputStream(), "UTF-8"));
                        outToClient = new BufferedWriter(new OutputStreamWriter(activeSocket.getOutputStream(), "UTF-8"));
                        String stringFromClient = this.getClientData(inFromClient);
                        result = this.getAnnotations(properties, stringFromClient);
                    }
                    catch (JDOMException e) {
                        result = "\n-> ERROR: Badly formatted NAF document!!\n";
                        this.sendDataToClient(outToClient, result);
                        continue;
                    }
                    catch (UnsupportedEncodingException e) {
                        result = "\n-> ERROR: Encoding not valid UTF-8!!\n";
                        this.sendDataToClient(outToClient, result);
                        continue;
                    }
                    catch (IOException e) {
                        result = "\n -> ERROR: Input data not correct!!\n";
                        this.sendDataToClient(outToClient, result);
                        continue;
                    }
                    this.sendDataToClient(outToClient, result);
                    inFromClient.close();
                    activeSocket.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.err.println("-> IOException due to failing to create the TCP socket or to wrongly provided model path.");
                System.out.println("closing tcp socket...");
                try {
                    socketServer.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            System.out.println("closing tcp socket...");
            try {
                socketServer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            throw throwable;
        }
    }

    private String getClientData(BufferedReader inFromClient) {
        StringBuilder stringFromClient = new StringBuilder();
        try {
            String line;
            while ((line = inFromClient.readLine()) != null && !line.matches("<ENDOFDOCUMENT>")) {
                stringFromClient.append(line).append("\n");
                if (!line.matches("</NAF>")) continue;
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stringFromClient.toString();
    }

    private void sendDataToClient(BufferedWriter outToClient, String kafToString) throws IOException {
        outToClient.write(kafToString);
        outToClient.close();
    }

    private String getAnnotations(Properties properties, String stringFromClient) throws IOException, JDOMException {
        String kafString = null;
        String lang = properties.getProperty("language");
        String outputFormat = properties.getProperty("outputFormat");
        Boolean inputKafRaw = Boolean.valueOf(properties.getProperty("inputkaf"));
        Boolean noTok = Boolean.valueOf(properties.getProperty("notok"));
        String kafVersion = properties.getProperty("kafversion");
        Boolean offsets = Boolean.valueOf(properties.getProperty("offsets"));
        if (noTok.booleanValue()) {
            BufferedReader noTokReader = new BufferedReader(new StringReader(stringFromClient));
            KAFDocument kaf = new KAFDocument(lang, kafVersion);
            KAFDocument.LinguisticProcessor newLp = kaf.addLinguisticProcessor("text", "ixa-pipe-tok-notok-" + lang, this.version + "-" + this.commit);
            newLp.setBeginTimestamp();
            Annotate.tokensToKAF(noTokReader, kaf);
            newLp.setEndTimestamp();
            kafString = kaf.toString();
            noTokReader.close();
        } else {
            BufferedReader breader;
            KAFDocument kaf;
            if (inputKafRaw.booleanValue()) {
                BufferedReader kafReader = new BufferedReader(new StringReader(stringFromClient));
                kaf = KAFDocument.createFromStream(kafReader);
                String text = kaf.getRawText();
                StringReader stringReader = new StringReader(text);
                breader = new BufferedReader(stringReader);
            } else {
                kaf = new KAFDocument(lang, kafVersion);
                breader = new BufferedReader(new StringReader(stringFromClient));
            }
            Annotate annotator = new Annotate(breader, properties);
            if (outputFormat.equalsIgnoreCase("conll")) {
                kafString = offsets.booleanValue() ? annotator.tokenizeToCoNLL() : annotator.tokenizeToCoNLLOffsets();
            } else if (outputFormat.equalsIgnoreCase("oneline")) {
                kafString = annotator.tokenizeToText();
            } else {
                KAFDocument.LinguisticProcessor newLp = kaf.addLinguisticProcessor("text", "ixa-pipe-tok-" + lang, this.version + "-" + this.commit);
                newLp.setBeginTimestamp();
                annotator.tokenizeToKAF(kaf);
                newLp.setEndTimestamp();
                kafString = kaf.toString();
            }
            breader.close();
        }
        return kafString;
    }
}

