/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.impl.choice;

import java.util.Locale;
import net.sourceforge.argparse4j.inf.ArgumentChoice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeArgumentChoice<T extends Comparable<T>>
implements ArgumentChoice {
    private T min_;
    private T max_;

    public RangeArgumentChoice(T min, T max) {
        this.min_ = min;
        this.max_ = max;
    }

    @Override
    public boolean contains(Object val) {
        if (this.min_.getClass().equals(val.getClass())) {
            Comparable v = (Comparable)val;
            return this.min_.compareTo((Comparable)v) <= 0 && 0 <= this.max_.compareTo((Comparable)v);
        }
        throw new IllegalArgumentException(String.format((Locale)null, "type mismatch (Make sure that you specified corrent Argument.type()): expected: %s actual: %s", this.min_.getClass().getName(), val.getClass().getName()));
    }

    @Override
    public String textualFormat() {
        return String.format((Locale)null, "{%s..%s}", this.min_, this.max_);
    }

    public String toString() {
        return this.textualFormat();
    }
}

