/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.event.command;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import java.util.Iterator;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.commons.collections.StaticBucketMap;
import org.apache.excalibur.event.EventHandler;
import org.apache.excalibur.event.Source;
import org.apache.excalibur.event.command.EventPipeline;
import org.apache.excalibur.event.command.ThreadManager;

public abstract class AbstractThreadManager
extends AbstractLogEnabled
implements Runnable,
ThreadManager,
Initializable,
Disposable {
    private final StaticBucketMap m_pipelines = new StaticBucketMap();
    private Executor m_executor;
    private volatile boolean m_done = false;
    private long m_sleepTime = 1000L;
    private volatile boolean m_initialized = false;

    protected boolean isInitialized() {
        return this.m_initialized;
    }

    protected void setSleepTime(long sleepTime) {
        this.m_sleepTime = sleepTime;
    }

    protected long getSleepTime() {
        return this.m_sleepTime;
    }

    protected void setExecutor(Executor executor) {
        if (null != this.m_executor) {
            throw new IllegalStateException("Can only set the executor once");
        }
        this.m_executor = executor;
    }

    public void initialize() throws Exception {
        if (null == this.m_executor) {
            throw new IllegalStateException("No thread pool set");
        }
        this.m_executor.execute((Runnable)this);
        this.m_initialized = true;
    }

    public void register(EventPipeline pipeline) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("ThreadManager must be initialized before registering a pipeline");
        }
        try {
            PipelineRunner runner = new PipelineRunner(pipeline);
            runner.enableLogging(this.getLogger());
            this.m_pipelines.put((Object)pipeline, (Object)runner);
            if (this.m_done) {
                this.m_executor.execute((Runnable)this);
            }
        }
        catch (InterruptedException ie) {
            this.getLogger().warn("Caught InterruptedException in register", (Throwable)ie);
        }
    }

    public void deregister(EventPipeline pipeline) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("ThreadManager must be initialized before deregistering a pipeline");
        }
        this.m_pipelines.remove((Object)pipeline);
        if (this.m_pipelines.isEmpty()) {
            this.m_done = true;
        }
    }

    public void deregisterAll() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("ThreadManager must be initialized before deregistering pipelines");
        }
        Iterator it = this.m_pipelines.keySet().iterator();
        while (it.hasNext()) {
            this.deregister((EventPipeline)it.next());
        }
        this.m_done = true;
        if (!this.m_pipelines.isEmpty()) {
            throw new IllegalStateException("We still have pipelines, but no runners are available!");
        }
    }

    public void dispose() {
        this.m_done = true;
        this.deregisterAll();
        this.doDispose();
    }

    protected void doDispose() {
    }

    public void run() {
        while (!this.m_done) {
            Iterator i = this.m_pipelines.values().iterator();
            while (i.hasNext()) {
                PipelineRunner nextRunner = (PipelineRunner)i.next();
                try {
                    this.m_executor.execute((Runnable)nextRunner);
                }
                catch (Exception e) {
                    if (!this.getLogger().isErrorEnabled()) continue;
                    this.getLogger().error("Caught exception in ThreadManager management thread", (Throwable)e);
                }
            }
            if (this.m_done) continue;
            try {
                Thread.sleep(this.m_sleepTime);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
    }

    public static final class PipelineRunner
    extends AbstractLogEnabled
    implements Runnable {
        private final EventPipeline m_pipeline;

        protected PipelineRunner(EventPipeline pipeline) {
            this.m_pipeline = pipeline;
        }

        public void run() {
            Source[] sources = this.m_pipeline.getSources();
            EventHandler handler = this.m_pipeline.getEventHandler();
            for (int i = 0; i < sources.length; ++i) {
                try {
                    handler.handleEvents(sources[i].dequeueAll());
                    continue;
                }
                catch (Exception e) {
                    if (!this.getLogger().isErrorEnabled()) continue;
                    this.getLogger().error("Exception processing EventPipeline [msg: " + e.getMessage() + "]", (Throwable)e);
                }
            }
        }
    }
}

