/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.event.command;

import EDU.oswego.cs.dl.util.concurrent.ReentrantLock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.logger.NullLogger;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.UnboundedFifoBuffer;
import org.apache.excalibur.event.EnqueuePredicate;
import org.apache.excalibur.event.EventHandler;
import org.apache.excalibur.event.Queue;
import org.apache.excalibur.event.Signal;
import org.apache.excalibur.event.Sink;
import org.apache.excalibur.event.Source;
import org.apache.excalibur.event.command.Command;
import org.apache.excalibur.event.command.CommandFailureHandler;
import org.apache.excalibur.event.command.DelayedCommand;
import org.apache.excalibur.event.command.EventPipeline;
import org.apache.excalibur.event.command.NullCommandFailureHandler;
import org.apache.excalibur.event.command.RepeatedCommand;
import org.apache.excalibur.event.impl.DefaultQueue;

public class CommandManager
extends AbstractLogEnabled
implements EventPipeline,
Disposable,
EnqueuePredicate {
    private final Queue m_queue = new DefaultQueue();
    private final HashMap m_signalHandlers = new HashMap();
    private final ReentrantLock m_mutex = new ReentrantLock();
    private final EventHandler m_eventHandler = new CommandEventHandler(Collections.unmodifiableMap(this.m_signalHandlers));
    private final Source[] m_sources = new Source[]{this.m_queue};
    private CommandFailureHandler m_failureHandler = NullCommandFailureHandler.SHARED_INSTANCE;
    private boolean m_isAccepting;

    public CommandManager() {
        this.m_queue.setEnqueuePredicate((EnqueuePredicate)this);
        this.m_isAccepting = true;
        this.enableLogging((Logger)new NullLogger());
    }

    public void setCommandFailureHandler(CommandFailureHandler handler) {
        if (null == handler) {
            throw new NullPointerException("handler");
        }
        this.m_failureHandler = handler;
    }

    protected CommandFailureHandler getCommandFailureHandler() {
        return this.m_failureHandler;
    }

    public final Sink getCommandSink() {
        return this.m_queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerSignalHandler(Signal signal, EventHandler handler) {
        try {
            this.m_mutex.acquire();
            ArrayList<EventHandler> handlers = (ArrayList<EventHandler>)this.m_signalHandlers.get(signal.getClass());
            if (null == handlers) {
                handlers = new ArrayList<EventHandler>();
            }
            if (!handlers.contains(handler)) {
                handlers.add(handler);
                this.m_signalHandlers.put(signal.getClass(), handlers);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.m_mutex.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deregisterSignalHandler(Signal signal, EventHandler handler) {
        try {
            this.m_mutex.acquire();
            ArrayList handlers = (ArrayList)this.m_signalHandlers.get(signal.getClass());
            if (null != handlers) {
                if (handlers.remove(handler)) {
                    this.m_signalHandlers.put(signal.getClass(), handlers);
                }
                if (0 == handlers.size()) {
                    this.m_signalHandlers.remove(signal.getClass());
                }
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.m_mutex.release();
        }
    }

    public void dispose() {
        this.m_isAccepting = false;
        Object[] remainingElements = this.m_queue.dequeueAll();
        for (int i = 0; i < remainingElements.length; ++i) {
            this.getEventHandler().handleEvent(remainingElements[i]);
        }
    }

    public final Source[] getSources() {
        return this.m_sources;
    }

    public final EventHandler getEventHandler() {
        return this.m_eventHandler;
    }

    public boolean accept(Object element, Sink modifyingSink) {
        return this.m_isAccepting;
    }

    public boolean accept(Object[] elements, Sink modifyingSink) {
        return this.m_isAccepting;
    }

    private static final class DelayedCommandInfo {
        protected DelayedCommand m_command;
        protected long m_nextRunTime;
        protected int m_numExecutions;
        protected boolean m_repeatable;

        private DelayedCommandInfo() {
        }
    }

    private final class CommandEventHandler
    implements EventHandler {
        private final Map m_signalHandlers;
        private final Buffer m_delayedCommands = new UnboundedFifoBuffer();

        protected CommandEventHandler(Map signalHandlers) {
            this.m_signalHandlers = signalHandlers;
        }

        public final void handleEvents(Object[] elements) {
            for (int i = 0; i < elements.length; ++i) {
                this.handleEvent(elements[i]);
            }
            int size = this.m_delayedCommands.size();
            for (int i = 0; i < size; ++i) {
                DelayedCommandInfo command = (DelayedCommandInfo)this.m_delayedCommands.remove();
                if (System.currentTimeMillis() >= command.m_nextRunTime) {
                    RepeatedCommand cmd;
                    int numRepeats;
                    block5: {
                        try {
                            command.m_command.execute();
                        }
                        catch (Exception e) {
                            if (!CommandManager.this.getLogger().isWarnEnabled()) break block5;
                            CommandManager.this.getLogger().warn("Exception during Command.execute()", (Throwable)e);
                        }
                    }
                    ++command.m_numExecutions;
                    if (!command.m_repeatable || (numRepeats = (cmd = (RepeatedCommand)command.m_command).getNumberOfRepeats()) >= 1 && command.m_numExecutions >= numRepeats) continue;
                    command.m_nextRunTime = System.currentTimeMillis() + cmd.getRepeatInterval();
                    this.m_delayedCommands.add((Object)command);
                    continue;
                }
                this.m_delayedCommands.add((Object)command);
            }
        }

        public final void handleEvent(Object element) {
            block7: {
                if (!(element instanceof Signal)) {
                    return;
                }
                if (!(element instanceof Command)) {
                    ArrayList handlers = (ArrayList)this.m_signalHandlers.get(element.getClass());
                    if (null != handlers) {
                        Iterator i = handlers.iterator();
                        while (i.hasNext()) {
                            EventHandler handler = (EventHandler)i.next();
                            handler.handleEvent(element);
                        }
                    }
                    return;
                }
                if (element instanceof DelayedCommand) {
                    DelayedCommandInfo commandInfo = new DelayedCommandInfo();
                    commandInfo.m_command = (DelayedCommand)element;
                    commandInfo.m_nextRunTime = System.currentTimeMillis() + commandInfo.m_command.getDelayInterval();
                    commandInfo.m_numExecutions = 0;
                    commandInfo.m_repeatable = element instanceof RepeatedCommand;
                    this.m_delayedCommands.add((Object)commandInfo);
                    return;
                }
                try {
                    ((Command)element).execute();
                }
                catch (Exception e) {
                    boolean stopProcessing = CommandManager.this.getCommandFailureHandler().handleCommandFailure((Command)element, (Throwable)e);
                    if (!stopProcessing) break block7;
                    CommandManager.this.m_isAccepting = false;
                    CommandManager.this.m_queue.dequeueAll();
                }
            }
        }
    }
}

