/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.event.command;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.logger.NullLogger;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.excalibur.event.command.AbstractThreadManager;
import org.apache.excalibur.util.SystemUtil;

public final class TPCThreadManager
extends AbstractThreadManager
implements Parameterizable {
    private PooledExecutor m_threadPool;
    private int m_processors = -1;
    private int m_threadsPerProcessor = 1;
    private int m_keepAliveTime = 300000;
    private boolean m_hardShutdown = false;

    public void parameterize(Parameters parameters) throws ParameterException {
        this.m_processors = Math.max(1, parameters.getParameterAsInteger("processors", 1));
        this.m_threadsPerProcessor = Math.max(parameters.getParameterAsInteger("threads-per-processor", 1), 1);
        this.m_keepAliveTime = parameters.getParameterAsInteger("keep-alive-time", 300000);
        this.setSleepTime(parameters.getParameterAsLong("sleep-time", 1000L));
        this.m_hardShutdown = parameters.getParameterAsBoolean("force-shutdown", false);
    }

    public void initialize() throws Exception {
        if (this.m_processors < 1) {
            this.m_processors = Math.max(1, SystemUtil.numProcessors());
        }
        if (this.isInitialized()) {
            throw new IllegalStateException("ThreadManager is already initailized");
        }
        int maxPoolSize = Math.max(this.m_processors * this.m_threadsPerProcessor + 1, this.m_processors + 1);
        this.m_threadPool = new PooledExecutor(this.m_processors + 1);
        this.m_threadPool.setMinimumPoolSize(2);
        this.m_threadPool.setMaximumPoolSize(maxPoolSize);
        this.m_threadPool.waitWhenBlocked();
        this.m_threadPool.setThreadFactory(new ThreadFactory(){

            public Thread newThread(Runnable run) {
                Thread newThread = new Thread(run);
                newThread.setDaemon(true);
                newThread.setPriority(1);
                return newThread;
            }
        });
        if (maxPoolSize == 2) {
            this.m_threadPool.setKeepAliveTime(-1L);
        } else {
            this.m_threadPool.setKeepAliveTime((long)this.m_keepAliveTime);
        }
        if (null == this.getLogger()) {
            this.enableLogging((Logger)new NullLogger());
        }
        this.setExecutor((Executor)this.m_threadPool);
        super.initialize();
    }

    protected final void doDispose() {
        if (this.m_hardShutdown) {
            this.m_threadPool.shutdownNow();
        } else {
            this.m_threadPool.shutdownAfterProcessingCurrentlyQueuedTasks();
        }
        this.m_threadPool.interruptAll();
        try {
            if (!this.m_threadPool.awaitTerminationAfterShutdown(this.getSleepTime())) {
                this.getLogger().warn("Thread pool took longer than " + this.getSleepTime() + " ms to shut down");
            }
        }
        catch (InterruptedException ie) {
            this.getLogger().warn("Thread pool was interrupted while waiting for shutdown to complete.", (Throwable)ie);
        }
    }
}

