/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portlets.weather.component;

import java.util.List;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionListener;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import org.exoplatform.faces.core.component.UIPortlet;
import org.exoplatform.portlets.weather.WeatherData;
import org.exoplatform.portlets.weather.WeatherUtil;
import org.exoplatform.portlets.weather.component.UISelectStationForm;
import org.exoplatform.portlets.weather.component.UIWeatherEditPortlet;
import org.exoplatform.portlets.weather.component.UIWeatherForm;
import org.exoplatform.portlets.weather.component.UIWeatherTitle;

public class UIWeatherEditPortlet
extends UIPortlet {
    private WeatherUtil weatherUtil_;
    private WeatherData weatherData_ = new WeatherData();
    private boolean storeUserPref_ = false;
    boolean editOK_;
    private UIWeatherTitle uiWeatherTitle;
    private UIWeatherForm uiWeatherForm;
    private UISelectStationForm uiSelectStationForm;

    public UIWeatherEditPortlet() {
        this.weatherUtil_ = WeatherUtil.getInstance((UIPortlet)this);
        this.setId("UIWeatherEditPortlet");
        this.setRendererType("ChildrenRenderer");
        List children = this.getChildren();
        this.uiWeatherTitle = new UIWeatherTitle();
        this.uiWeatherTitle.setId("UIWeatherEditPortletTitle");
        this.uiWeatherTitle.setRendered(true);
        this.uiWeatherForm = new UIWeatherForm();
        this.uiWeatherForm.setRendered(true);
        this.uiSelectStationForm = new UISelectStationForm();
        this.uiSelectStationForm.setRendered(false);
        this.process();
        children.add(this.uiWeatherTitle);
        children.add(this.uiWeatherForm);
        children.add(this.uiSelectStationForm);
        this.uiWeatherForm.addActionListener((ActionListener)new SearchStationListener(this).setActionToListen("WeatherFormSearch"));
        this.uiSelectStationForm.addActionListener((ActionListener)new SelectStationListener(this).setActionToListen("SelectStationFormOk"));
    }

    private void process() {
        if (!this.weatherUtil_.isServiceInitialized()) {
            this.uiWeatherTitle.setTitle("GlobalWeather Service can not be initialized");
            this.uiWeatherTitle.setRendered(true);
            this.uiWeatherForm.setRendered(false);
            this.uiSelectStationForm.setRendered(false);
        } else {
            try {
                this.weatherUtil_.checkRequest(this.weatherData_);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.weatherUtil_.setServiceAvailable(false);
            }
            if (!this.weatherUtil_.isServiceAvailable()) {
                this.uiWeatherTitle.setTitle("Service is not available");
                this.uiWeatherTitle.setRendered(true);
                this.uiWeatherForm.setRendered(false);
                this.uiSelectStationForm.setRendered(false);
            } else if (this.weatherData_.isStationFound()) {
                if (this.weatherData_.getNbStations() == 1) {
                    this.uiWeatherTitle.setTitle("Weather Portlet Preferences (" + this.weatherData_.getStationsList()[0].getName() + ")");
                    if (this.storeUserPref_) {
                        try {
                            this.weatherData_.getPreferences().setValue("code", this.weatherData_.getDisplayedStationCode().toUpperCase());
                            this.weatherData_.getPreferences().store();
                            this.editOK_ = true;
                        }
                        catch (Exception ex) {
                            this.storeUserPref_ = false;
                            ex.printStackTrace();
                            this.uiWeatherTitle.setTitle("Weather Portlet Preferences : Erreur durant la sauvegarde");
                        }
                        if (this.editOK_) {
                            this.uiWeatherForm.setSearchStationCode(this.weatherData_.getPreferredStationCode());
                            this.uiWeatherForm.setSearchStationName("");
                            ActionResponse response = (ActionResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse();
                            try {
                                response.setPortletMode(PortletMode.VIEW);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    } else {
                        this.uiWeatherForm.setSearchStationCode(this.weatherData_.getPreferredStationCode());
                        this.uiWeatherForm.setSearchStationName("");
                    }
                    this.uiWeatherTitle.setRendered(true);
                    this.uiWeatherForm.setRendered(true);
                    this.uiSelectStationForm.setRendered(false);
                } else if (this.weatherData_.getNbStations() > 1) {
                    this.uiWeatherTitle.setTitle("S\u00d4\u00f8\u03a9lection d'une station");
                    this.uiWeatherTitle.setRendered(true);
                    this.uiWeatherForm.setRendered(false);
                    this.uiSelectStationForm.setStationsList(this.weatherData_.getStationsList());
                    this.uiSelectStationForm.setRendered(true);
                }
            } else {
                this.uiWeatherTitle.setTitle("Weather Portlet Preferences : Station inconnue !");
                this.storeUserPref_ = false;
                this.uiWeatherTitle.setRendered(true);
                this.uiWeatherForm.setRendered(true);
                this.uiSelectStationForm.setRendered(false);
            }
        }
    }

    static /* synthetic */ boolean access$002(UIWeatherEditPortlet x0, boolean x1) {
        x0.storeUserPref_ = x1;
        return x0.storeUserPref_;
    }

    static /* synthetic */ UIWeatherForm access$100(UIWeatherEditPortlet x0) {
        return x0.uiWeatherForm;
    }

    static /* synthetic */ WeatherData access$200(UIWeatherEditPortlet x0) {
        return x0.weatherData_;
    }

    static /* synthetic */ void access$300(UIWeatherEditPortlet x0) {
        x0.process();
    }

    static /* synthetic */ UISelectStationForm access$400(UIWeatherEditPortlet x0) {
        return x0.uiSelectStationForm;
    }
}

