/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portlets.weather.component;

import com.capeclear.www.GlobalWeather_xsd.Direction;
import com.capeclear.www.GlobalWeather_xsd.Layer;
import com.capeclear.www.GlobalWeather_xsd.Sky;
import com.capeclear.www.GlobalWeather_xsd.WeatherReport;
import com.capeclear.www.GlobalWeather_xsd.Wind;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.faces.context.FacesContext;
import org.exoplatform.faces.core.component.UIExoComponentBase;
import org.exoplatform.portlets.weather.component.UIWeatherDetail;
import org.exoplatform.portlets.weather.component.UIWeatherForm;

public class UIWeatherView
extends UIExoComponentBase {
    private boolean stationFound_;
    private WeatherReport weatherReport_;
    private ResourceBundle resources_;
    private String contextPath_;
    private UIWeatherDetail uiWeatherDetail;
    private UIWeatherForm uiWeatherForm;

    public UIWeatherView() {
        this.setId("UIWeatherView");
        this.setRendererType("ChildrenRenderer");
        List children = this.getChildren();
        this.uiWeatherDetail = new UIWeatherDetail();
        this.uiWeatherForm = new UIWeatherForm();
        this.weatherReport_ = null;
        this.stationFound_ = false;
        this.resources_ = null;
        this.contextPath_ = null;
        this.updateTree();
        children.add(this.uiWeatherDetail);
        children.add(this.uiWeatherForm);
    }

    public String getSearchStationCode() {
        return this.uiWeatherForm.getSearchStationCode();
    }

    public String getSearchStationName() {
        return this.uiWeatherForm.getSearchStationName();
    }

    public UIWeatherForm getUIWeatherForm() {
        return this.uiWeatherForm;
    }

    public void setSearchStationCode(String pSearchStationCode) {
        this.uiWeatherForm.setSearchStationCode(pSearchStationCode);
    }

    public void setSearchStationName(String pSearchStationName) {
        this.uiWeatherForm.setSearchStationName(pSearchStationName);
    }

    public void setStationFound(boolean pStationFound) {
        this.stationFound_ = pStationFound;
        this.updateTree();
    }

    public void setWeatherReport(WeatherReport pWeatherReport) {
        this.weatherReport_ = pWeatherReport;
        this.updateTree();
    }

    public void setResources(ResourceBundle pResources) {
        this.resources_ = pResources;
        this.updateTree();
    }

    public void setContextPath(String pContextPath) {
        this.contextPath_ = pContextPath;
        this.updateTree();
    }

    public void decode(FacesContext context) {
    }

    private void updateTree() {
        if (this.weatherReport_ != null) {
            Calendar timeStamp = this.weatherReport_.getTimestamp();
            this.uiWeatherDetail.setStationDetail(timeStamp.getTime().toLocaleString());
            Sky sky = this.weatherReport_.getSky();
            if (sky != null) {
                String typeSky = null;
                String iconFile = null;
                Layer[] layers = sky.getLayers();
                if (layers != null && layers.length > 0 && (typeSky = layers[0].getType().getValue()) != null) {
                    int extent;
                    if (typeSky.equals("CLOUD") && ((extent = layers[0].getExtent()) == 1 || extent == 2 || extent == 3 || extent == 4)) {
                        typeSky = typeSky + "_" + String.valueOf(extent);
                    }
                    try {
                        iconFile = this.resources_.getString(typeSky + "_DAY_ICON");
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    try {
                        this.uiWeatherDetail.setIconSrc(this.contextPath_ + this.resources_.getString("ICONS_SOURCE_PATH") + iconFile);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            this.uiWeatherDetail.setTemperature(String.valueOf(this.weatherReport_.getTemperature().getAmbient()));
            Wind wind = this.weatherReport_.getWind();
            if (wind != null) {
                String stringWind = null;
                try {
                    DecimalFormat df = new DecimalFormat("# ###.###");
                    stringWind = df.format(wind.getPrevailing_speed()) + " m/s";
                }
                catch (Exception ex) {
                    // empty catch block
                }
                Direction direction = wind.getPrevailing_direction();
                if (direction != null) {
                    StringTokenizer strTk = new StringTokenizer(direction.getString(), "(");
                    stringWind = stringWind != null ? stringWind + " (" + strTk.nextToken().toString().trim() + ")" : strTk.nextToken().toString();
                }
                this.uiWeatherDetail.setWind(stringWind);
            }
            this.uiWeatherDetail.setRendered(true);
        } else {
            this.uiWeatherDetail.setRendered(false);
        }
        this.uiWeatherForm.setRendered(true);
    }
}

