/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portlets.weather.component;

import com.capeclear.www.GlobalWeather_xsd.Station;
import java.util.List;
import javax.faces.event.ActionListener;
import org.exoplatform.faces.core.component.UIPortlet;
import org.exoplatform.portlets.weather.WeatherData;
import org.exoplatform.portlets.weather.WeatherUtil;
import org.exoplatform.portlets.weather.component.UISelectStationForm;
import org.exoplatform.portlets.weather.component.UIWeatherTitle;
import org.exoplatform.portlets.weather.component.UIWeatherView;
import org.exoplatform.portlets.weather.component.UIWeatherViewPortlet;

public class UIWeatherViewPortlet
extends UIPortlet {
    private WeatherUtil weatherUtil_;
    private WeatherData weatherData_ = new WeatherData();
    private UIWeatherTitle uiWeatherTitle;
    private UIWeatherView uiWeatherView;
    private UISelectStationForm uiSelectStationForm;

    public UIWeatherViewPortlet() {
        this.weatherUtil_ = WeatherUtil.getInstance((UIPortlet)this);
        this.setId("UIWeatherViewPortlet");
        this.setRendererType("ChildrenRenderer");
        List children = this.getChildren();
        this.uiWeatherTitle = new UIWeatherTitle();
        this.uiWeatherTitle.setId("UIWeatherViewPortletTitle");
        this.uiWeatherTitle.setRendered(true);
        this.uiWeatherView = new UIWeatherView();
        this.uiWeatherView.setRendered(true);
        this.uiSelectStationForm = new UISelectStationForm();
        this.uiSelectStationForm.setRendered(false);
        if (this.weatherUtil_.isServiceInitialized()) {
            this.uiWeatherView.setContextPath(this.weatherUtil_.getContextPath());
            this.uiWeatherView.setResources(this.weatherUtil_.getResources());
        }
        this.process();
        children.add(this.uiWeatherTitle);
        children.add(this.uiWeatherView);
        children.add(this.uiSelectStationForm);
        this.uiWeatherView.getUIWeatherForm().addActionListener((ActionListener)new SearchStationListener(this).setActionToListen("WeatherFormSearch"));
        this.uiSelectStationForm.addActionListener((ActionListener)new SelectStationListener(this).setActionToListen("SelectStationFormOk"));
    }

    private void process() {
        if (!this.weatherUtil_.isServiceInitialized()) {
            this.uiWeatherTitle.setTitle("GlobalWeather Service can not be initialized");
            this.uiWeatherTitle.setRendered(true);
            this.uiWeatherView.setRendered(false);
            this.uiSelectStationForm.setRendered(false);
        } else {
            try {
                this.weatherUtil_.checkRequest(this.weatherData_);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.weatherUtil_.setServiceAvailable(false);
            }
            if (!this.weatherUtil_.isServiceAvailable()) {
                this.uiWeatherTitle.setTitle("Service is not available");
                this.uiWeatherTitle.setRendered(true);
                this.uiWeatherView.setRendered(false);
                this.uiSelectStationForm.setRendered(false);
            } else {
                this.uiWeatherView.setStationFound(this.weatherData_.isStationFound());
                if (this.weatherData_.isStationFound()) {
                    if (this.weatherData_.getNbStations() == 1) {
                        Station station = this.weatherData_.getStationsList()[0];
                        this.uiWeatherTitle.setTitle(station.getName() + " (" + station.getCountry() + ")");
                        try {
                            this.uiWeatherView.setWeatherReport(this.weatherUtil_.getWeatherReport(this.weatherData_.getDisplayedStationCode()));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        this.uiWeatherTitle.setRendered(true);
                        this.uiWeatherView.setRendered(true);
                        this.uiSelectStationForm.setRendered(false);
                    } else if (this.weatherData_.getNbStations() > 1) {
                        this.uiWeatherTitle.setTitle("S\u00d4\u00f8\u03a9lection d'une station");
                        this.uiWeatherTitle.setRendered(true);
                        this.uiWeatherView.setRendered(false);
                        this.uiSelectStationForm.setStationsList(this.weatherData_.getStationsList());
                        this.uiSelectStationForm.setRendered(true);
                    }
                } else {
                    this.uiWeatherTitle.setTitle("Station inconnue");
                    this.uiWeatherView.setWeatherReport(null);
                    this.uiWeatherTitle.setRendered(true);
                    this.uiWeatherView.setRendered(true);
                    this.uiSelectStationForm.setRendered(false);
                }
            }
        }
    }

    static /* synthetic */ UIWeatherView access$000(UIWeatherViewPortlet x0) {
        return x0.uiWeatherView;
    }

    static /* synthetic */ WeatherData access$100(UIWeatherViewPortlet x0) {
        return x0.weatherData_;
    }

    static /* synthetic */ void access$200(UIWeatherViewPortlet x0) {
        x0.process();
    }

    static /* synthetic */ UISelectStationForm access$300(UIWeatherViewPortlet x0) {
        return x0.uiSelectStationForm;
    }
}

