/*
 * Decompiled with CFR 0.152.
 */
package expert.os.integration.microstream;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import one.microstream.collections.lazy.LazyHashMap;

public class DataStructure {
    private final Map<Object, Object> data = new LazyHashMap();

    public <K, V> void put(K key, V value) {
        Objects.requireNonNull(key, "key is required");
        Objects.requireNonNull(value, "value is required");
        this.data.put(key, value);
    }

    public <K, V> Optional<V> get(K key) {
        Objects.requireNonNull(key, "key is required");
        return Optional.ofNullable(this.data.get(key));
    }

    public <K> void remove(K key) {
        Objects.requireNonNull(key, "key is required");
        this.data.remove(key);
    }

    public int size() {
        return this.data.size();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public <V> Stream<V> values() {
        if (this.data.isEmpty()) {
            return Stream.empty();
        }
        return this.data.values().stream();
    }

    public void clear() {
        this.data.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataStructure that = (DataStructure)o;
        return Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hashCode(this.data);
    }

    public String toString() {
        return "DataStructure{data=" + this.data + "}";
    }
}

