/*
 * Decompiled with CFR 0.152.
 */
package expert.os.integration.microstream;

import expert.os.integration.microstream.FieldMetadata;
import jakarta.data.exceptions.MappingException;
import jakarta.nosql.Column;
import jakarta.nosql.Id;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

final class EntityMetadata {
    private final FieldMetadata id;
    private final List<FieldMetadata> fields;
    private final Class<?> type;

    private EntityMetadata(FieldMetadata id, List<FieldMetadata> fields, Class<?> type) {
        this.id = id;
        this.fields = fields;
        this.type = type;
    }

    List<FieldMetadata> fields() {
        return Collections.unmodifiableList(this.fields);
    }

    FieldMetadata id() {
        return this.id;
    }

    Class<?> type() {
        return this.type;
    }

    Optional<FieldMetadata> field(String name) {
        if (this.id.name().equals(name)) {
            return Optional.ofNullable(this.id);
        }
        return this.fields.stream().filter(f -> f.name().equals(name)).findFirst();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityMetadata that = (EntityMetadata)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.fields, that.fields) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.fields, this.type);
    }

    public String toString() {
        return "EntityMetadata{id=" + this.id + ", fields=" + this.fields + ", type=" + this.type + "}";
    }

    static EntityMetadata of(Class<?> type) {
        Objects.requireNonNull(type, "type is required");
        ArrayList<FieldMetadata> fields = new ArrayList<FieldMetadata>();
        FieldMetadata id = null;
        for (Field field : type.getDeclaredFields()) {
            field.setAccessible(true);
            if (field.getAnnotation(Id.class) != null) {
                id = FieldMetadata.of(field);
                continue;
            }
            if (field.getAnnotation(Column.class) == null) continue;
            fields.add(FieldMetadata.of(field));
        }
        if (id == null) {
            throw new MappingException("The entity " + type + " requires at least a field with @jakarta.nosql.Id annotation");
        }
        return new EntityMetadata(id, fields, type);
    }
}

