/*
 * Decompiled with CFR 0.152.
 */
package expert.os.integration.microstream;

import expert.os.integration.microstream.AbstractMapperQuery;
import expert.os.integration.microstream.EntityMetadata;
import expert.os.integration.microstream.FieldMetadata;
import expert.os.integration.microstream.MicrostreamTemplate;
import jakarta.nosql.QueryMapper;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class MapperDelete
extends AbstractMapperQuery
implements QueryMapper.MapperDeleteFrom,
QueryMapper.MapperDeleteWhere,
QueryMapper.MapperDeleteNameCondition,
QueryMapper.MapperDeleteNotCondition {
    MapperDelete(EntityMetadata mapping, MicrostreamTemplate template) {
        super(mapping, template);
    }

    public QueryMapper.MapperDeleteNameCondition where(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        return this;
    }

    public QueryMapper.MapperDeleteNameCondition and(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = true;
        return this;
    }

    public QueryMapper.MapperDeleteNameCondition or(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = false;
        return this;
    }

    public QueryMapper.MapperDeleteNotCondition not() {
        this.negate = true;
        return this;
    }

    public <T> QueryMapper.MapperDeleteWhere eq(T value) {
        this.eqImpl(value);
        return this;
    }

    public QueryMapper.MapperDeleteWhere like(String value) {
        throw new UnsupportedOperationException("There is no support for like condition");
    }

    public <T> QueryMapper.MapperDeleteWhere gt(T value) {
        this.gtImpl(value);
        return this;
    }

    public <T> QueryMapper.MapperDeleteWhere gte(T value) {
        this.gteImpl(value);
        return this;
    }

    public <T> QueryMapper.MapperDeleteWhere lt(T value) {
        this.ltImpl(value);
        return this;
    }

    public <T> QueryMapper.MapperDeleteWhere lte(T value) {
        this.lteImpl(value);
        return this;
    }

    public <T> QueryMapper.MapperDeleteWhere between(T valueA, T valueB) {
        throw new UnsupportedOperationException("There is no support for between condition");
    }

    public <T> QueryMapper.MapperDeleteWhere in(Iterable<T> values) {
        this.inImpl(values);
        return this;
    }

    public void execute() {
        this.delete();
    }

    private <T> void delete() {
        Stream<Object> values = this.template.entities();
        if (this.condition != null) {
            values = values.filter(this.condition);
        }
        FieldMetadata id = this.mapping.id();
        List ids = values.map(t -> id.get(t)).collect(Collectors.toUnmodifiableList());
        this.template.delete(ids);
    }
}

