/*
 * Decompiled with CFR 0.152.
 */
package expert.os.integration.microstream;

import expert.os.integration.microstream.AbstractMapperQuery;
import expert.os.integration.microstream.EntityMetadata;
import expert.os.integration.microstream.MicrostreamTemplate;
import jakarta.data.exceptions.NonUniqueResultException;
import jakarta.nosql.QueryMapper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class MapperSelect
extends AbstractMapperQuery
implements QueryMapper.MapperFrom,
QueryMapper.MapperLimit,
QueryMapper.MapperSkip,
QueryMapper.MapperOrder,
QueryMapper.MapperNameCondition,
QueryMapper.MapperNotCondition,
QueryMapper.MapperNameOrder,
QueryMapper.MapperWhere {
    private final List<Comparator<?>> sorts = new ArrayList();

    MapperSelect(EntityMetadata mapping, MicrostreamTemplate template) {
        super(mapping, template);
    }

    public QueryMapper.MapperNameCondition and(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = true;
        return this;
    }

    public QueryMapper.MapperNameCondition or(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = false;
        return this;
    }

    public QueryMapper.MapperNameCondition where(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        return this;
    }

    public QueryMapper.MapperSkip skip(long start) {
        this.start = start;
        return this;
    }

    public QueryMapper.MapperLimit limit(long limit) {
        this.limit = limit;
        return this;
    }

    public QueryMapper.MapperOrder orderBy(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        return this;
    }

    public QueryMapper.MapperNotCondition not() {
        this.negate = true;
        return this;
    }

    public <T> QueryMapper.MapperWhere eq(T value) {
        this.eqImpl(value);
        return this;
    }

    public QueryMapper.MapperWhere like(String value) {
        throw new UnsupportedOperationException("There is no support for like condition");
    }

    public <T> QueryMapper.MapperWhere gt(T value) {
        this.gtImpl(value);
        return this;
    }

    public <T> QueryMapper.MapperWhere gte(T value) {
        this.gteImpl(value);
        return this;
    }

    public <T> QueryMapper.MapperWhere lt(T value) {
        this.ltImpl(value);
        return this;
    }

    public <T> QueryMapper.MapperWhere lte(T value) {
        this.lteImpl(value);
        return this;
    }

    public <T> QueryMapper.MapperWhere between(T valueA, T valueB) {
        throw new UnsupportedOperationException("There is no support for between condition");
    }

    public <T> QueryMapper.MapperWhere in(Iterable<T> values) {
        this.inImpl(values);
        return this;
    }

    public QueryMapper.MapperNameOrder asc() {
        this.sorts.add(this.field().comparator());
        return this;
    }

    public QueryMapper.MapperNameOrder desc() {
        this.sorts.add(this.field().reversed());
        return this;
    }

    public <T> Stream<T> stream() {
        Stream values = this.template.entities();
        if (this.condition != null) {
            values = values.filter(this.condition);
        }
        if (!this.sorts.isEmpty()) {
            Comparator comparator = this.sorts.stream().map(c -> c).reduce(Comparator::thenComparing).orElseThrow();
            values = values.sorted(comparator);
        }
        if (this.start > 0L) {
            values = values.skip(this.start);
        }
        if (this.limit > 0L) {
            values = values.limit(this.limit);
        }
        return values;
    }

    public <T> List<T> result() {
        return this.stream().collect(Collectors.toUnmodifiableList());
    }

    public <T> Optional<T> singleResult() {
        List entities = this.stream().collect(Collectors.toUnmodifiableList());
        if (entities.isEmpty()) {
            return Optional.empty();
        }
        if (entities.size() > 1) {
            throw new NonUniqueResultException("The single result can return zero or one, but it is returning " + entities.size());
        }
        return Optional.of(entities.get(0));
    }
}

