/*
 * Decompiled with CFR 0.152.
 */
package expert.os.integration.microstream;

import expert.os.integration.microstream.DataStructure;
import expert.os.integration.microstream.EntityMetadata;
import expert.os.integration.microstream.MapperDelete;
import expert.os.integration.microstream.MapperSelect;
import expert.os.integration.microstream.Microstream;
import expert.os.integration.microstream.Transaction;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Typed;
import jakarta.inject.Inject;
import jakarta.nosql.QueryMapper;
import jakarta.nosql.Template;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

@ApplicationScoped
@Typed(value={Template.class, MicrostreamTemplate.class})
@Default
@Microstream
class MicrostreamTemplate
implements Template {
    private DataStructure data;
    private EntityMetadata metadata;

    @Inject
    MicrostreamTemplate(DataStructure data, EntityMetadata metadata) {
        this.data = data;
        this.metadata = metadata;
    }

    @Deprecated
    MicrostreamTemplate() {
    }

    @Transaction
    public <T> T insert(T entity) {
        return this.save(entity);
    }

    public <T> T insert(T entity, Duration ttl) {
        throw new UnsupportedOperationException("The insert with duration is unsupported");
    }

    @Transaction
    public <T> Iterable<T> insert(Iterable<T> entities) {
        return this.save(entities);
    }

    public <T> Iterable<T> insert(Iterable<T> entities, Duration ttl) {
        throw new UnsupportedOperationException("The insert with duration is unsupported");
    }

    @Transaction
    public <T> T update(T entity) {
        return this.save(entity);
    }

    @Transaction
    public <T> Iterable<T> update(Iterable<T> entities) {
        return this.save(entities);
    }

    public <T, K> Optional<T> find(Class<T> type, K id) {
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(id, "id is required");
        return this.data.get(id);
    }

    @Transaction
    public <T, K> void delete(Class<T> type, K id) {
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(id, "id is required");
        this.data.remove(id);
    }

    @Transaction
    <T, K> void delete(Iterable<K> ids) {
        Objects.requireNonNull(ids, "ids is required");
        ids.forEach(this.data::remove);
    }

    @Transaction
    void deleteAll() {
        this.data.clear();
    }

    <T> Stream<T> entities() {
        return this.data.values();
    }

    boolean isEmpty() {
        return this.data.isEmpty();
    }

    long size() {
        return this.data.size();
    }

    public <T> QueryMapper.MapperFrom select(Class<T> type) {
        Objects.requireNonNull(type, "type is required");
        if (this.metadata.type().equals(type)) {
            return new MapperSelect(this.metadata, this);
        }
        throw new IllegalArgumentException("The type is not the same of the class annotated with @Entity. Param class " + type + " @Entity class " + this.metadata.type());
    }

    public <T> QueryMapper.MapperDeleteFrom delete(Class<T> type) {
        Objects.requireNonNull(type, "type is required");
        if (this.metadata.type().equals(type)) {
            return new MapperDelete(this.metadata, this);
        }
        throw new IllegalArgumentException("The type is not the same of the class annotated with @Entity. Param class " + type + " @Entity class " + this.metadata.type());
    }

    EntityMetadata metadata() {
        return this.metadata;
    }

    private <T> T save(T entity) {
        Objects.requireNonNull(entity, "entity is required");
        Object id = this.metadata.id().get(entity);
        this.data.put(id, entity);
        return entity;
    }

    private <T> Iterable<T> save(Iterable<T> entities) {
        Objects.requireNonNull(entities, "entities is required");
        entities.forEach(this::save);
        return entities;
    }
}

