/*
 * Decompiled with CFR 0.152.
 */
package expert.os.integration.microstream;

import expert.os.integration.microstream.Transaction;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import one.microstream.concurrency.XThreads;
import one.microstream.persistence.types.Storer;
import one.microstream.storage.types.StorageManager;

@Transaction
@Interceptor
@Priority(value=2000)
class TransactionInterceptor {
    private static final Logger LOGGER = Logger.getLogger(TransactionInterceptor.class.getName());
    @Inject
    private StorageManager manager;

    TransactionInterceptor() {
    }

    @AroundInvoke
    public Object execute(InvocationContext context) throws Exception {
        LOGGER.log(Level.FINEST, "Executing a transaction at the method: " + context.getMethod());
        Object proceed = context.proceed();
        XThreads.executeSynchronized(() -> {
            Object root = this.manager.root();
            Storer storer = this.manager.createEagerStorer();
            long storeId = storer.store(root);
            LOGGER.log(Level.WARNING, "Store the root: " + storeId);
            storer.commit();
        });
        return proceed;
    }
}

