/*
 * Decompiled with CFR 0.152.
 */
package expert.os.integration.microstream;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import jakarta.data.repository.DataRepository;
import jakarta.data.repository.Repository;
import jakarta.nosql.Entity;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public enum ClassScanner {
    INSTANCE;

    private final Set<Class<?>> entities = new HashSet();
    private final Set<Class<?>> repositories = new HashSet();

    private ClassScanner() {
        Logger logger = Logger.getLogger(ClassScanner.class.getName());
        logger.fine("Starting scan class to find entities, embeddable and repositories.");
        try (ScanResult result = new ClassGraph().enableAllInfo().scan();){
            this.entities.addAll(result.getClassesWithAnnotation(Entity.class).loadClasses());
            this.repositories.addAll(result.getClassesWithAnnotation(Repository.class).getInterfaces().loadClasses(DataRepository.class));
        }
        logger.fine(String.format("Finished the class scan with entities %d, and repositories: %d", this.entities.size(), this.repositories.size()));
    }

    public Set<Class<?>> entities() {
        return Collections.unmodifiableSet(this.entities);
    }

    public Set<Class<?>> repositories() {
        return Collections.unmodifiableSet(this.repositories);
    }
}

