/*
 * Decompiled with CFR 0.152.
 */
package expert.os.integration.microstream;

import expert.os.integration.microstream.Entry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.microstream.persistence.types.Persister;
import one.microstream.storage.types.StorageManager;

class DataStorage {
    private final Map<Object, Object> data;
    private final Persister persister;

    DataStorage(Map<Object, Object> data, Persister persister) {
        this.data = data;
        this.persister = persister;
    }

    public synchronized <K, V> void put(K key, V value) {
        Objects.requireNonNull(key, "key is required");
        Objects.requireNonNull(value, "value is required");
        Object oldValue = this.data.put(key, value);
        if (oldValue == value) {
            this.commitEntity(value);
        } else {
            this.commitMap();
        }
    }

    public synchronized void put(List<Entry> entries) {
        Objects.requireNonNull(entries, "entries is required");
        Map<Object, Object> entities = entries.stream().collect(Collectors.toMap(Entry::key, Entry::value, (a, b) -> a));
        ArrayList<Object> updatedInstances = new ArrayList<Object>();
        for (Map.Entry<Object, Object> entry : entities.entrySet()) {
            if (entry.getValue() != this.data.put(entry.getKey(), entry.getValue())) continue;
            updatedInstances.add(entry.getValue());
        }
        if (!updatedInstances.isEmpty()) {
            this.persister.storeAll(updatedInstances);
        }
        if (updatedInstances.size() != entities.size()) {
            this.commitMap();
        }
    }

    public synchronized <K, V> Optional<V> get(K key) {
        Objects.requireNonNull(key, "key is required");
        return Optional.ofNullable(this.data.get(key));
    }

    public synchronized <K> void remove(K key) {
        Objects.requireNonNull(key, "key is required");
        this.data.remove(key);
        this.commitMap();
    }

    public synchronized <K> void remove(Iterable<K> keys) {
        Objects.requireNonNull(keys, "keys is required");
        keys.forEach(this.data::remove);
        this.commitMap();
    }

    public synchronized int size() {
        return this.data.size();
    }

    public synchronized boolean isEmpty() {
        return this.data.isEmpty();
    }

    synchronized <V> Stream<V> values() {
        if (this.data.isEmpty()) {
            return Stream.empty();
        }
        ArrayList<Object> entries = new ArrayList<Object>();
        entries.addAll(this.data.values());
        return entries.stream();
    }

    synchronized <V> Stream<V> values(Predicate<Object> predicate, List<Comparator<?>> sorts, long start, long limit) {
        if (this.data.isEmpty()) {
            return Stream.empty();
        }
        Stream<Object> values = this.data.values().stream().filter(predicate);
        if (!sorts.isEmpty()) {
            Comparator comparator = sorts.stream().map(c -> c).reduce(Comparator::thenComparing).orElseThrow();
            values = values.sorted(comparator);
        }
        if (start > 0L) {
            values = values.skip(start);
        }
        if (limit > 0L) {
            values = values.limit(limit);
        }
        ArrayList<Object> entries = new ArrayList<Object>();
        entries.addAll(values.toList());
        return entries.stream();
    }

    synchronized void remove(Predicate<Object> predicate) {
        List<Object> keys = this.data.entrySet().stream().filter(e -> predicate.test(e.getValue())).map(Map.Entry::getKey).toList();
        this.remove((Iterable)keys);
    }

    public void clear() {
        this.data.clear();
        this.commitMap();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataStorage that = (DataStorage)o;
        return Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hashCode(this.data);
    }

    public String toString() {
        return "DataStructure{data=" + this.data + "}";
    }

    static DataStorage of(Map<Object, Object> data, StorageManager manager) {
        Objects.requireNonNull(data, "data is required");
        Objects.requireNonNull(manager, "manager is required");
        return new DataStorage(data, (Persister)manager);
    }

    private void commitMap() {
        this.persister.store(this.data);
    }

    private void commitEntity(Object entity) {
        this.persister.store(entity);
    }
}

