/*
 * Decompiled with CFR 0.152.
 */
package expert.os.integration.microstream;

import expert.os.integration.microstream.EntityMetadata;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

class Entities {
    private final Map<Class<?>, EntityMetadata> entities;

    private Entities(Map<Class<?>, EntityMetadata> entities) {
        this.entities = entities;
    }

    Optional<EntityMetadata> findType(Class<?> type) {
        Objects.requireNonNull(type, "type is required");
        return Optional.ofNullable(this.entities.get(type));
    }

    static Entities of(Set<Class<?>> entities) {
        Objects.requireNonNull(entities, "entities is required");
        return new Entities(entities.stream().collect(Collectors.toMap(Function.identity(), EntityMetadata::of)));
    }
}

