/*
 * Decompiled with CFR 0.152.
 */
package expert.os.integration.microstream;

import expert.os.integration.microstream.Entry;
import expert.os.integration.microstream.FieldMetadata;
import jakarta.data.exceptions.MappingException;
import jakarta.nosql.Column;
import jakarta.nosql.Id;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

record EntityMetadata(FieldMetadata id, List<FieldMetadata> fields, Class<?> type) {
    private final List<FieldMetadata> fields;

    public List<FieldMetadata> fields() {
        return Collections.unmodifiableList(this.fields);
    }

    Optional<FieldMetadata> field(String name) {
        if (this.id.name().equals(name)) {
            return Optional.ofNullable(this.id);
        }
        return this.fields.stream().filter(f -> f.name().equals(name)).findFirst();
    }

    <T> Predicate<T> isInstance() {
        return this.type::isInstance;
    }

    <T> Entry entry(T entity) {
        Objects.requireNonNull(entity, "entity is required");
        Object key = this.id.get(entity);
        return Entry.of(key, entity);
    }

    static EntityMetadata of(Class<?> type) {
        Objects.requireNonNull(type, "type is required");
        ArrayList<FieldMetadata> fields = new ArrayList<FieldMetadata>();
        FieldMetadata id = null;
        for (Field field : type.getDeclaredFields()) {
            field.setAccessible(true);
            if (field.getAnnotation(Id.class) != null) {
                id = FieldMetadata.of(field);
                continue;
            }
            if (field.getAnnotation(Column.class) == null) continue;
            fields.add(FieldMetadata.of(field));
        }
        if (id == null) {
            throw new MappingException("The entity " + type + " requires at least a field with @jakarta.nosql.Id annotation");
        }
        return new EntityMetadata(id, fields, type);
    }
}

