/*
 * Decompiled with CFR 0.152.
 */
package expert.os.integration.microstream;

import jakarta.data.repository.Page;
import jakarta.data.repository.Pageable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

class MicrostreamPage<T>
implements Page<T> {
    private final List<T> entities;
    private final Pageable pageable;

    private MicrostreamPage(List<T> entities, Pageable pageable) {
        this.entities = entities;
        this.pageable = pageable;
    }

    public long totalElements() {
        throw new UnsupportedOperationException("JNoSQL has no support for this feature yet");
    }

    public long totalPages() {
        throw new UnsupportedOperationException("JNoSQL has no support for this feature yet");
    }

    public List<T> content() {
        return Collections.unmodifiableList(this.entities);
    }

    public boolean hasContent() {
        return !this.entities.isEmpty();
    }

    public int numberOfElements() {
        return this.entities.size();
    }

    public Pageable pageable() {
        return this.pageable;
    }

    public Pageable nextPageable() {
        return this.pageable.next();
    }

    public Iterator<T> iterator() {
        return this.entities.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MicrostreamPage page = (MicrostreamPage)o;
        return Objects.equals(this.entities, page.entities) && Objects.equals(this.pageable, page.pageable);
    }

    public int hashCode() {
        return Objects.hash(this.entities, this.pageable);
    }

    public String toString() {
        return "NoSQLPage{entities=" + this.entities + ", pageable=" + this.pageable + "}";
    }

    static <T> Page<T> of(List<T> entities, Pageable pageable) {
        Objects.requireNonNull(entities, "entities is required");
        Objects.requireNonNull(pageable, "pageable is required");
        return new MicrostreamPage<T>(entities, pageable);
    }

    static long skip(Pageable pageable) {
        Objects.requireNonNull(pageable, "pageable is required");
        return (long)pageable.size() * (pageable.page() - 1L);
    }
}

