/*
 * Decompiled with CFR 0.152.
 */
package expert.os.integration.microstream;

import expert.os.integration.microstream.DataStorage;
import expert.os.integration.microstream.Entities;
import expert.os.integration.microstream.EntityMetadata;
import expert.os.integration.microstream.Entry;
import expert.os.integration.microstream.MapperDelete;
import expert.os.integration.microstream.MapperSelect;
import expert.os.integration.microstream.Microstream;
import jakarta.data.exceptions.MappingException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Typed;
import jakarta.inject.Inject;
import jakarta.nosql.QueryMapper;
import jakarta.nosql.Template;
import java.time.Duration;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

@ApplicationScoped
@Typed(value={Template.class, MicrostreamTemplate.class})
@Default
@Microstream
class MicrostreamTemplate
implements Template {
    private DataStorage data;
    private Entities entities;

    @Inject
    MicrostreamTemplate(DataStorage data, Entities entities) {
        this.data = data;
        this.entities = entities;
    }

    @Deprecated
    MicrostreamTemplate() {
    }

    public <T> T insert(T entity) {
        return this.save(entity);
    }

    public <T> T insert(T entity, Duration ttl) {
        throw new UnsupportedOperationException("The insert with duration is unsupported");
    }

    public <T> Iterable<T> insert(Iterable<T> entities) {
        return this.save(entities);
    }

    public <T> Iterable<T> insert(Iterable<T> entities, Duration ttl) {
        throw new UnsupportedOperationException("The insert with duration is unsupported");
    }

    public <T> T update(T entity) {
        return this.save(entity);
    }

    public <T> Iterable<T> update(Iterable<T> entities) {
        return this.save(entities);
    }

    public <T, K> Optional<T> find(Class<T> type, K id) {
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(id, "id is required");
        Optional entity = this.data.get(id);
        return entity.filter(type::isInstance);
    }

    public <T, K> void delete(Class<T> type, K id) {
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(id, "id is required");
        this.data.remove(id);
    }

    <T, K> void delete(Iterable<K> ids) {
        Objects.requireNonNull(ids, "ids is required");
        this.data.remove(ids);
    }

    void deleteAll() {
        this.data.clear();
    }

    <T> Stream<T> entities() {
        return this.data.values();
    }

    <T> Stream<T> entities(Predicate<?> filter, List<Comparator<?>> sorts, long start, long limit) {
        return this.data.values(filter, sorts, start, limit);
    }

    void remove(Predicate<Object> filter) {
        this.data.remove(filter);
    }

    boolean isEmpty() {
        return this.data.isEmpty();
    }

    long size() {
        return this.data.size();
    }

    public <T> QueryMapper.MapperFrom select(Class<T> type) {
        Objects.requireNonNull(type, "type is required");
        EntityMetadata metadata = this.metadata(type);
        return new MapperSelect(metadata, this);
    }

    public <T> QueryMapper.MapperDeleteFrom delete(Class<T> type) {
        Objects.requireNonNull(type, "type is required");
        EntityMetadata metadata = this.metadata(type);
        return new MapperDelete(metadata, this);
    }

    private <T> T save(T entity) {
        Objects.requireNonNull(entity, "entity is required");
        Entry entry = this.entry(entity);
        this.data.put(entry.key(), entry.value());
        return entity;
    }

    private <T> Iterable<T> save(Iterable<T> entities) {
        Objects.requireNonNull(entities, "entities is required");
        List<Entry> entries = StreamSupport.stream(entities.spliterator(), false).map(this::entry).toList();
        this.data.put(entries);
        return entities;
    }

    <T> EntityMetadata metadata(Class<T> type) {
        Optional<EntityMetadata> metadata = this.entities.findType(type);
        return metadata.orElseThrow(() -> new MappingException("The enity type is not found on mapping: " + type + " The type most annotated with @Entity"));
    }

    private <T> Entry entry(T entity) {
        EntityMetadata metadata = this.metadata(entity.getClass());
        return metadata.entry(entity);
    }
}

