/*
 * Decompiled with CFR 0.152.
 */
package expert.os.integration.microstream;

import expert.os.integration.microstream.Microstream;
import expert.os.integration.microstream.MicrostreamTemplate;
import expert.os.integration.microstream.RepositoryProxySupplier;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class RepositoryBean<T>
implements Bean<T>,
PassivationCapable {
    private static final AnnotationLiteral<Default> DEFAULT_ANNOTATION = new AnnotationLiteral<Default>(){};
    private static final AnnotationLiteral<Any> ANY_ANNOTATION = new AnnotationLiteral<Any>(){};
    private static final AnnotationLiteral<Microstream> MICROSTREAM = new AnnotationLiteral<Microstream>(){};
    private final Class type;
    private final Set<Type> types;
    private final Set<Annotation> qualifiers;

    public RepositoryBean(Class type) {
        this.type = type;
        this.types = Collections.singleton(type);
        this.qualifiers = new HashSet<Annotation>();
        this.qualifiers.add((Annotation)DEFAULT_ANNOTATION);
        this.qualifiers.add((Annotation)ANY_ANNOTATION);
        this.qualifiers.add((Annotation)MICROSTREAM);
    }

    public Class<?> getBeanClass() {
        return this.type;
    }

    public T create(CreationalContext<T> creationalContext) {
        MicrostreamTemplate template = this.getInstance(MicrostreamTemplate.class);
        return (T)RepositoryProxySupplier.INSTANCE.get(this.type, template);
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getId() {
        return this.type.getName();
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isNullable() {
        return false;
    }

    public Class<? extends Annotation> getScope() {
        return ApplicationScoped.class;
    }

    public String getName() {
        return null;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public void destroy(T instance, CreationalContext<T> context) {
    }

    private <T> T getInstance(Class<T> bean) {
        return (T)CDI.current().select(bean, new Annotation[0]).get();
    }
}

