/*
 * Decompiled with CFR 0.152.
 */
package expert.os.integration.microstream;

import jakarta.data.repository.CrudRepository;
import jakarta.data.repository.OrderBy;
import jakarta.data.repository.PageableRepository;
import jakarta.data.repository.Query;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public enum RepositoryType {
    DEFAULT(""),
    FIND_BY("findBy"),
    DELETE_BY("deleteBy"),
    FIND_ALL("findAll"),
    COUNT_BY("countBy"),
    EXISTS_BY("existsBy"),
    UNKNOWN(""),
    OBJECT_METHOD(""),
    QUERY(""),
    ORDER_BY("");

    private static final Predicate<Class<?>> IS_REPOSITORY_METHOD;
    private static final Set<RepositoryType> KEY_WORLD_METHODS;
    private final String keyword;

    private RepositoryType(String keyword) {
        this.keyword = keyword;
    }

    public static RepositoryType of(Method method) {
        Objects.requireNonNull(method, "method is required");
        Class<?> declaringClass = method.getDeclaringClass();
        if (Object.class.equals(declaringClass)) {
            return OBJECT_METHOD;
        }
        if (IS_REPOSITORY_METHOD.test(declaringClass)) {
            return DEFAULT;
        }
        if (((OrderBy[])method.getAnnotationsByType(OrderBy.class)).length > 0) {
            return ORDER_BY;
        }
        if (Objects.nonNull(method.getAnnotation(Query.class))) {
            return QUERY;
        }
        String methodName = method.getName();
        if (RepositoryType.FIND_ALL.keyword.equals(methodName)) {
            return FIND_ALL;
        }
        return KEY_WORLD_METHODS.stream().filter(k -> methodName.startsWith(k.keyword)).findFirst().orElse(UNKNOWN);
    }

    static {
        IS_REPOSITORY_METHOD = Predicate.isEqual(CrudRepository.class).or(Predicate.isEqual(PageableRepository.class));
        KEY_WORLD_METHODS = EnumSet.of(FIND_BY, DELETE_BY, COUNT_BY, EXISTS_BY);
    }
}

