/*
 * Decompiled with CFR 0.152.
 */
package expert.os.integration.microstream;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Disposes;
import jakarta.enterprise.inject.Produces;
import java.util.function.Supplier;
import java.util.logging.Logger;
import one.microstream.persistence.binary.one.microstream.collections.lazy.BinaryHandlerLazyHashMap;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.storage.embedded.configuration.types.EmbeddedStorageConfiguration;
import one.microstream.storage.embedded.types.EmbeddedStorageFoundation;
import one.microstream.storage.embedded.types.EmbeddedStorageManager;
import one.microstream.storage.types.StorageManager;

@ApplicationScoped
class StorageManagerSupplier
implements Supplier<StorageManager> {
    private static final Logger LOGGER = Logger.getLogger(StorageManagerSupplier.class.getName());
    private static final String DEFAULT_PATH = "target/data";

    StorageManagerSupplier() {
    }

    @Override
    @Produces
    @ApplicationScoped
    public StorageManager get() {
        LOGGER.warning("Starting the default Storage Manager where it will use the path target/data overwrite on production");
        EmbeddedStorageFoundation storageFoundation = EmbeddedStorageConfiguration.Builder().setStorageDirectory(DEFAULT_PATH).createEmbeddedStorageFoundation();
        storageFoundation.registerTypeHandler((PersistenceTypeHandler)new BinaryHandlerLazyHashMap());
        EmbeddedStorageManager manager = storageFoundation.createEmbeddedStorageManager();
        return manager.start();
    }

    public void dispose(@Disposes StorageManager manager) {
        manager.shutdown();
    }
}

