/*
 * Decompiled with CFR 0.152.
 */
package expert.os.integration.microstream;

import jakarta.data.exceptions.MappingException;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;

final class FieldMetadata {
    private final Field field;
    private final String name;

    private FieldMetadata(Field field, String name) {
        this.field = field;
        this.name = name;
    }

    Field field() {
        return this.field;
    }

    String name() {
        return this.name;
    }

    <T> Object get(T entity) {
        try {
            return this.field.get(entity);
        }
        catch (IllegalAccessException e) {
            throw new MappingException("It cannot access the value from the field " + this.field + " at the entity " + entity.getClass());
        }
    }

    <T, U extends Comparable> Comparator comparator() {
        Function<Object, Comparable> comp = t -> (Comparable)this.get(t);
        return Comparator.comparing(comp);
    }

    <T, U extends Comparable> Comparator reversed() {
        return this.comparator().reversed();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldMetadata that = (FieldMetadata)o;
        return Objects.equals(this.field, that.field) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.name);
    }

    public String toString() {
        return "FieldMetadata{field=" + this.field + ", name='" + this.name + "'}";
    }

    static FieldMetadata of(Field field) {
        return new FieldMetadata(field, field.getName());
    }
}

