/*
 * Decompiled with CFR 0.152.
 */
package expert.os.integration.microstream;

import expert.os.integration.microstream.MicrostreamPage;
import jakarta.data.repository.Page;
import jakarta.data.repository.Pageable;
import jakarta.data.repository.Sort;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum ReturnType {
    STREAM{

        @Override
        boolean isCompatible(Class<?> type) {
            return Stream.class.equals(type);
        }

        @Override
        <T> Object convert(Stream<T> stream, Pageable pageable) {
            return stream;
        }
    }
    ,
    SET{

        @Override
        boolean isCompatible(Class<?> type) {
            return Set.class.equals(type);
        }

        @Override
        <T> Object convert(Stream<T> stream, Pageable pageable) {
            return stream.collect(Collectors.toUnmodifiableSet());
        }
    }
    ,
    SORTED_SET{

        @Override
        boolean isCompatible(Class<?> type) {
            return NavigableSet.class.equals(type) || SortedSet.class.equals(type);
        }

        @Override
        <T> Object convert(Stream<T> stream, Pageable pageable) {
            return stream.collect(Collectors.toCollection(TreeSet::new));
        }
    }
    ,
    QUEUE{

        @Override
        boolean isCompatible(Class<?> type) {
            return Queue.class.equals(type) || Deque.class.equals(type);
        }

        @Override
        <T> Object convert(Stream<T> stream, Pageable pageable) {
            return stream.collect(Collectors.toCollection(ArrayDeque::new));
        }
    }
    ,
    LIST{

        @Override
        boolean isCompatible(Class<?> type) {
            return List.class.equals(type) || Iterable.class.equals(type) || Collection.class.equals(type);
        }

        @Override
        <T> Object convert(Stream<T> stream, Pageable pageable) {
            return stream.collect(Collectors.toUnmodifiableList());
        }
    }
    ,
    PAGE{

        @Override
        boolean isCompatible(Class<?> type) {
            return Page.class.isAssignableFrom(type);
        }

        @Override
        <T> Object convert(Stream<T> stream, Pageable pageable) {
            List entities = stream.collect(Collectors.toUnmodifiableList());
            return MicrostreamPage.of(entities, Objects.requireNonNullElseGet(pageable, () -> Pageable.ofSize((int)entities.size())));
        }
    }
    ,
    OPTIONAL{

        @Override
        boolean isCompatible(Class<?> type) {
            return Optional.class.isAssignableFrom(type);
        }

        @Override
        <T> Object convert(Stream<T> stream, Pageable pageable) {
            return stream.findFirst();
        }
    }
    ,
    DEFAULT{

        @Override
        boolean isCompatible(Class<?> type) {
            return false;
        }

        @Override
        <T> Object convert(Stream<T> stream, Pageable pageable) {
            return stream.findFirst().orElse(null);
        }
    };


    abstract boolean isCompatible(Class<?> var1);

    abstract <T> Object convert(Stream<T> var1, Pageable var2);

    static ReturnType of(Class<?> type) {
        return Arrays.stream(ReturnType.values()).filter(r -> r.isCompatible(type)).findFirst().orElse(DEFAULT);
    }

    static Pageable pageable(Object[] params) {
        if (params == null) {
            return null;
        }
        for (Object param : params) {
            if (!(param instanceof Pageable)) continue;
            Pageable pageable = (Pageable)param;
            return pageable;
        }
        return null;
    }

    static List<Sort> sort(List<Sort> sorts, Object[] params) {
        ArrayList<Sort> orderBy = new ArrayList<Sort>(sorts);
        orderBy.addAll(ReturnType.sorts(params));
        return orderBy;
    }

    private static List<Sort> sorts(Object[] params) {
        ArrayList<Sort> orderBy = new ArrayList<Sort>();
        if (params == null) {
            return orderBy;
        }
        for (Object param : params) {
            if (param instanceof Sort) {
                Sort sort = (Sort)param;
                orderBy.add(sort);
                continue;
            }
            if (!(param instanceof Pageable)) continue;
            Pageable pageable = (Pageable)param;
            orderBy.addAll(pageable.sorts());
        }
        return orderBy;
    }
}

