/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class BadlyOverriddenAdapter
extends BytecodeScanningDetector
implements Constants2 {
    private BugReporter bugReporter;
    private boolean isAdapter;
    private boolean classReported;
    private Map<String, String> methodMap;

    public BadlyOverriddenAdapter(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.methodMap = new HashMap<String, String>();
    }

    public void visit(JavaClass obj) {
        try {
            this.methodMap.clear();
            JavaClass superClass = obj.getSuperClass();
            if (superClass == null) {
                return;
            }
            String packageName = superClass.getPackageName();
            String className = superClass.getClassName();
            boolean bl = this.isAdapter = className.endsWith("Adapter") && (packageName.equals("java.awt.event") || packageName.equals("javax.swing.event"));
            if (this.isAdapter) {
                Method[] methods = superClass.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    this.methodMap.put(methods[i].getName(), methods[i].getSignature());
                }
                this.classReported = false;
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    public void visit(Method obj) {
        if (this.isAdapter && !this.classReported) {
            String methodName = obj.getName();
            String signature = this.methodMap.get(methodName);
            if (!methodName.equals("<init>") && signature != null && !signature.equals(obj.getSignature())) {
                this.bugReporter.reportBug(new BugInstance("BOA_BADLY_OVERRIDDEN_ADAPTER", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((DismantleBytecode)this));
                this.classReported = true;
            }
        }
    }
}

